<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class cases_add extends cases
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'cases';

	// Page object name
	public $PageObjName = "cases_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (cases)
		if (!isset($GLOBALS["cases"]) || get_class($GLOBALS["cases"]) == PROJECT_NAMESPACE . "cases") {
			$GLOBALS["cases"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["cases"];
		}

		// Table object (clients)
		if (!isset($GLOBALS['clients']))
			$GLOBALS['clients'] = new clients();

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Table object (litigants)
		if (!isset($GLOBALS['litigants']))
			$GLOBALS['litigants'] = new litigants();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'cases');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $cases;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($cases);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "casesview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['CaseID'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->CaseID->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;
	public $DetailPages; // Detail pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("caseslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Update last accessed time
		if ($UserProfile->isValidUser(CurrentUserName(), session_id())) {
		} else {
			Write($Language->phrase("UserProfileCorrupted"));
			$this->terminate();
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->CaseID->Visible = FALSE;
		$this->ClientID->setVisibility();
		$this->LitigantID->setVisibility();
		$this->CaseTypeID->setVisibility();
		$this->CourtID->setVisibility();
		$this->CaseNumber->setVisibility();
		$this->FileNumber->setVisibility();
		$this->EnvelopeNumber->Visible = FALSE;
		$this->ClientStatusID->setVisibility();
		$this->LitigantStatusID->setVisibility();
		$this->CourtTypeID->Visible = FALSE;
		$this->CourtGenderID->Visible = FALSE;
		$this->JudgeID->setVisibility();
		$this->Notes->setVisibility();
		$this->FileLocation->setVisibility();
		$this->_Case->setVisibility();
		$this->CaseEn->Visible = FALSE;
		$this->CaseSortID->setVisibility();
		$this->CaseRegisteredDate->setVisibility();
		$this->CaseStatusID->setVisibility();
		$this->ParentCaseID->setVisibility();
		$this->FileNumber2->Visible = FALSE;
		$this->_UserID->Visible = FALSE;
		$this->CreatedBy->Visible = FALSE;
		$this->CreatedDate->Visible = FALSE;
		$this->UpdatedBy->Visible = FALSE;
		$this->UpdatedDate->Visible = FALSE;
		$this->CaseTypeConv->Visible = FALSE;
		$this->CaseConv->Visible = FALSE;
		$this->ClientStatusConv->Visible = FALSE;
		$this->LitigantStatusConv->Visible = FALSE;
		$this->ClientNameConv->Visible = FALSE;
		$this->LitigantNameConv->Visible = FALSE;
		$this->ClientNameConvFiles->Visible = FALSE;
		$this->LitigantNameConvFiles->Visible = FALSE;
		$this->CaseTypeConvFiles->Visible = FALSE;
		$this->CourtConvFiles->Visible = FALSE;
		$this->FileNumberConvFiles->Visible = FALSE;
		$this->CaseNumberConvFiles->Visible = FALSE;
		$this->NotesConvFiles->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up detail page object
		$this->setupDetailPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->ClientID);
		$this->setupLookupOptions($this->LitigantID);
		$this->setupLookupOptions($this->CaseTypeID);
		$this->setupLookupOptions($this->CourtID);
		$this->setupLookupOptions($this->ClientStatusID);
		$this->setupLookupOptions($this->LitigantStatusID);
		$this->setupLookupOptions($this->CourtTypeID);
		$this->setupLookupOptions($this->CourtGenderID);
		$this->setupLookupOptions($this->JudgeID);
		$this->setupLookupOptions($this->CaseSortID);
		$this->setupLookupOptions($this->CaseStatusID);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("CaseID") !== NULL) {
				$this->CaseID->setQueryStringValue(Get("CaseID"));
				$this->setKey("CaseID", $this->CaseID->CurrentValue); // Set up key
			} else {
				$this->setKey("CaseID", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Set up detail parameters
		$this->setupDetailParms();

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("caseslist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					if ($this->getCurrentDetailTable() <> "") // Master/detail add
						$returnUrl = $this->getDetailUrl();
					else
						$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "caseslist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "casesview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->CaseID->CurrentValue = NULL;
		$this->CaseID->OldValue = $this->CaseID->CurrentValue;
		$this->ClientID->CurrentValue = NULL;
		$this->ClientID->OldValue = $this->ClientID->CurrentValue;
		$this->LitigantID->CurrentValue = 1938;
		$this->CaseTypeID->CurrentValue = NULL;
		$this->CaseTypeID->OldValue = $this->CaseTypeID->CurrentValue;
		$this->CourtID->CurrentValue = NULL;
		$this->CourtID->OldValue = $this->CourtID->CurrentValue;
		$this->CaseNumber->CurrentValue = NULL;
		$this->CaseNumber->OldValue = $this->CaseNumber->CurrentValue;
		$this->FileNumber->CurrentValue = NULL;
		$this->FileNumber->OldValue = $this->FileNumber->CurrentValue;
		$this->EnvelopeNumber->CurrentValue = NULL;
		$this->EnvelopeNumber->OldValue = $this->EnvelopeNumber->CurrentValue;
		$this->ClientStatusID->CurrentValue = 10;
		$this->LitigantStatusID->CurrentValue = 10;
		$this->CourtTypeID->CurrentValue = NULL;
		$this->CourtTypeID->OldValue = $this->CourtTypeID->CurrentValue;
		$this->CourtGenderID->CurrentValue = NULL;
		$this->CourtGenderID->OldValue = $this->CourtGenderID->CurrentValue;
		$this->JudgeID->CurrentValue = NULL;
		$this->JudgeID->OldValue = $this->JudgeID->CurrentValue;
		$this->Notes->CurrentValue = NULL;
		$this->Notes->OldValue = $this->Notes->CurrentValue;
		$this->FileLocation->CurrentValue = NULL;
		$this->FileLocation->OldValue = $this->FileLocation->CurrentValue;
		$this->_Case->CurrentValue = NULL;
		$this->_Case->OldValue = $this->_Case->CurrentValue;
		$this->CaseEn->CurrentValue = NULL;
		$this->CaseEn->OldValue = $this->CaseEn->CurrentValue;
		$this->CaseSortID->CurrentValue = 1;
		$this->CaseRegisteredDate->CurrentValue = NULL;
		$this->CaseRegisteredDate->OldValue = $this->CaseRegisteredDate->CurrentValue;
		$this->CaseStatusID->CurrentValue = 1;
		$this->ParentCaseID->CurrentValue = NULL;
		$this->ParentCaseID->OldValue = $this->ParentCaseID->CurrentValue;
		$this->FileNumber2->CurrentValue = NULL;
		$this->FileNumber2->OldValue = $this->FileNumber2->CurrentValue;
		$this->_UserID->CurrentValue = NULL;
		$this->_UserID->OldValue = $this->_UserID->CurrentValue;
		$this->CreatedBy->CurrentValue = NULL;
		$this->CreatedBy->OldValue = $this->CreatedBy->CurrentValue;
		$this->CreatedDate->CurrentValue = NULL;
		$this->CreatedDate->OldValue = $this->CreatedDate->CurrentValue;
		$this->UpdatedBy->CurrentValue = NULL;
		$this->UpdatedBy->OldValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedDate->CurrentValue = NULL;
		$this->UpdatedDate->OldValue = $this->UpdatedDate->CurrentValue;
		$this->CaseTypeConv->CurrentValue = NULL;
		$this->CaseTypeConv->OldValue = $this->CaseTypeConv->CurrentValue;
		$this->CaseConv->CurrentValue = NULL;
		$this->CaseConv->OldValue = $this->CaseConv->CurrentValue;
		$this->ClientStatusConv->CurrentValue = NULL;
		$this->ClientStatusConv->OldValue = $this->ClientStatusConv->CurrentValue;
		$this->LitigantStatusConv->CurrentValue = NULL;
		$this->LitigantStatusConv->OldValue = $this->LitigantStatusConv->CurrentValue;
		$this->ClientNameConv->CurrentValue = NULL;
		$this->ClientNameConv->OldValue = $this->ClientNameConv->CurrentValue;
		$this->LitigantNameConv->CurrentValue = NULL;
		$this->LitigantNameConv->OldValue = $this->LitigantNameConv->CurrentValue;
		$this->ClientNameConvFiles->CurrentValue = NULL;
		$this->ClientNameConvFiles->OldValue = $this->ClientNameConvFiles->CurrentValue;
		$this->LitigantNameConvFiles->CurrentValue = NULL;
		$this->LitigantNameConvFiles->OldValue = $this->LitigantNameConvFiles->CurrentValue;
		$this->CaseTypeConvFiles->CurrentValue = NULL;
		$this->CaseTypeConvFiles->OldValue = $this->CaseTypeConvFiles->CurrentValue;
		$this->CourtConvFiles->CurrentValue = NULL;
		$this->CourtConvFiles->OldValue = $this->CourtConvFiles->CurrentValue;
		$this->FileNumberConvFiles->CurrentValue = NULL;
		$this->FileNumberConvFiles->OldValue = $this->FileNumberConvFiles->CurrentValue;
		$this->CaseNumberConvFiles->CurrentValue = NULL;
		$this->CaseNumberConvFiles->OldValue = $this->CaseNumberConvFiles->CurrentValue;
		$this->NotesConvFiles->CurrentValue = NULL;
		$this->NotesConvFiles->OldValue = $this->NotesConvFiles->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'ClientID' first before field var 'x_ClientID'
		$val = $CurrentForm->hasValue("ClientID") ? $CurrentForm->getValue("ClientID") : $CurrentForm->getValue("x_ClientID");
		if (!$this->ClientID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ClientID->Visible = FALSE; // Disable update for API request
			else
				$this->ClientID->setFormValue($val);
		}

		// Check field name 'LitigantID' first before field var 'x_LitigantID'
		$val = $CurrentForm->hasValue("LitigantID") ? $CurrentForm->getValue("LitigantID") : $CurrentForm->getValue("x_LitigantID");
		if (!$this->LitigantID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->LitigantID->Visible = FALSE; // Disable update for API request
			else
				$this->LitigantID->setFormValue($val);
		}

		// Check field name 'CaseTypeID' first before field var 'x_CaseTypeID'
		$val = $CurrentForm->hasValue("CaseTypeID") ? $CurrentForm->getValue("CaseTypeID") : $CurrentForm->getValue("x_CaseTypeID");
		if (!$this->CaseTypeID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseTypeID->Visible = FALSE; // Disable update for API request
			else
				$this->CaseTypeID->setFormValue($val);
		}

		// Check field name 'CourtID' first before field var 'x_CourtID'
		$val = $CurrentForm->hasValue("CourtID") ? $CurrentForm->getValue("CourtID") : $CurrentForm->getValue("x_CourtID");
		if (!$this->CourtID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CourtID->Visible = FALSE; // Disable update for API request
			else
				$this->CourtID->setFormValue($val);
		}

		// Check field name 'CaseNumber' first before field var 'x_CaseNumber'
		$val = $CurrentForm->hasValue("CaseNumber") ? $CurrentForm->getValue("CaseNumber") : $CurrentForm->getValue("x_CaseNumber");
		if (!$this->CaseNumber->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseNumber->Visible = FALSE; // Disable update for API request
			else
				$this->CaseNumber->setFormValue($val);
		}

		// Check field name 'FileNumber' first before field var 'x_FileNumber'
		$val = $CurrentForm->hasValue("FileNumber") ? $CurrentForm->getValue("FileNumber") : $CurrentForm->getValue("x_FileNumber");
		if (!$this->FileNumber->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FileNumber->Visible = FALSE; // Disable update for API request
			else
				$this->FileNumber->setFormValue($val);
		}

		// Check field name 'ClientStatusID' first before field var 'x_ClientStatusID'
		$val = $CurrentForm->hasValue("ClientStatusID") ? $CurrentForm->getValue("ClientStatusID") : $CurrentForm->getValue("x_ClientStatusID");
		if (!$this->ClientStatusID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ClientStatusID->Visible = FALSE; // Disable update for API request
			else
				$this->ClientStatusID->setFormValue($val);
		}

		// Check field name 'LitigantStatusID' first before field var 'x_LitigantStatusID'
		$val = $CurrentForm->hasValue("LitigantStatusID") ? $CurrentForm->getValue("LitigantStatusID") : $CurrentForm->getValue("x_LitigantStatusID");
		if (!$this->LitigantStatusID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->LitigantStatusID->Visible = FALSE; // Disable update for API request
			else
				$this->LitigantStatusID->setFormValue($val);
		}

		// Check field name 'JudgeID' first before field var 'x_JudgeID'
		$val = $CurrentForm->hasValue("JudgeID") ? $CurrentForm->getValue("JudgeID") : $CurrentForm->getValue("x_JudgeID");
		if (!$this->JudgeID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->JudgeID->Visible = FALSE; // Disable update for API request
			else
				$this->JudgeID->setFormValue($val);
		}

		// Check field name 'Notes' first before field var 'x_Notes'
		$val = $CurrentForm->hasValue("Notes") ? $CurrentForm->getValue("Notes") : $CurrentForm->getValue("x_Notes");
		if (!$this->Notes->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Notes->Visible = FALSE; // Disable update for API request
			else
				$this->Notes->setFormValue($val);
		}

		// Check field name 'FileLocation' first before field var 'x_FileLocation'
		$val = $CurrentForm->hasValue("FileLocation") ? $CurrentForm->getValue("FileLocation") : $CurrentForm->getValue("x_FileLocation");
		if (!$this->FileLocation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FileLocation->Visible = FALSE; // Disable update for API request
			else
				$this->FileLocation->setFormValue($val);
		}

		// Check field name 'Case' first before field var 'x__Case'
		$val = $CurrentForm->hasValue("Case") ? $CurrentForm->getValue("Case") : $CurrentForm->getValue("x__Case");
		if (!$this->_Case->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_Case->Visible = FALSE; // Disable update for API request
			else
				$this->_Case->setFormValue($val);
		}

		// Check field name 'CaseSortID' first before field var 'x_CaseSortID'
		$val = $CurrentForm->hasValue("CaseSortID") ? $CurrentForm->getValue("CaseSortID") : $CurrentForm->getValue("x_CaseSortID");
		if (!$this->CaseSortID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseSortID->Visible = FALSE; // Disable update for API request
			else
				$this->CaseSortID->setFormValue($val);
		}

		// Check field name 'CaseRegisteredDate' first before field var 'x_CaseRegisteredDate'
		$val = $CurrentForm->hasValue("CaseRegisteredDate") ? $CurrentForm->getValue("CaseRegisteredDate") : $CurrentForm->getValue("x_CaseRegisteredDate");
		if (!$this->CaseRegisteredDate->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseRegisteredDate->Visible = FALSE; // Disable update for API request
			else
				$this->CaseRegisteredDate->setFormValue($val);
			$this->CaseRegisteredDate->CurrentValue = UnFormatDateTime($this->CaseRegisteredDate->CurrentValue, 7);
		}

		// Check field name 'CaseStatusID' first before field var 'x_CaseStatusID'
		$val = $CurrentForm->hasValue("CaseStatusID") ? $CurrentForm->getValue("CaseStatusID") : $CurrentForm->getValue("x_CaseStatusID");
		if (!$this->CaseStatusID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseStatusID->Visible = FALSE; // Disable update for API request
			else
				$this->CaseStatusID->setFormValue($val);
		}

		// Check field name 'ParentCaseID' first before field var 'x_ParentCaseID'
		$val = $CurrentForm->hasValue("ParentCaseID") ? $CurrentForm->getValue("ParentCaseID") : $CurrentForm->getValue("x_ParentCaseID");
		if (!$this->ParentCaseID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ParentCaseID->Visible = FALSE; // Disable update for API request
			else
				$this->ParentCaseID->setFormValue($val);
		}

		// Check field name 'CaseID' first before field var 'x_CaseID'
		$val = $CurrentForm->hasValue("CaseID") ? $CurrentForm->getValue("CaseID") : $CurrentForm->getValue("x_CaseID");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->ClientID->CurrentValue = $this->ClientID->FormValue;
		$this->LitigantID->CurrentValue = $this->LitigantID->FormValue;
		$this->CaseTypeID->CurrentValue = $this->CaseTypeID->FormValue;
		$this->CourtID->CurrentValue = $this->CourtID->FormValue;
		$this->CaseNumber->CurrentValue = $this->CaseNumber->FormValue;
		$this->FileNumber->CurrentValue = $this->FileNumber->FormValue;
		$this->ClientStatusID->CurrentValue = $this->ClientStatusID->FormValue;
		$this->LitigantStatusID->CurrentValue = $this->LitigantStatusID->FormValue;
		$this->JudgeID->CurrentValue = $this->JudgeID->FormValue;
		$this->Notes->CurrentValue = $this->Notes->FormValue;
		$this->FileLocation->CurrentValue = $this->FileLocation->FormValue;
		$this->_Case->CurrentValue = $this->_Case->FormValue;
		$this->CaseSortID->CurrentValue = $this->CaseSortID->FormValue;
		$this->CaseRegisteredDate->CurrentValue = $this->CaseRegisteredDate->FormValue;
		$this->CaseRegisteredDate->CurrentValue = UnFormatDateTime($this->CaseRegisteredDate->CurrentValue, 7);
		$this->CaseStatusID->CurrentValue = $this->CaseStatusID->FormValue;
		$this->ParentCaseID->CurrentValue = $this->ParentCaseID->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->CaseID->setDbValue($row['CaseID']);
		$this->ClientID->setDbValue($row['ClientID']);
		if (array_key_exists('EV__ClientID', $rs->fields)) {
			$this->ClientID->VirtualValue = $rs->fields('EV__ClientID'); // Set up virtual field value
		} else {
			$this->ClientID->VirtualValue = ""; // Clear value
		}
		$this->LitigantID->setDbValue($row['LitigantID']);
		if (array_key_exists('EV__LitigantID', $rs->fields)) {
			$this->LitigantID->VirtualValue = $rs->fields('EV__LitigantID'); // Set up virtual field value
		} else {
			$this->LitigantID->VirtualValue = ""; // Clear value
		}
		$this->CaseTypeID->setDbValue($row['CaseTypeID']);
		if (array_key_exists('EV__CaseTypeID', $rs->fields)) {
			$this->CaseTypeID->VirtualValue = $rs->fields('EV__CaseTypeID'); // Set up virtual field value
		} else {
			$this->CaseTypeID->VirtualValue = ""; // Clear value
		}
		$this->CourtID->setDbValue($row['CourtID']);
		if (array_key_exists('EV__CourtID', $rs->fields)) {
			$this->CourtID->VirtualValue = $rs->fields('EV__CourtID'); // Set up virtual field value
		} else {
			$this->CourtID->VirtualValue = ""; // Clear value
		}
		$this->CaseNumber->setDbValue($row['CaseNumber']);
		$this->FileNumber->setDbValue($row['FileNumber']);
		$this->EnvelopeNumber->setDbValue($row['EnvelopeNumber']);
		$this->ClientStatusID->setDbValue($row['ClientStatusID']);
		if (array_key_exists('EV__ClientStatusID', $rs->fields)) {
			$this->ClientStatusID->VirtualValue = $rs->fields('EV__ClientStatusID'); // Set up virtual field value
		} else {
			$this->ClientStatusID->VirtualValue = ""; // Clear value
		}
		$this->LitigantStatusID->setDbValue($row['LitigantStatusID']);
		if (array_key_exists('EV__LitigantStatusID', $rs->fields)) {
			$this->LitigantStatusID->VirtualValue = $rs->fields('EV__LitigantStatusID'); // Set up virtual field value
		} else {
			$this->LitigantStatusID->VirtualValue = ""; // Clear value
		}
		$this->CourtTypeID->setDbValue($row['CourtTypeID']);
		if (array_key_exists('EV__CourtTypeID', $rs->fields)) {
			$this->CourtTypeID->VirtualValue = $rs->fields('EV__CourtTypeID'); // Set up virtual field value
		} else {
			$this->CourtTypeID->VirtualValue = ""; // Clear value
		}
		$this->CourtGenderID->setDbValue($row['CourtGenderID']);
		if (array_key_exists('EV__CourtGenderID', $rs->fields)) {
			$this->CourtGenderID->VirtualValue = $rs->fields('EV__CourtGenderID'); // Set up virtual field value
		} else {
			$this->CourtGenderID->VirtualValue = ""; // Clear value
		}
		$this->JudgeID->setDbValue($row['JudgeID']);
		if (array_key_exists('EV__JudgeID', $rs->fields)) {
			$this->JudgeID->VirtualValue = $rs->fields('EV__JudgeID'); // Set up virtual field value
		} else {
			$this->JudgeID->VirtualValue = ""; // Clear value
		}
		$this->Notes->setDbValue($row['Notes']);
		$this->FileLocation->setDbValue($row['FileLocation']);
		$this->_Case->setDbValue($row['Case']);
		$this->CaseEn->setDbValue($row['CaseEn']);
		$this->CaseSortID->setDbValue($row['CaseSortID']);
		if (array_key_exists('EV__CaseSortID', $rs->fields)) {
			$this->CaseSortID->VirtualValue = $rs->fields('EV__CaseSortID'); // Set up virtual field value
		} else {
			$this->CaseSortID->VirtualValue = ""; // Clear value
		}
		$this->CaseRegisteredDate->setDbValue($row['CaseRegisteredDate']);
		$this->CaseStatusID->setDbValue($row['CaseStatusID']);
		if (array_key_exists('EV__CaseStatusID', $rs->fields)) {
			$this->CaseStatusID->VirtualValue = $rs->fields('EV__CaseStatusID'); // Set up virtual field value
		} else {
			$this->CaseStatusID->VirtualValue = ""; // Clear value
		}
		$this->ParentCaseID->setDbValue($row['ParentCaseID']);
		$this->FileNumber2->setDbValue($row['FileNumber2']);
		$this->_UserID->setDbValue($row['UserID']);
		$this->CreatedBy->setDbValue($row['CreatedBy']);
		$this->CreatedDate->setDbValue($row['CreatedDate']);
		$this->UpdatedBy->setDbValue($row['UpdatedBy']);
		$this->UpdatedDate->setDbValue($row['UpdatedDate']);
		$this->CaseTypeConv->setDbValue($row['CaseTypeConv']);
		$this->CaseConv->setDbValue($row['CaseConv']);
		$this->ClientStatusConv->setDbValue($row['ClientStatusConv']);
		$this->LitigantStatusConv->setDbValue($row['LitigantStatusConv']);
		$this->ClientNameConv->setDbValue($row['ClientNameConv']);
		$this->LitigantNameConv->setDbValue($row['LitigantNameConv']);
		$this->ClientNameConvFiles->setDbValue($row['ClientNameConvFiles']);
		$this->LitigantNameConvFiles->setDbValue($row['LitigantNameConvFiles']);
		$this->CaseTypeConvFiles->setDbValue($row['CaseTypeConvFiles']);
		$this->CourtConvFiles->setDbValue($row['CourtConvFiles']);
		$this->FileNumberConvFiles->setDbValue($row['FileNumberConvFiles']);
		$this->CaseNumberConvFiles->setDbValue($row['CaseNumberConvFiles']);
		$this->NotesConvFiles->setDbValue($row['NotesConvFiles']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['CaseID'] = $this->CaseID->CurrentValue;
		$row['ClientID'] = $this->ClientID->CurrentValue;
		$row['LitigantID'] = $this->LitigantID->CurrentValue;
		$row['CaseTypeID'] = $this->CaseTypeID->CurrentValue;
		$row['CourtID'] = $this->CourtID->CurrentValue;
		$row['CaseNumber'] = $this->CaseNumber->CurrentValue;
		$row['FileNumber'] = $this->FileNumber->CurrentValue;
		$row['EnvelopeNumber'] = $this->EnvelopeNumber->CurrentValue;
		$row['ClientStatusID'] = $this->ClientStatusID->CurrentValue;
		$row['LitigantStatusID'] = $this->LitigantStatusID->CurrentValue;
		$row['CourtTypeID'] = $this->CourtTypeID->CurrentValue;
		$row['CourtGenderID'] = $this->CourtGenderID->CurrentValue;
		$row['JudgeID'] = $this->JudgeID->CurrentValue;
		$row['Notes'] = $this->Notes->CurrentValue;
		$row['FileLocation'] = $this->FileLocation->CurrentValue;
		$row['Case'] = $this->_Case->CurrentValue;
		$row['CaseEn'] = $this->CaseEn->CurrentValue;
		$row['CaseSortID'] = $this->CaseSortID->CurrentValue;
		$row['CaseRegisteredDate'] = $this->CaseRegisteredDate->CurrentValue;
		$row['CaseStatusID'] = $this->CaseStatusID->CurrentValue;
		$row['ParentCaseID'] = $this->ParentCaseID->CurrentValue;
		$row['FileNumber2'] = $this->FileNumber2->CurrentValue;
		$row['UserID'] = $this->_UserID->CurrentValue;
		$row['CreatedBy'] = $this->CreatedBy->CurrentValue;
		$row['CreatedDate'] = $this->CreatedDate->CurrentValue;
		$row['UpdatedBy'] = $this->UpdatedBy->CurrentValue;
		$row['UpdatedDate'] = $this->UpdatedDate->CurrentValue;
		$row['CaseTypeConv'] = $this->CaseTypeConv->CurrentValue;
		$row['CaseConv'] = $this->CaseConv->CurrentValue;
		$row['ClientStatusConv'] = $this->ClientStatusConv->CurrentValue;
		$row['LitigantStatusConv'] = $this->LitigantStatusConv->CurrentValue;
		$row['ClientNameConv'] = $this->ClientNameConv->CurrentValue;
		$row['LitigantNameConv'] = $this->LitigantNameConv->CurrentValue;
		$row['ClientNameConvFiles'] = $this->ClientNameConvFiles->CurrentValue;
		$row['LitigantNameConvFiles'] = $this->LitigantNameConvFiles->CurrentValue;
		$row['CaseTypeConvFiles'] = $this->CaseTypeConvFiles->CurrentValue;
		$row['CourtConvFiles'] = $this->CourtConvFiles->CurrentValue;
		$row['FileNumberConvFiles'] = $this->FileNumberConvFiles->CurrentValue;
		$row['CaseNumberConvFiles'] = $this->CaseNumberConvFiles->CurrentValue;
		$row['NotesConvFiles'] = $this->NotesConvFiles->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("CaseID")) <> "")
			$this->CaseID->CurrentValue = $this->getKey("CaseID"); // CaseID
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// CaseID
		// ClientID
		// LitigantID
		// CaseTypeID
		// CourtID
		// CaseNumber
		// FileNumber
		// EnvelopeNumber
		// ClientStatusID
		// LitigantStatusID
		// CourtTypeID
		// CourtGenderID
		// JudgeID
		// Notes
		// FileLocation
		// Case
		// CaseEn
		// CaseSortID
		// CaseRegisteredDate
		// CaseStatusID
		// ParentCaseID
		// FileNumber2
		// UserID
		// CreatedBy
		// CreatedDate
		// UpdatedBy
		// UpdatedDate
		// CaseTypeConv
		// CaseConv
		// ClientStatusConv
		// LitigantStatusConv
		// ClientNameConv
		// LitigantNameConv
		// ClientNameConvFiles
		// LitigantNameConvFiles
		// CaseTypeConvFiles
		// CourtConvFiles
		// FileNumberConvFiles
		// CaseNumberConvFiles
		// NotesConvFiles

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// CaseID
			$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
			$this->CaseID->ViewCustomAttributes = "";

			// ClientID
			if ($this->ClientID->VirtualValue <> "") {
				$this->ClientID->ViewValue = $this->ClientID->VirtualValue;
			} else {
				$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
					}
				}
			} else {
				$this->ClientID->ViewValue = NULL;
			}
			}
			$this->ClientID->CssStyle = "font-weight: bold;";
			$this->ClientID->ViewCustomAttributes = "";

			// LitigantID
			if ($this->LitigantID->VirtualValue <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->VirtualValue;
			} else {
				$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->LitigantID->ViewValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
					}
				}
			} else {
				$this->LitigantID->ViewValue = NULL;
			}
			}
			$this->LitigantID->CssStyle = "font-weight: bold;";
			$this->LitigantID->ViewCustomAttributes = "";

			// CaseTypeID
			if ($this->CaseTypeID->VirtualValue <> "") {
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->VirtualValue;
			} else {
			$curVal = strval($this->CaseTypeID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->lookupCacheOption($curVal);
				if ($this->CaseTypeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseTypeID->ViewValue = $this->CaseTypeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseTypeID->ViewValue = $this->CaseTypeID->CurrentValue;
					}
				}
			} else {
				$this->CaseTypeID->ViewValue = NULL;
			}
			}
			$this->CaseTypeID->CssStyle = "font-style: italic;";
			$this->CaseTypeID->ViewCustomAttributes = "";

			// CourtID
			if ($this->CourtID->VirtualValue <> "") {
				$this->CourtID->ViewValue = $this->CourtID->VirtualValue;
			} else {
				$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
			$curVal = strval($this->CourtID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtID->ViewValue = $this->CourtID->lookupCacheOption($curVal);
				if ($this->CourtID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtID->ViewValue = $this->CourtID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
					}
				}
			} else {
				$this->CourtID->ViewValue = NULL;
			}
			}
			$this->CourtID->ViewCustomAttributes = "";

			// CaseNumber
			$this->CaseNumber->ViewValue = $this->CaseNumber->CurrentValue;
			$this->CaseNumber->ViewCustomAttributes = "";

			// FileNumber
			$this->FileNumber->ViewValue = $this->FileNumber->CurrentValue;
			$this->FileNumber->ViewCustomAttributes = "";

			// ClientStatusID
			if ($this->ClientStatusID->VirtualValue <> "") {
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->VirtualValue;
			} else {
			$curVal = strval($this->ClientStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->lookupCacheOption($curVal);
				if ($this->ClientStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ClientStatusID->ViewValue = $this->ClientStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientStatusID->ViewValue = $this->ClientStatusID->CurrentValue;
					}
				}
			} else {
				$this->ClientStatusID->ViewValue = NULL;
			}
			}
			$this->ClientStatusID->CssStyle = "font-style: italic;";
			$this->ClientStatusID->ViewCustomAttributes = "";

			// LitigantStatusID
			if ($this->LitigantStatusID->VirtualValue <> "") {
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->VirtualValue;
			} else {
			$curVal = strval($this->LitigantStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->lookupCacheOption($curVal);
				if ($this->LitigantStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->CurrentValue;
					}
				}
			} else {
				$this->LitigantStatusID->ViewValue = NULL;
			}
			}
			$this->LitigantStatusID->CssStyle = "font-style: italic;";
			$this->LitigantStatusID->ViewCustomAttributes = "";

			// JudgeID
			if ($this->JudgeID->VirtualValue <> "") {
				$this->JudgeID->ViewValue = $this->JudgeID->VirtualValue;
			} else {
			$curVal = strval($this->JudgeID->CurrentValue);
			if ($curVal <> "") {
				$this->JudgeID->ViewValue = $this->JudgeID->lookupCacheOption($curVal);
				if ($this->JudgeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`JudgeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->JudgeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->JudgeID->ViewValue = $this->JudgeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->JudgeID->ViewValue = $this->JudgeID->CurrentValue;
					}
				}
			} else {
				$this->JudgeID->ViewValue = NULL;
			}
			}
			$this->JudgeID->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// FileLocation
			$this->FileLocation->ViewValue = $this->FileLocation->CurrentValue;
			$this->FileLocation->ViewCustomAttributes = "";

			// Case
			$this->_Case->ViewValue = $this->_Case->CurrentValue;
			$this->_Case->ViewCustomAttributes = "";

			// CaseSortID
			if ($this->CaseSortID->VirtualValue <> "") {
				$this->CaseSortID->ViewValue = $this->CaseSortID->VirtualValue;
			} else {
			$curVal = strval($this->CaseSortID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseSortID->ViewValue = $this->CaseSortID->lookupCacheOption($curVal);
				if ($this->CaseSortID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseSortID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseSortID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseSortID->ViewValue = $this->CaseSortID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseSortID->ViewValue = $this->CaseSortID->CurrentValue;
					}
				}
			} else {
				$this->CaseSortID->ViewValue = NULL;
			}
			}
			$this->CaseSortID->ViewCustomAttributes = "";

			// CaseRegisteredDate
			$this->CaseRegisteredDate->ViewValue = $this->CaseRegisteredDate->CurrentValue;
			$this->CaseRegisteredDate->ViewValue = FormatDateTime($this->CaseRegisteredDate->ViewValue, 7);
			$this->CaseRegisteredDate->ViewCustomAttributes = "";

			// CaseStatusID
			if ($this->CaseStatusID->VirtualValue <> "") {
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->VirtualValue;
			} else {
			$curVal = strval($this->CaseStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->lookupCacheOption($curVal);
				if ($this->CaseStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseStatusID->ViewValue = $this->CaseStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseStatusID->ViewValue = $this->CaseStatusID->CurrentValue;
					}
				}
			} else {
				$this->CaseStatusID->ViewValue = NULL;
			}
			}
			$this->CaseStatusID->CssStyle = "font-style: italic;";
			$this->CaseStatusID->ViewCustomAttributes = "";

			// ParentCaseID
			$this->ParentCaseID->ViewValue = $this->ParentCaseID->CurrentValue;
			$this->ParentCaseID->ViewValue = FormatNumber($this->ParentCaseID->ViewValue, 0, -2, -2, -2);
			$this->ParentCaseID->ViewCustomAttributes = "";

			// ClientNameConvFiles
			$this->ClientNameConvFiles->ViewValue = $this->ClientNameConvFiles->CurrentValue;
			$this->ClientNameConvFiles->ViewCustomAttributes = "";

			// LitigantNameConvFiles
			$this->LitigantNameConvFiles->ViewValue = $this->LitigantNameConvFiles->CurrentValue;
			$this->LitigantNameConvFiles->ViewCustomAttributes = "";

			// CaseTypeConvFiles
			$this->CaseTypeConvFiles->ViewValue = $this->CaseTypeConvFiles->CurrentValue;
			$this->CaseTypeConvFiles->ViewCustomAttributes = "";

			// ClientID
			$this->ClientID->LinkCustomAttributes = "";
			if (!EmptyValue($this->ClientID->CurrentValue)) {
				$this->ClientID->HrefValue = "/home/clientsview.php?showdetail=clientaddress,clientcontact,cases&ClientID=" . $this->ClientID->CurrentValue; // Add prefix/suffix
				$this->ClientID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ClientID->HrefValue = FullUrl($this->ClientID->HrefValue, "href");
			} else {
				$this->ClientID->HrefValue = "";
			}
			$this->ClientID->TooltipValue = "";

			// LitigantID
			$this->LitigantID->LinkCustomAttributes = "";
			if (!EmptyValue($this->LitigantID->CurrentValue)) {
				$this->LitigantID->HrefValue = "/home/litigantsview.php?showdetail=litigantaddress,litigantcontact,cases&LitigantID=" . $this->LitigantID->CurrentValue; // Add prefix/suffix
				$this->LitigantID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->LitigantID->HrefValue = FullUrl($this->LitigantID->HrefValue, "href");
			} else {
				$this->LitigantID->HrefValue = "";
			}
			$this->LitigantID->TooltipValue = "";

			// CaseTypeID
			$this->CaseTypeID->LinkCustomAttributes = "";
			$this->CaseTypeID->HrefValue = "";
			$this->CaseTypeID->TooltipValue = "";

			// CourtID
			$this->CourtID->LinkCustomAttributes = "";
			if (!EmptyValue($this->CourtID->CurrentValue)) {
				$this->CourtID->HrefValue = "/home/courtsview.php?showdetail=courtaddress,courtcontact&CourtID=" . $this->CourtID->CurrentValue; // Add prefix/suffix
				$this->CourtID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->CourtID->HrefValue = FullUrl($this->CourtID->HrefValue, "href");
			} else {
				$this->CourtID->HrefValue = "";
			}
			$this->CourtID->TooltipValue = "";

			// CaseNumber
			$this->CaseNumber->LinkCustomAttributes = "";
			$this->CaseNumber->HrefValue = "";
			$this->CaseNumber->TooltipValue = "";

			// FileNumber
			$this->FileNumber->LinkCustomAttributes = "";
			$this->FileNumber->HrefValue = "";
			$this->FileNumber->TooltipValue = "";

			// ClientStatusID
			$this->ClientStatusID->LinkCustomAttributes = "";
			$this->ClientStatusID->HrefValue = "";
			$this->ClientStatusID->TooltipValue = "";

			// LitigantStatusID
			$this->LitigantStatusID->LinkCustomAttributes = "";
			$this->LitigantStatusID->HrefValue = "";
			$this->LitigantStatusID->TooltipValue = "";

			// JudgeID
			$this->JudgeID->LinkCustomAttributes = "";
			if (!EmptyValue($this->JudgeID->CurrentValue)) {
				$this->JudgeID->HrefValue = "/home/judgesview.php?showdetail=judgecontact,judgeaddress&JudgeID=" . $this->JudgeID->CurrentValue; // Add prefix/suffix
				$this->JudgeID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->JudgeID->HrefValue = FullUrl($this->JudgeID->HrefValue, "href");
			} else {
				$this->JudgeID->HrefValue = "";
			}
			$this->JudgeID->TooltipValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
			$this->Notes->TooltipValue = "";

			// FileLocation
			$this->FileLocation->LinkCustomAttributes = "";
			$this->FileLocation->HrefValue = "";
			$this->FileLocation->TooltipValue = "";

			// Case
			$this->_Case->LinkCustomAttributes = "";
			$this->_Case->HrefValue = "";
			$this->_Case->TooltipValue = "";

			// CaseSortID
			$this->CaseSortID->LinkCustomAttributes = "";
			$this->CaseSortID->HrefValue = "";
			$this->CaseSortID->TooltipValue = "";

			// CaseRegisteredDate
			$this->CaseRegisteredDate->LinkCustomAttributes = "";
			$this->CaseRegisteredDate->HrefValue = "";
			$this->CaseRegisteredDate->TooltipValue = "";

			// CaseStatusID
			$this->CaseStatusID->LinkCustomAttributes = "";
			$this->CaseStatusID->HrefValue = "";
			$this->CaseStatusID->TooltipValue = "";

			// ParentCaseID
			$this->ParentCaseID->LinkCustomAttributes = "";
			$this->ParentCaseID->HrefValue = "";
			$this->ParentCaseID->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// ClientID
			$this->ClientID->EditAttrs["class"] = "form-control";
			$this->ClientID->EditCustomAttributes = "";
			if ($this->ClientID->getSessionValue() <> "") {
				$this->ClientID->CurrentValue = $this->ClientID->getSessionValue();
			if ($this->ClientID->VirtualValue <> "") {
				$this->ClientID->ViewValue = $this->ClientID->VirtualValue;
			} else {
				$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
					}
				}
			} else {
				$this->ClientID->ViewValue = NULL;
			}
			}
			$this->ClientID->CssStyle = "font-weight: bold;";
			$this->ClientID->ViewCustomAttributes = "";
			} else {
			$this->ClientID->EditValue = HtmlEncode($this->ClientID->CurrentValue);
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->EditValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->ClientID->EditValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->EditValue = HtmlEncode($this->ClientID->CurrentValue);
					}
				}
			} else {
				$this->ClientID->EditValue = NULL;
			}
			$this->ClientID->PlaceHolder = RemoveHtml($this->ClientID->caption());
			}

			// LitigantID
			$this->LitigantID->EditAttrs["class"] = "form-control";
			$this->LitigantID->EditCustomAttributes = "";
			if ($this->LitigantID->getSessionValue() <> "") {
				$this->LitigantID->CurrentValue = $this->LitigantID->getSessionValue();
			if ($this->LitigantID->VirtualValue <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->VirtualValue;
			} else {
				$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->LitigantID->ViewValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
					}
				}
			} else {
				$this->LitigantID->ViewValue = NULL;
			}
			}
			$this->LitigantID->CssStyle = "font-weight: bold;";
			$this->LitigantID->ViewCustomAttributes = "";
			} else {
			$this->LitigantID->EditValue = HtmlEncode($this->LitigantID->CurrentValue);
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->EditValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->LitigantID->EditValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->EditValue = HtmlEncode($this->LitigantID->CurrentValue);
					}
				}
			} else {
				$this->LitigantID->EditValue = NULL;
			}
			$this->LitigantID->PlaceHolder = RemoveHtml($this->LitigantID->caption());
			}

			// CaseTypeID
			$this->CaseTypeID->EditAttrs["class"] = "form-control";
			$this->CaseTypeID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CaseTypeID->CurrentValue));
			if ($curVal <> "")
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->lookupCacheOption($curVal);
			else
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->Lookup !== NULL && is_array($this->CaseTypeID->Lookup->Options) ? $curVal : NULL;
			if ($this->CaseTypeID->ViewValue !== NULL) { // Load from cache
				$this->CaseTypeID->EditValue = array_values($this->CaseTypeID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CaseTypeID`" . SearchString("=", $this->CaseTypeID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CaseTypeID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CaseTypeID->EditValue = $arwrk;
			}

			// CourtID
			$this->CourtID->EditAttrs["class"] = "form-control";
			$this->CourtID->EditCustomAttributes = "";
			$this->CourtID->EditValue = HtmlEncode($this->CourtID->CurrentValue);
			$curVal = strval($this->CourtID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtID->EditValue = $this->CourtID->lookupCacheOption($curVal);
				if ($this->CourtID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->CourtID->EditValue = $this->CourtID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtID->EditValue = HtmlEncode($this->CourtID->CurrentValue);
					}
				}
			} else {
				$this->CourtID->EditValue = NULL;
			}
			$this->CourtID->PlaceHolder = RemoveHtml($this->CourtID->caption());

			// CaseNumber
			$this->CaseNumber->EditAttrs["class"] = "form-control";
			$this->CaseNumber->EditCustomAttributes = "";
			$this->CaseNumber->EditValue = HtmlEncode($this->CaseNumber->CurrentValue);
			$this->CaseNumber->PlaceHolder = RemoveHtml($this->CaseNumber->caption());

			// FileNumber
			$this->FileNumber->EditAttrs["class"] = "form-control";
			$this->FileNumber->EditCustomAttributes = "";
			$this->FileNumber->EditValue = HtmlEncode($this->FileNumber->CurrentValue);
			$this->FileNumber->PlaceHolder = RemoveHtml($this->FileNumber->caption());

			// ClientStatusID
			$this->ClientStatusID->EditAttrs["class"] = "form-control";
			$this->ClientStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->ClientStatusID->CurrentValue));
			if ($curVal <> "")
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->lookupCacheOption($curVal);
			else
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->Lookup !== NULL && is_array($this->ClientStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->ClientStatusID->ViewValue !== NULL) { // Load from cache
				$this->ClientStatusID->EditValue = array_values($this->ClientStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $this->ClientStatusID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->ClientStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ClientStatusID->EditValue = $arwrk;
			}

			// LitigantStatusID
			$this->LitigantStatusID->EditAttrs["class"] = "form-control";
			$this->LitigantStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->LitigantStatusID->CurrentValue));
			if ($curVal <> "")
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->lookupCacheOption($curVal);
			else
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->Lookup !== NULL && is_array($this->LitigantStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->LitigantStatusID->ViewValue !== NULL) { // Load from cache
				$this->LitigantStatusID->EditValue = array_values($this->LitigantStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $this->LitigantStatusID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->LitigantStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->LitigantStatusID->EditValue = $arwrk;
			}

			// JudgeID
			$this->JudgeID->EditAttrs["class"] = "form-control";
			$this->JudgeID->EditCustomAttributes = "";
			$curVal = trim(strval($this->JudgeID->CurrentValue));
			if ($curVal <> "")
				$this->JudgeID->ViewValue = $this->JudgeID->lookupCacheOption($curVal);
			else
				$this->JudgeID->ViewValue = $this->JudgeID->Lookup !== NULL && is_array($this->JudgeID->Lookup->Options) ? $curVal : NULL;
			if ($this->JudgeID->ViewValue !== NULL) { // Load from cache
				$this->JudgeID->EditValue = array_values($this->JudgeID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`JudgeID`" . SearchString("=", $this->JudgeID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->JudgeID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->JudgeID->EditValue = $arwrk;
			}

			// Notes
			$this->Notes->EditAttrs["class"] = "form-control";
			$this->Notes->EditCustomAttributes = "";
			$this->Notes->EditValue = HtmlEncode($this->Notes->CurrentValue);
			$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

			// FileLocation
			$this->FileLocation->EditAttrs["class"] = "form-control";
			$this->FileLocation->EditCustomAttributes = "";
			$this->FileLocation->EditValue = HtmlEncode($this->FileLocation->CurrentValue);
			$this->FileLocation->PlaceHolder = RemoveHtml($this->FileLocation->caption());

			// Case
			$this->_Case->EditAttrs["class"] = "form-control";
			$this->_Case->EditCustomAttributes = "";
			$this->_Case->EditValue = HtmlEncode($this->_Case->CurrentValue);
			$this->_Case->PlaceHolder = RemoveHtml($this->_Case->caption());

			// CaseSortID
			$this->CaseSortID->EditAttrs["class"] = "form-control";
			$this->CaseSortID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CaseSortID->CurrentValue));
			if ($curVal <> "")
				$this->CaseSortID->ViewValue = $this->CaseSortID->lookupCacheOption($curVal);
			else
				$this->CaseSortID->ViewValue = $this->CaseSortID->Lookup !== NULL && is_array($this->CaseSortID->Lookup->Options) ? $curVal : NULL;
			if ($this->CaseSortID->ViewValue !== NULL) { // Load from cache
				$this->CaseSortID->EditValue = array_values($this->CaseSortID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CaseSortID`" . SearchString("=", $this->CaseSortID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CaseSortID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CaseSortID->EditValue = $arwrk;
			}

			// CaseRegisteredDate
			$this->CaseRegisteredDate->EditAttrs["class"] = "form-control";
			$this->CaseRegisteredDate->EditCustomAttributes = "";
			$this->CaseRegisteredDate->EditValue = HtmlEncode(FormatDateTime($this->CaseRegisteredDate->CurrentValue, 7));
			$this->CaseRegisteredDate->PlaceHolder = RemoveHtml($this->CaseRegisteredDate->caption());

			// CaseStatusID
			$this->CaseStatusID->EditAttrs["class"] = "form-control";
			$this->CaseStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CaseStatusID->CurrentValue));
			if ($curVal <> "")
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->lookupCacheOption($curVal);
			else
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->Lookup !== NULL && is_array($this->CaseStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->CaseStatusID->ViewValue !== NULL) { // Load from cache
				$this->CaseStatusID->EditValue = array_values($this->CaseStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CaseStatusID`" . SearchString("=", $this->CaseStatusID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CaseStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CaseStatusID->EditValue = $arwrk;
			}

			// ParentCaseID
			$this->ParentCaseID->EditAttrs["class"] = "form-control";
			$this->ParentCaseID->EditCustomAttributes = "";
			$this->ParentCaseID->EditValue = HtmlEncode($this->ParentCaseID->CurrentValue);
			$this->ParentCaseID->PlaceHolder = RemoveHtml($this->ParentCaseID->caption());

			// Add refer script
			// ClientID

			$this->ClientID->LinkCustomAttributes = "";
			if (!EmptyValue($this->ClientID->CurrentValue)) {
				$this->ClientID->HrefValue = "/home/clientsview.php?showdetail=clientaddress,clientcontact,cases&ClientID=" . $this->ClientID->CurrentValue; // Add prefix/suffix
				$this->ClientID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ClientID->HrefValue = FullUrl($this->ClientID->HrefValue, "href");
			} else {
				$this->ClientID->HrefValue = "";
			}

			// LitigantID
			$this->LitigantID->LinkCustomAttributes = "";
			if (!EmptyValue($this->LitigantID->CurrentValue)) {
				$this->LitigantID->HrefValue = "/home/litigantsview.php?showdetail=litigantaddress,litigantcontact,cases&LitigantID=" . $this->LitigantID->CurrentValue; // Add prefix/suffix
				$this->LitigantID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->LitigantID->HrefValue = FullUrl($this->LitigantID->HrefValue, "href");
			} else {
				$this->LitigantID->HrefValue = "";
			}

			// CaseTypeID
			$this->CaseTypeID->LinkCustomAttributes = "";
			$this->CaseTypeID->HrefValue = "";

			// CourtID
			$this->CourtID->LinkCustomAttributes = "";
			if (!EmptyValue($this->CourtID->CurrentValue)) {
				$this->CourtID->HrefValue = "/home/courtsview.php?showdetail=courtaddress,courtcontact&CourtID=" . $this->CourtID->CurrentValue; // Add prefix/suffix
				$this->CourtID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->CourtID->HrefValue = FullUrl($this->CourtID->HrefValue, "href");
			} else {
				$this->CourtID->HrefValue = "";
			}

			// CaseNumber
			$this->CaseNumber->LinkCustomAttributes = "";
			$this->CaseNumber->HrefValue = "";

			// FileNumber
			$this->FileNumber->LinkCustomAttributes = "";
			$this->FileNumber->HrefValue = "";

			// ClientStatusID
			$this->ClientStatusID->LinkCustomAttributes = "";
			$this->ClientStatusID->HrefValue = "";

			// LitigantStatusID
			$this->LitigantStatusID->LinkCustomAttributes = "";
			$this->LitigantStatusID->HrefValue = "";

			// JudgeID
			$this->JudgeID->LinkCustomAttributes = "";
			if (!EmptyValue($this->JudgeID->CurrentValue)) {
				$this->JudgeID->HrefValue = "/home/judgesview.php?showdetail=judgecontact,judgeaddress&JudgeID=" . $this->JudgeID->CurrentValue; // Add prefix/suffix
				$this->JudgeID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->JudgeID->HrefValue = FullUrl($this->JudgeID->HrefValue, "href");
			} else {
				$this->JudgeID->HrefValue = "";
			}

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";

			// FileLocation
			$this->FileLocation->LinkCustomAttributes = "";
			$this->FileLocation->HrefValue = "";

			// Case
			$this->_Case->LinkCustomAttributes = "";
			$this->_Case->HrefValue = "";

			// CaseSortID
			$this->CaseSortID->LinkCustomAttributes = "";
			$this->CaseSortID->HrefValue = "";

			// CaseRegisteredDate
			$this->CaseRegisteredDate->LinkCustomAttributes = "";
			$this->CaseRegisteredDate->HrefValue = "";

			// CaseStatusID
			$this->CaseStatusID->LinkCustomAttributes = "";
			$this->CaseStatusID->HrefValue = "";

			// ParentCaseID
			$this->ParentCaseID->LinkCustomAttributes = "";
			$this->ParentCaseID->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->CaseID->Required) {
			if (!$this->CaseID->IsDetailKey && $this->CaseID->FormValue != NULL && $this->CaseID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseID->caption(), $this->CaseID->RequiredErrorMessage));
			}
		}
		if ($this->ClientID->Required) {
			if (!$this->ClientID->IsDetailKey && $this->ClientID->FormValue != NULL && $this->ClientID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientID->caption(), $this->ClientID->RequiredErrorMessage));
			}
		}
		if ($this->LitigantID->Required) {
			if (!$this->LitigantID->IsDetailKey && $this->LitigantID->FormValue != NULL && $this->LitigantID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantID->caption(), $this->LitigantID->RequiredErrorMessage));
			}
		}
		if ($this->CaseTypeID->Required) {
			if (!$this->CaseTypeID->IsDetailKey && $this->CaseTypeID->FormValue != NULL && $this->CaseTypeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseTypeID->caption(), $this->CaseTypeID->RequiredErrorMessage));
			}
		}
		if ($this->CourtID->Required) {
			if (!$this->CourtID->IsDetailKey && $this->CourtID->FormValue != NULL && $this->CourtID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtID->caption(), $this->CourtID->RequiredErrorMessage));
			}
		}
		if ($this->CaseNumber->Required) {
			if (!$this->CaseNumber->IsDetailKey && $this->CaseNumber->FormValue != NULL && $this->CaseNumber->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseNumber->caption(), $this->CaseNumber->RequiredErrorMessage));
			}
		}
		if ($this->FileNumber->Required) {
			if (!$this->FileNumber->IsDetailKey && $this->FileNumber->FormValue != NULL && $this->FileNumber->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FileNumber->caption(), $this->FileNumber->RequiredErrorMessage));
			}
		}
		if ($this->EnvelopeNumber->Required) {
			if (!$this->EnvelopeNumber->IsDetailKey && $this->EnvelopeNumber->FormValue != NULL && $this->EnvelopeNumber->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->EnvelopeNumber->caption(), $this->EnvelopeNumber->RequiredErrorMessage));
			}
		}
		if ($this->ClientStatusID->Required) {
			if (!$this->ClientStatusID->IsDetailKey && $this->ClientStatusID->FormValue != NULL && $this->ClientStatusID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientStatusID->caption(), $this->ClientStatusID->RequiredErrorMessage));
			}
		}
		if ($this->LitigantStatusID->Required) {
			if (!$this->LitigantStatusID->IsDetailKey && $this->LitigantStatusID->FormValue != NULL && $this->LitigantStatusID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantStatusID->caption(), $this->LitigantStatusID->RequiredErrorMessage));
			}
		}
		if ($this->CourtTypeID->Required) {
			if (!$this->CourtTypeID->IsDetailKey && $this->CourtTypeID->FormValue != NULL && $this->CourtTypeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtTypeID->caption(), $this->CourtTypeID->RequiredErrorMessage));
			}
		}
		if ($this->CourtGenderID->Required) {
			if (!$this->CourtGenderID->IsDetailKey && $this->CourtGenderID->FormValue != NULL && $this->CourtGenderID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtGenderID->caption(), $this->CourtGenderID->RequiredErrorMessage));
			}
		}
		if ($this->JudgeID->Required) {
			if (!$this->JudgeID->IsDetailKey && $this->JudgeID->FormValue != NULL && $this->JudgeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->JudgeID->caption(), $this->JudgeID->RequiredErrorMessage));
			}
		}
		if ($this->Notes->Required) {
			if (!$this->Notes->IsDetailKey && $this->Notes->FormValue != NULL && $this->Notes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Notes->caption(), $this->Notes->RequiredErrorMessage));
			}
		}
		if ($this->FileLocation->Required) {
			if (!$this->FileLocation->IsDetailKey && $this->FileLocation->FormValue != NULL && $this->FileLocation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FileLocation->caption(), $this->FileLocation->RequiredErrorMessage));
			}
		}
		if ($this->_Case->Required) {
			if (!$this->_Case->IsDetailKey && $this->_Case->FormValue != NULL && $this->_Case->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_Case->caption(), $this->_Case->RequiredErrorMessage));
			}
		}
		if ($this->CaseEn->Required) {
			if (!$this->CaseEn->IsDetailKey && $this->CaseEn->FormValue != NULL && $this->CaseEn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseEn->caption(), $this->CaseEn->RequiredErrorMessage));
			}
		}
		if ($this->CaseSortID->Required) {
			if (!$this->CaseSortID->IsDetailKey && $this->CaseSortID->FormValue != NULL && $this->CaseSortID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseSortID->caption(), $this->CaseSortID->RequiredErrorMessage));
			}
		}
		if ($this->CaseRegisteredDate->Required) {
			if (!$this->CaseRegisteredDate->IsDetailKey && $this->CaseRegisteredDate->FormValue != NULL && $this->CaseRegisteredDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseRegisteredDate->caption(), $this->CaseRegisteredDate->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->CaseRegisteredDate->FormValue)) {
			AddMessage($FormError, $this->CaseRegisteredDate->errorMessage());
		}
		if ($this->CaseStatusID->Required) {
			if (!$this->CaseStatusID->IsDetailKey && $this->CaseStatusID->FormValue != NULL && $this->CaseStatusID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseStatusID->caption(), $this->CaseStatusID->RequiredErrorMessage));
			}
		}
		if ($this->ParentCaseID->Required) {
			if (!$this->ParentCaseID->IsDetailKey && $this->ParentCaseID->FormValue != NULL && $this->ParentCaseID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ParentCaseID->caption(), $this->ParentCaseID->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->ParentCaseID->FormValue)) {
			AddMessage($FormError, $this->ParentCaseID->errorMessage());
		}
		if ($this->FileNumber2->Required) {
			if (!$this->FileNumber2->IsDetailKey && $this->FileNumber2->FormValue != NULL && $this->FileNumber2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FileNumber2->caption(), $this->FileNumber2->RequiredErrorMessage));
			}
		}
		if ($this->_UserID->Required) {
			if (!$this->_UserID->IsDetailKey && $this->_UserID->FormValue != NULL && $this->_UserID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_UserID->caption(), $this->_UserID->RequiredErrorMessage));
			}
		}
		if ($this->CreatedBy->Required) {
			if (!$this->CreatedBy->IsDetailKey && $this->CreatedBy->FormValue != NULL && $this->CreatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedBy->caption(), $this->CreatedBy->RequiredErrorMessage));
			}
		}
		if ($this->CreatedDate->Required) {
			if (!$this->CreatedDate->IsDetailKey && $this->CreatedDate->FormValue != NULL && $this->CreatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedDate->caption(), $this->CreatedDate->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedBy->Required) {
			if (!$this->UpdatedBy->IsDetailKey && $this->UpdatedBy->FormValue != NULL && $this->UpdatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedBy->caption(), $this->UpdatedBy->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedDate->Required) {
			if (!$this->UpdatedDate->IsDetailKey && $this->UpdatedDate->FormValue != NULL && $this->UpdatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedDate->caption(), $this->UpdatedDate->RequiredErrorMessage));
			}
		}
		if ($this->CaseTypeConv->Required) {
			if (!$this->CaseTypeConv->IsDetailKey && $this->CaseTypeConv->FormValue != NULL && $this->CaseTypeConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseTypeConv->caption(), $this->CaseTypeConv->RequiredErrorMessage));
			}
		}
		if ($this->CaseConv->Required) {
			if (!$this->CaseConv->IsDetailKey && $this->CaseConv->FormValue != NULL && $this->CaseConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseConv->caption(), $this->CaseConv->RequiredErrorMessage));
			}
		}
		if ($this->ClientStatusConv->Required) {
			if (!$this->ClientStatusConv->IsDetailKey && $this->ClientStatusConv->FormValue != NULL && $this->ClientStatusConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientStatusConv->caption(), $this->ClientStatusConv->RequiredErrorMessage));
			}
		}
		if ($this->LitigantStatusConv->Required) {
			if (!$this->LitigantStatusConv->IsDetailKey && $this->LitigantStatusConv->FormValue != NULL && $this->LitigantStatusConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantStatusConv->caption(), $this->LitigantStatusConv->RequiredErrorMessage));
			}
		}
		if ($this->ClientNameConv->Required) {
			if (!$this->ClientNameConv->IsDetailKey && $this->ClientNameConv->FormValue != NULL && $this->ClientNameConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientNameConv->caption(), $this->ClientNameConv->RequiredErrorMessage));
			}
		}
		if ($this->LitigantNameConv->Required) {
			if (!$this->LitigantNameConv->IsDetailKey && $this->LitigantNameConv->FormValue != NULL && $this->LitigantNameConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantNameConv->caption(), $this->LitigantNameConv->RequiredErrorMessage));
			}
		}
		if ($this->ClientNameConvFiles->Required) {
			if (!$this->ClientNameConvFiles->IsDetailKey && $this->ClientNameConvFiles->FormValue != NULL && $this->ClientNameConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientNameConvFiles->caption(), $this->ClientNameConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->LitigantNameConvFiles->Required) {
			if (!$this->LitigantNameConvFiles->IsDetailKey && $this->LitigantNameConvFiles->FormValue != NULL && $this->LitigantNameConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantNameConvFiles->caption(), $this->LitigantNameConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->CaseTypeConvFiles->Required) {
			if (!$this->CaseTypeConvFiles->IsDetailKey && $this->CaseTypeConvFiles->FormValue != NULL && $this->CaseTypeConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseTypeConvFiles->caption(), $this->CaseTypeConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->CourtConvFiles->Required) {
			if (!$this->CourtConvFiles->IsDetailKey && $this->CourtConvFiles->FormValue != NULL && $this->CourtConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtConvFiles->caption(), $this->CourtConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->FileNumberConvFiles->Required) {
			if (!$this->FileNumberConvFiles->IsDetailKey && $this->FileNumberConvFiles->FormValue != NULL && $this->FileNumberConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FileNumberConvFiles->caption(), $this->FileNumberConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->CaseNumberConvFiles->Required) {
			if (!$this->CaseNumberConvFiles->IsDetailKey && $this->CaseNumberConvFiles->FormValue != NULL && $this->CaseNumberConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseNumberConvFiles->caption(), $this->CaseNumberConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->NotesConvFiles->Required) {
			if (!$this->NotesConvFiles->IsDetailKey && $this->NotesConvFiles->FormValue != NULL && $this->NotesConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NotesConvFiles->caption(), $this->NotesConvFiles->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("hearings", $detailTblVar) && $GLOBALS["hearings"]->DetailAdd) {
			if (!isset($GLOBALS["hearings_grid"]))
				$GLOBALS["hearings_grid"] = new hearings_grid(); // Get detail page object
			$GLOBALS["hearings_grid"]->validateGridForm();
		}
		if (in_array("notices", $detailTblVar) && $GLOBALS["notices"]->DetailAdd) {
			if (!isset($GLOBALS["notices_grid"]))
				$GLOBALS["notices_grid"] = new notices_grid(); // Get detail page object
			$GLOBALS["notices_grid"]->validateGridForm();
		}
		if (in_array("complaints", $detailTblVar) && $GLOBALS["complaints"]->DetailAdd) {
			if (!isset($GLOBALS["complaints_grid"]))
				$GLOBALS["complaints_grid"] = new complaints_grid(); // Get detail page object
			$GLOBALS["complaints_grid"]->validateGridForm();
		}
		if (in_array("notifications", $detailTblVar) && $GLOBALS["notifications"]->DetailAdd) {
			if (!isset($GLOBALS["notifications_grid"]))
				$GLOBALS["notifications_grid"] = new notifications_grid(); // Get detail page object
			$GLOBALS["notifications_grid"]->validateGridForm();
		}
		if (in_array("attachments", $detailTblVar) && $GLOBALS["attachments"]->DetailAdd) {
			if (!isset($GLOBALS["attachments_grid"]))
				$GLOBALS["attachments_grid"] = new attachments_grid(); // Get detail page object
			$GLOBALS["attachments_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		if ($this->FileNumber->CurrentValue <> "") { // Check field with unique index
			$filter = "(FileNumber = '" . AdjustSql($this->FileNumber->CurrentValue, $this->Dbid) . "')";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->FileNumber->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->FileNumber->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}

		// Check referential integrity for master table 'clients'
		$validMasterRecord = TRUE;
		$masterFilter = $this->sqlMasterFilter_clients();
		if (strval($this->ClientID->CurrentValue) <> "") {
			$masterFilter = str_replace("@ClientID@", AdjustSql($this->ClientID->CurrentValue, "DB"), $masterFilter);
		} else {
			$validMasterRecord = FALSE;
		}
		if ($validMasterRecord) {
			if (!isset($GLOBALS["clients"]))
				$GLOBALS["clients"] = new clients();
			$rsmaster = $GLOBALS["clients"]->loadRs($masterFilter);
			$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
			$rsmaster->close();
		}
		if (!$validMasterRecord) {
			$relatedRecordMsg = str_replace("%t", "clients", $Language->phrase("RelatedRecordRequired"));
			$this->setFailureMessage($relatedRecordMsg);
			return FALSE;
		}

		// Check referential integrity for master table 'litigants'
		$validMasterRecord = TRUE;
		$masterFilter = $this->sqlMasterFilter_litigants();
		if (strval($this->LitigantID->CurrentValue) <> "") {
			$masterFilter = str_replace("@LitigantID@", AdjustSql($this->LitigantID->CurrentValue, "DB"), $masterFilter);
		} else {
			$validMasterRecord = FALSE;
		}
		if ($validMasterRecord) {
			if (!isset($GLOBALS["litigants"]))
				$GLOBALS["litigants"] = new litigants();
			$rsmaster = $GLOBALS["litigants"]->loadRs($masterFilter);
			$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
			$rsmaster->close();
		}
		if (!$validMasterRecord) {
			$relatedRecordMsg = str_replace("%t", "litigants", $Language->phrase("RelatedRecordRequired"));
			$this->setFailureMessage($relatedRecordMsg);
			return FALSE;
		}
		$conn = &$this->getConnection();

		// Begin transaction
		if ($this->getCurrentDetailTable() <> "")
			$conn->beginTrans();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// ClientID
		$this->ClientID->setDbValueDef($rsnew, $this->ClientID->CurrentValue, NULL, FALSE);

		// LitigantID
		$this->LitigantID->setDbValueDef($rsnew, $this->LitigantID->CurrentValue, NULL, FALSE);

		// CaseTypeID
		$this->CaseTypeID->setDbValueDef($rsnew, $this->CaseTypeID->CurrentValue, 0, strval($this->CaseTypeID->CurrentValue) == "");

		// CourtID
		$this->CourtID->setDbValueDef($rsnew, $this->CourtID->CurrentValue, NULL, FALSE);

		// CaseNumber
		$this->CaseNumber->setDbValueDef($rsnew, $this->CaseNumber->CurrentValue, NULL, FALSE);

		// FileNumber
		$this->FileNumber->setDbValueDef($rsnew, $this->FileNumber->CurrentValue, "", FALSE);

		// ClientStatusID
		$this->ClientStatusID->setDbValueDef($rsnew, $this->ClientStatusID->CurrentValue, 0, strval($this->ClientStatusID->CurrentValue) == "");

		// LitigantStatusID
		$this->LitigantStatusID->setDbValueDef($rsnew, $this->LitigantStatusID->CurrentValue, 0, strval($this->LitigantStatusID->CurrentValue) == "");

		// JudgeID
		$this->JudgeID->setDbValueDef($rsnew, $this->JudgeID->CurrentValue, NULL, FALSE);

		// Notes
		$this->Notes->setDbValueDef($rsnew, $this->Notes->CurrentValue, NULL, FALSE);

		// FileLocation
		$this->FileLocation->setDbValueDef($rsnew, $this->FileLocation->CurrentValue, NULL, FALSE);

		// Case
		$this->_Case->setDbValueDef($rsnew, $this->_Case->CurrentValue, NULL, FALSE);

		// CaseSortID
		$this->CaseSortID->setDbValueDef($rsnew, $this->CaseSortID->CurrentValue, 0, strval($this->CaseSortID->CurrentValue) == "");

		// CaseRegisteredDate
		$this->CaseRegisteredDate->setDbValueDef($rsnew, UnFormatDateTime($this->CaseRegisteredDate->CurrentValue, 7), NULL, FALSE);

		// CaseStatusID
		$this->CaseStatusID->setDbValueDef($rsnew, $this->CaseStatusID->CurrentValue, 0, strval($this->CaseStatusID->CurrentValue) == "");

		// ParentCaseID
		$this->ParentCaseID->setDbValueDef($rsnew, $this->ParentCaseID->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}

		// Add detail records
		if ($addRow) {
			$detailTblVar = explode(",", $this->getCurrentDetailTable());
			if (in_array("hearings", $detailTblVar) && $GLOBALS["hearings"]->DetailAdd) {
				$GLOBALS["hearings"]->CaseID->setSessionValue($this->CaseID->CurrentValue); // Set master key
				if (!isset($GLOBALS["hearings_grid"]))
					$GLOBALS["hearings_grid"] = new hearings_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "hearings"); // Load user level of detail table
				$addRow = $GLOBALS["hearings_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow)
					$GLOBALS["hearings"]->CaseID->setSessionValue(""); // Clear master key if insert failed
			}
			if (in_array("notices", $detailTblVar) && $GLOBALS["notices"]->DetailAdd) {
				$GLOBALS["notices"]->CaseID->setSessionValue($this->CaseID->CurrentValue); // Set master key
				if (!isset($GLOBALS["notices_grid"]))
					$GLOBALS["notices_grid"] = new notices_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "notices"); // Load user level of detail table
				$addRow = $GLOBALS["notices_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow)
					$GLOBALS["notices"]->CaseID->setSessionValue(""); // Clear master key if insert failed
			}
			if (in_array("complaints", $detailTblVar) && $GLOBALS["complaints"]->DetailAdd) {
				$GLOBALS["complaints"]->CaseID->setSessionValue($this->CaseID->CurrentValue); // Set master key
				if (!isset($GLOBALS["complaints_grid"]))
					$GLOBALS["complaints_grid"] = new complaints_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "complaints"); // Load user level of detail table
				$addRow = $GLOBALS["complaints_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow)
					$GLOBALS["complaints"]->CaseID->setSessionValue(""); // Clear master key if insert failed
			}
			if (in_array("notifications", $detailTblVar) && $GLOBALS["notifications"]->DetailAdd) {
				$GLOBALS["notifications"]->CaseID->setSessionValue($this->CaseID->CurrentValue); // Set master key
				if (!isset($GLOBALS["notifications_grid"]))
					$GLOBALS["notifications_grid"] = new notifications_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "notifications"); // Load user level of detail table
				$addRow = $GLOBALS["notifications_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow)
					$GLOBALS["notifications"]->CaseID->setSessionValue(""); // Clear master key if insert failed
			}
			if (in_array("attachments", $detailTblVar) && $GLOBALS["attachments"]->DetailAdd) {
				$GLOBALS["attachments"]->CaseID->setSessionValue($this->CaseID->CurrentValue); // Set master key
				if (!isset($GLOBALS["attachments_grid"]))
					$GLOBALS["attachments_grid"] = new attachments_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "attachments"); // Load user level of detail table
				$addRow = $GLOBALS["attachments_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow)
					$GLOBALS["attachments"]->CaseID->setSessionValue(""); // Clear master key if insert failed
			}
		}

		// Commit/Rollback transaction
		if ($this->getCurrentDetailTable() <> "") {
			if ($addRow) {
				$conn->commitTrans(); // Commit transaction
			} else {
				$conn->rollbackTrans(); // Rollback transaction
			}
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (Get(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Get(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "clients") {
				$validMaster = TRUE;
				if (Get("fk_ClientID") !== NULL) {
					$GLOBALS["clients"]->ClientID->setQueryStringValue(Get("fk_ClientID"));
					$this->ClientID->setQueryStringValue($GLOBALS["clients"]->ClientID->QueryStringValue);
					$this->ClientID->setSessionValue($this->ClientID->QueryStringValue);
					if (!is_numeric($GLOBALS["clients"]->ClientID->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "litigants") {
				$validMaster = TRUE;
				if (Get("fk_LitigantID") !== NULL) {
					$GLOBALS["litigants"]->LitigantID->setQueryStringValue(Get("fk_LitigantID"));
					$this->LitigantID->setQueryStringValue($GLOBALS["litigants"]->LitigantID->QueryStringValue);
					$this->LitigantID->setSessionValue($this->LitigantID->QueryStringValue);
					if (!is_numeric($GLOBALS["litigants"]->LitigantID->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (Post(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Post(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "clients") {
				$validMaster = TRUE;
				if (Post("fk_ClientID") !== NULL) {
					$GLOBALS["clients"]->ClientID->setFormValue(Post("fk_ClientID"));
					$this->ClientID->setFormValue($GLOBALS["clients"]->ClientID->FormValue);
					$this->ClientID->setSessionValue($this->ClientID->FormValue);
					if (!is_numeric($GLOBALS["clients"]->ClientID->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "litigants") {
				$validMaster = TRUE;
				if (Post("fk_LitigantID") !== NULL) {
					$GLOBALS["litigants"]->LitigantID->setFormValue(Post("fk_LitigantID"));
					$this->LitigantID->setFormValue($GLOBALS["litigants"]->LitigantID->FormValue);
					$this->LitigantID->setSessionValue($this->LitigantID->FormValue);
					if (!is_numeric($GLOBALS["litigants"]->LitigantID->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRec = 1;
				$this->setStartRecordNumber($this->StartRec);
			}

			// Clear previous master key from Session
			if ($masterTblVar <> "clients") {
				if ($this->ClientID->CurrentValue == "")
					$this->ClientID->setSessionValue("");
			}
			if ($masterTblVar <> "litigants") {
				if ($this->LitigantID->CurrentValue == "")
					$this->LitigantID->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		if (Get(TABLE_SHOW_DETAIL) !== NULL) {
			$detailTblVar = Get(TABLE_SHOW_DETAIL);
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar <> "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("hearings", $detailTblVar)) {
				if (!isset($GLOBALS["hearings_grid"]))
					$GLOBALS["hearings_grid"] = new hearings_grid();
				if ($GLOBALS["hearings_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["hearings_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["hearings_grid"]->CurrentMode = "add";
					$GLOBALS["hearings_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["hearings_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["hearings_grid"]->setStartRecordNumber(1);
					$GLOBALS["hearings_grid"]->CaseID->IsDetailKey = TRUE;
					$GLOBALS["hearings_grid"]->CaseID->CurrentValue = $this->CaseID->CurrentValue;
					$GLOBALS["hearings_grid"]->CaseID->setSessionValue($GLOBALS["hearings_grid"]->CaseID->CurrentValue);
				}
			}
			if (in_array("notices", $detailTblVar)) {
				if (!isset($GLOBALS["notices_grid"]))
					$GLOBALS["notices_grid"] = new notices_grid();
				if ($GLOBALS["notices_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["notices_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["notices_grid"]->CurrentMode = "add";
					$GLOBALS["notices_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["notices_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["notices_grid"]->setStartRecordNumber(1);
					$GLOBALS["notices_grid"]->CaseID->IsDetailKey = TRUE;
					$GLOBALS["notices_grid"]->CaseID->CurrentValue = $this->CaseID->CurrentValue;
					$GLOBALS["notices_grid"]->CaseID->setSessionValue($GLOBALS["notices_grid"]->CaseID->CurrentValue);
				}
			}
			if (in_array("complaints", $detailTblVar)) {
				if (!isset($GLOBALS["complaints_grid"]))
					$GLOBALS["complaints_grid"] = new complaints_grid();
				if ($GLOBALS["complaints_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["complaints_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["complaints_grid"]->CurrentMode = "add";
					$GLOBALS["complaints_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["complaints_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["complaints_grid"]->setStartRecordNumber(1);
					$GLOBALS["complaints_grid"]->CaseID->IsDetailKey = TRUE;
					$GLOBALS["complaints_grid"]->CaseID->CurrentValue = $this->CaseID->CurrentValue;
					$GLOBALS["complaints_grid"]->CaseID->setSessionValue($GLOBALS["complaints_grid"]->CaseID->CurrentValue);
				}
			}
			if (in_array("notifications", $detailTblVar)) {
				if (!isset($GLOBALS["notifications_grid"]))
					$GLOBALS["notifications_grid"] = new notifications_grid();
				if ($GLOBALS["notifications_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["notifications_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["notifications_grid"]->CurrentMode = "add";
					$GLOBALS["notifications_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["notifications_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["notifications_grid"]->setStartRecordNumber(1);
					$GLOBALS["notifications_grid"]->CaseID->IsDetailKey = TRUE;
					$GLOBALS["notifications_grid"]->CaseID->CurrentValue = $this->CaseID->CurrentValue;
					$GLOBALS["notifications_grid"]->CaseID->setSessionValue($GLOBALS["notifications_grid"]->CaseID->CurrentValue);
				}
			}
			if (in_array("attachments", $detailTblVar)) {
				if (!isset($GLOBALS["attachments_grid"]))
					$GLOBALS["attachments_grid"] = new attachments_grid();
				if ($GLOBALS["attachments_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["attachments_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["attachments_grid"]->CurrentMode = "add";
					$GLOBALS["attachments_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["attachments_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["attachments_grid"]->setStartRecordNumber(1);
					$GLOBALS["attachments_grid"]->CaseID->IsDetailKey = TRUE;
					$GLOBALS["attachments_grid"]->CaseID->CurrentValue = $this->CaseID->CurrentValue;
					$GLOBALS["attachments_grid"]->CaseID->setSessionValue($GLOBALS["attachments_grid"]->CaseID->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("caseslist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Set up detail pages
	protected function setupDetailPages()
	{
		$pages = new SubPages();
		$pages->Style = "tabs";
		$pages->add('hearings');
		$pages->add('notices');
		$pages->add('complaints');
		$pages->add('notifications');
		$pages->add('attachments');
		$this->DetailPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_ClientID":
							break;
						case "x_LitigantID":
							break;
						case "x_CaseTypeID":
							break;
						case "x_CourtID":
							break;
						case "x_ClientStatusID":
							break;
						case "x_LitigantStatusID":
							break;
						case "x_CourtTypeID":
							break;
						case "x_CourtGenderID":
							break;
						case "x_JudgeID":
							break;
						case "x_CaseSortID":
							break;
						case "x_CaseStatusID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
