<?php
namespace PHPMaker2019\project_germanos;

/**
 * Table class for Courts Report
 */
class Courts_Report extends DbTableBase
{
	protected $SqlGroupSelect = "";
	protected $SqlGroupWhere = "";
	protected $SqlGroupGroupBy = "";
	protected $SqlGroupHaving = "";
	protected $SqlGroupOrderBy = "";
	protected $SqlDetailSelect = "";
	protected $SqlDetailWhere = "";
	protected $SqlDetailGroupBy = "";
	protected $SqlDetailHaving = "";
	protected $SqlDetailOrderBy = "";

	// Export
	public $ExportDoc;

	// Fields
	public $courttypeCourtTypeID;
	public $CourtType;
	public $CourtTypeEn;
	public $CourtTypeNotes;
	public $courtLocationCourtLocationID;
	public $CourtLocation;
	public $CourtLocationEn;
	public $CourtLocationGovernorateID;
	public $CourtLocationNotes;
	public $governoratesGovernorateID;
	public $Governorate;
	public $GovernorateEn;
	public $GovernoratesNotes;
	public $ChambersChamberID;
	public $Chamber;
	public $ChamberEn;
	public $chambersNotes;
	public $ChambersActivated;
	public $sectionsSectionID;
	public $Section;
	public $SectionEn;
	public $SectionsNotes;
	public $SectionsActivated;
	public $CourtID;
	public $Court;
	public $CourtEn;
	public $CourtTypeID;
	public $ChamberID;
	public $CourtLocationID;
	public $GovernorateID;
	public $SectionID;
	public $AddressID;
	public $ContactID;
	public $Activated;
	public $Notes;
	public $_UserID;
	public $CreatedBy;
	public $CreatedDate;
	public $UpdatedBy;
	public $UpdatedDate;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'Courts_Report';
		$this->TableName = 'Courts Report';
		$this->TableType = 'REPORT';

		// Update Table
		$this->UpdateTable = "`courtsv`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->UserIDAllowSecurity = 0; // User ID Allow

		// courttypeCourtTypeID
		$this->courttypeCourtTypeID = new DbField('Courts_Report', 'Courts Report', 'x_courttypeCourtTypeID', 'courttypeCourtTypeID', '`courttypeCourtTypeID`', '`courttypeCourtTypeID`', 3, -1, FALSE, '`courttypeCourtTypeID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->courttypeCourtTypeID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->courttypeCourtTypeID->IsPrimaryKey = TRUE; // Primary key field
		$this->courttypeCourtTypeID->Sortable = TRUE; // Allow sort
		$this->courttypeCourtTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->courttypeCourtTypeID->SourceTableVar = 'courtsv';
		$this->fields['courttypeCourtTypeID'] = &$this->courttypeCourtTypeID;

		// CourtType
		$this->CourtType = new DbField('Courts_Report', 'Courts Report', 'x_CourtType', 'CourtType', '`CourtType`', '`CourtType`', 200, -1, FALSE, '`CourtType`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtType->Required = TRUE; // Required field
		$this->CourtType->Sortable = TRUE; // Allow sort
		$this->CourtType->SourceTableVar = 'courtsv';
		$this->fields['CourtType'] = &$this->CourtType;

		// CourtTypeEn
		$this->CourtTypeEn = new DbField('Courts_Report', 'Courts Report', 'x_CourtTypeEn', 'CourtTypeEn', '`CourtTypeEn`', '`CourtTypeEn`', 200, -1, FALSE, '`CourtTypeEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtTypeEn->Required = TRUE; // Required field
		$this->CourtTypeEn->Sortable = TRUE; // Allow sort
		$this->CourtTypeEn->SourceTableVar = 'courtsv';
		$this->fields['CourtTypeEn'] = &$this->CourtTypeEn;

		// CourtTypeNotes
		$this->CourtTypeNotes = new DbField('Courts_Report', 'Courts Report', 'x_CourtTypeNotes', 'CourtTypeNotes', '`CourtTypeNotes`', '`CourtTypeNotes`', 200, -1, FALSE, '`CourtTypeNotes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtTypeNotes->Sortable = TRUE; // Allow sort
		$this->CourtTypeNotes->SourceTableVar = 'courtsv';
		$this->fields['CourtTypeNotes'] = &$this->CourtTypeNotes;

		// courtLocationCourtLocationID
		$this->courtLocationCourtLocationID = new DbField('Courts_Report', 'Courts Report', 'x_courtLocationCourtLocationID', 'courtLocationCourtLocationID', '`courtLocationCourtLocationID`', '`courtLocationCourtLocationID`', 3, -1, FALSE, '`courtLocationCourtLocationID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->courtLocationCourtLocationID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->courtLocationCourtLocationID->IsPrimaryKey = TRUE; // Primary key field
		$this->courtLocationCourtLocationID->Sortable = TRUE; // Allow sort
		$this->courtLocationCourtLocationID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->courtLocationCourtLocationID->SourceTableVar = 'courtsv';
		$this->fields['courtLocationCourtLocationID'] = &$this->courtLocationCourtLocationID;

		// CourtLocation
		$this->CourtLocation = new DbField('Courts_Report', 'Courts Report', 'x_CourtLocation', 'CourtLocation', '`CourtLocation`', '`CourtLocation`', 200, -1, FALSE, '`CourtLocation`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtLocation->Required = TRUE; // Required field
		$this->CourtLocation->Sortable = TRUE; // Allow sort
		$this->CourtLocation->SourceTableVar = 'courtsv';
		$this->fields['CourtLocation'] = &$this->CourtLocation;

		// CourtLocationEn
		$this->CourtLocationEn = new DbField('Courts_Report', 'Courts Report', 'x_CourtLocationEn', 'CourtLocationEn', '`CourtLocationEn`', '`CourtLocationEn`', 200, -1, FALSE, '`CourtLocationEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtLocationEn->Required = TRUE; // Required field
		$this->CourtLocationEn->Sortable = TRUE; // Allow sort
		$this->CourtLocationEn->SourceTableVar = 'courtsv';
		$this->fields['CourtLocationEn'] = &$this->CourtLocationEn;

		// CourtLocationGovernorateID
		$this->CourtLocationGovernorateID = new DbField('Courts_Report', 'Courts Report', 'x_CourtLocationGovernorateID', 'CourtLocationGovernorateID', '`CourtLocationGovernorateID`', '`CourtLocationGovernorateID`', 3, -1, FALSE, '`CourtLocationGovernorateID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtLocationGovernorateID->Required = TRUE; // Required field
		$this->CourtLocationGovernorateID->Sortable = TRUE; // Allow sort
		$this->CourtLocationGovernorateID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->CourtLocationGovernorateID->SourceTableVar = 'courtsv';
		$this->fields['CourtLocationGovernorateID'] = &$this->CourtLocationGovernorateID;

		// CourtLocationNotes
		$this->CourtLocationNotes = new DbField('Courts_Report', 'Courts Report', 'x_CourtLocationNotes', 'CourtLocationNotes', '`CourtLocationNotes`', '`CourtLocationNotes`', 200, -1, FALSE, '`CourtLocationNotes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtLocationNotes->Sortable = TRUE; // Allow sort
		$this->CourtLocationNotes->SourceTableVar = 'courtsv';
		$this->fields['CourtLocationNotes'] = &$this->CourtLocationNotes;

		// governoratesGovernorateID
		$this->governoratesGovernorateID = new DbField('Courts_Report', 'Courts Report', 'x_governoratesGovernorateID', 'governoratesGovernorateID', '`governoratesGovernorateID`', '`governoratesGovernorateID`', 3, -1, FALSE, '`governoratesGovernorateID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->governoratesGovernorateID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->governoratesGovernorateID->IsPrimaryKey = TRUE; // Primary key field
		$this->governoratesGovernorateID->Sortable = TRUE; // Allow sort
		$this->governoratesGovernorateID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->governoratesGovernorateID->SourceTableVar = 'courtsv';
		$this->fields['governoratesGovernorateID'] = &$this->governoratesGovernorateID;

		// Governorate
		$this->Governorate = new DbField('Courts_Report', 'Courts Report', 'x_Governorate', 'Governorate', '`Governorate`', '`Governorate`', 200, -1, FALSE, '`Governorate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Governorate->Required = TRUE; // Required field
		$this->Governorate->Sortable = TRUE; // Allow sort
		$this->Governorate->SourceTableVar = 'courtsv';
		$this->fields['Governorate'] = &$this->Governorate;

		// GovernorateEn
		$this->GovernorateEn = new DbField('Courts_Report', 'Courts Report', 'x_GovernorateEn', 'GovernorateEn', '`GovernorateEn`', '`GovernorateEn`', 200, -1, FALSE, '`GovernorateEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->GovernorateEn->Required = TRUE; // Required field
		$this->GovernorateEn->Sortable = TRUE; // Allow sort
		$this->GovernorateEn->SourceTableVar = 'courtsv';
		$this->fields['GovernorateEn'] = &$this->GovernorateEn;

		// GovernoratesNotes
		$this->GovernoratesNotes = new DbField('Courts_Report', 'Courts Report', 'x_GovernoratesNotes', 'GovernoratesNotes', '`GovernoratesNotes`', '`GovernoratesNotes`', 200, -1, FALSE, '`GovernoratesNotes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->GovernoratesNotes->Sortable = TRUE; // Allow sort
		$this->GovernoratesNotes->SourceTableVar = 'courtsv';
		$this->fields['GovernoratesNotes'] = &$this->GovernoratesNotes;

		// ChambersChamberID
		$this->ChambersChamberID = new DbField('Courts_Report', 'Courts Report', 'x_ChambersChamberID', 'ChambersChamberID', '`ChambersChamberID`', '`ChambersChamberID`', 3, -1, FALSE, '`ChambersChamberID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->ChambersChamberID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->ChambersChamberID->IsPrimaryKey = TRUE; // Primary key field
		$this->ChambersChamberID->Sortable = TRUE; // Allow sort
		$this->ChambersChamberID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->ChambersChamberID->SourceTableVar = 'courtsv';
		$this->fields['ChambersChamberID'] = &$this->ChambersChamberID;

		// Chamber
		$this->Chamber = new DbField('Courts_Report', 'Courts Report', 'x_Chamber', 'Chamber', '`Chamber`', '`Chamber`', 200, -1, FALSE, '`Chamber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Chamber->Required = TRUE; // Required field
		$this->Chamber->Sortable = TRUE; // Allow sort
		$this->Chamber->SourceTableVar = 'courtsv';
		$this->fields['Chamber'] = &$this->Chamber;

		// ChamberEn
		$this->ChamberEn = new DbField('Courts_Report', 'Courts Report', 'x_ChamberEn', 'ChamberEn', '`ChamberEn`', '`ChamberEn`', 200, -1, FALSE, '`ChamberEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ChamberEn->Sortable = TRUE; // Allow sort
		$this->ChamberEn->SourceTableVar = 'courtsv';
		$this->fields['ChamberEn'] = &$this->ChamberEn;

		// chambersNotes
		$this->chambersNotes = new DbField('Courts_Report', 'Courts Report', 'x_chambersNotes', 'chambersNotes', '`chambersNotes`', '`chambersNotes`', 201, -1, FALSE, '`chambersNotes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->chambersNotes->Sortable = TRUE; // Allow sort
		$this->chambersNotes->SourceTableVar = 'courtsv';
		$this->fields['chambersNotes'] = &$this->chambersNotes;

		// ChambersActivated
		$this->ChambersActivated = new DbField('Courts_Report', 'Courts Report', 'x_ChambersActivated', 'ChambersActivated', '`ChambersActivated`', '`ChambersActivated`', 202, -1, FALSE, '`ChambersActivated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->ChambersActivated->Sortable = TRUE; // Allow sort
		$this->ChambersActivated->DataType = DATATYPE_BOOLEAN;
		$this->ChambersActivated->TrueValue = 'Y';
		$this->ChambersActivated->FalseValue = 'N';
		switch ($CurrentLanguage) {
			case "ar":
				$this->ChambersActivated->Lookup = new Lookup('ChambersActivated', 'Courts_Report', FALSE, '', [null,null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->ChambersActivated->Lookup = new Lookup('ChambersActivated', 'Courts_Report', FALSE, '', [null,null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->ChambersActivated->Lookup = new Lookup('ChambersActivated', 'Courts_Report', FALSE, '', [null,null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->ChambersActivated->Lookup = new Lookup('ChambersActivated', 'Courts_Report', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->ChambersActivated->OptionCount = 2;
		$this->ChambersActivated->SourceTableVar = 'courtsv';
		$this->fields['ChambersActivated'] = &$this->ChambersActivated;

		// sectionsSectionID
		$this->sectionsSectionID = new DbField('Courts_Report', 'Courts Report', 'x_sectionsSectionID', 'sectionsSectionID', '`sectionsSectionID`', '`sectionsSectionID`', 3, -1, FALSE, '`sectionsSectionID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->sectionsSectionID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->sectionsSectionID->IsPrimaryKey = TRUE; // Primary key field
		$this->sectionsSectionID->Sortable = TRUE; // Allow sort
		$this->sectionsSectionID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->sectionsSectionID->SourceTableVar = 'courtsv';
		$this->fields['sectionsSectionID'] = &$this->sectionsSectionID;

		// Section
		$this->Section = new DbField('Courts_Report', 'Courts Report', 'x_Section', 'Section', '`Section`', '`Section`', 200, -1, FALSE, '`Section`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Section->Required = TRUE; // Required field
		$this->Section->Sortable = TRUE; // Allow sort
		$this->Section->SourceTableVar = 'courtsv';
		$this->fields['Section'] = &$this->Section;

		// SectionEn
		$this->SectionEn = new DbField('Courts_Report', 'Courts Report', 'x_SectionEn', 'SectionEn', '`SectionEn`', '`SectionEn`', 200, -1, FALSE, '`SectionEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->SectionEn->Sortable = TRUE; // Allow sort
		$this->SectionEn->SourceTableVar = 'courtsv';
		$this->fields['SectionEn'] = &$this->SectionEn;

		// SectionsNotes
		$this->SectionsNotes = new DbField('Courts_Report', 'Courts Report', 'x_SectionsNotes', 'SectionsNotes', '`SectionsNotes`', '`SectionsNotes`', 201, -1, FALSE, '`SectionsNotes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->SectionsNotes->Sortable = TRUE; // Allow sort
		$this->SectionsNotes->SourceTableVar = 'courtsv';
		$this->fields['SectionsNotes'] = &$this->SectionsNotes;

		// SectionsActivated
		$this->SectionsActivated = new DbField('Courts_Report', 'Courts Report', 'x_SectionsActivated', 'SectionsActivated', '`SectionsActivated`', '`SectionsActivated`', 202, -1, FALSE, '`SectionsActivated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->SectionsActivated->Sortable = TRUE; // Allow sort
		$this->SectionsActivated->DataType = DATATYPE_BOOLEAN;
		$this->SectionsActivated->TrueValue = 'Y';
		$this->SectionsActivated->FalseValue = 'N';
		switch ($CurrentLanguage) {
			case "ar":
				$this->SectionsActivated->Lookup = new Lookup('SectionsActivated', 'Courts_Report', FALSE, '', [null,null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->SectionsActivated->Lookup = new Lookup('SectionsActivated', 'Courts_Report', FALSE, '', [null,null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->SectionsActivated->Lookup = new Lookup('SectionsActivated', 'Courts_Report', FALSE, '', [null,null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->SectionsActivated->Lookup = new Lookup('SectionsActivated', 'Courts_Report', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->SectionsActivated->OptionCount = 2;
		$this->SectionsActivated->SourceTableVar = 'courtsv';
		$this->fields['SectionsActivated'] = &$this->SectionsActivated;

		// CourtID
		$this->CourtID = new DbField('Courts_Report', 'Courts Report', 'x_CourtID', 'CourtID', '`CourtID`', '`CourtID`', 3, -1, FALSE, '`CourtID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->CourtID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->CourtID->IsPrimaryKey = TRUE; // Primary key field
		$this->CourtID->Sortable = TRUE; // Allow sort
		$this->CourtID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->CourtID->SourceTableVar = 'courtsv';
		$this->fields['CourtID'] = &$this->CourtID;

		// Court
		$this->Court = new DbField('Courts_Report', 'Courts Report', 'x_Court', 'Court', '`Court`', '`Court`', 200, -1, FALSE, '`Court`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Court->Nullable = FALSE; // NOT NULL field
		$this->Court->Required = TRUE; // Required field
		$this->Court->Sortable = TRUE; // Allow sort
		$this->Court->SourceTableVar = 'courtsv';
		$this->fields['Court'] = &$this->Court;

		// CourtEn
		$this->CourtEn = new DbField('Courts_Report', 'Courts Report', 'x_CourtEn', 'CourtEn', '`CourtEn`', '`CourtEn`', 200, -1, FALSE, '`CourtEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtEn->Sortable = TRUE; // Allow sort
		$this->CourtEn->SourceTableVar = 'courtsv';
		$this->fields['CourtEn'] = &$this->CourtEn;

		// CourtTypeID
		$this->CourtTypeID = new DbField('Courts_Report', 'Courts Report', 'x_CourtTypeID', 'CourtTypeID', '`CourtTypeID`', '`CourtTypeID`', 3, -1, FALSE, '`CourtTypeID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->CourtTypeID->Nullable = FALSE; // NOT NULL field
		$this->CourtTypeID->Required = TRUE; // Required field
		$this->CourtTypeID->Sortable = TRUE; // Allow sort
		$this->CourtTypeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CourtTypeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', FALSE, 'CourtTypeID', ["CourtType",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', FALSE, 'CourtTypeID', ["CourtType",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', FALSE, 'CourtTypeID', ["CourtType",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', FALSE, 'CourtTypeID', ["CourtType","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->CourtTypeID->SourceTableVar = 'courtsv';
		$this->fields['CourtTypeID'] = &$this->CourtTypeID;

		// ChamberID
		$this->ChamberID = new DbField('Courts_Report', 'Courts Report', 'x_ChamberID', 'ChamberID', '`ChamberID`', '`ChamberID`', 3, -1, FALSE, '`ChamberID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->ChamberID->Sortable = TRUE; // Allow sort
		$this->ChamberID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ChamberID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', FALSE, 'ChamberID', ["Chamber",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', FALSE, 'ChamberID', ["Chamber",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', FALSE, 'ChamberID', ["Chamber",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', FALSE, 'ChamberID', ["Chamber","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->ChamberID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->ChamberID->SourceTableVar = 'courtsv';
		$this->fields['ChamberID'] = &$this->ChamberID;

		// CourtLocationID
		$this->CourtLocationID = new DbField('Courts_Report', 'Courts Report', 'x_CourtLocationID', 'CourtLocationID', '`CourtLocationID`', '`CourtLocationID`', 3, -1, FALSE, '`CourtLocationID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->CourtLocationID->Sortable = TRUE; // Allow sort
		$this->CourtLocationID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CourtLocationID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', FALSE, 'CourtLocationID', ["CourtLocation",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', FALSE, 'CourtLocationID', ["CourtLocation",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', FALSE, 'CourtLocationID', ["CourtLocation",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', FALSE, 'CourtLocationID', ["CourtLocation","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtLocationID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->CourtLocationID->SourceTableVar = 'courtsv';
		$this->fields['CourtLocationID'] = &$this->CourtLocationID;

		// GovernorateID
		$this->GovernorateID = new DbField('Courts_Report', 'Courts Report', 'x_GovernorateID', 'GovernorateID', '`GovernorateID`', '`GovernorateID`', 3, -1, FALSE, '`GovernorateID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->GovernorateID->Sortable = TRUE; // Allow sort
		$this->GovernorateID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->GovernorateID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["Governorate",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["Governorate",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["Governorate",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["Governorate","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->GovernorateID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->GovernorateID->SourceTableVar = 'courtsv';
		$this->fields['GovernorateID'] = &$this->GovernorateID;

		// SectionID
		$this->SectionID = new DbField('Courts_Report', 'Courts Report', 'x_SectionID', 'SectionID', '`SectionID`', '`SectionID`', 3, -1, FALSE, '`SectionID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->SectionID->Sortable = TRUE; // Allow sort
		$this->SectionID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->SectionID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', FALSE, 'SectionID', ["Section",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', FALSE, 'SectionID', ["Section",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', FALSE, 'SectionID', ["Section",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', FALSE, 'SectionID', ["Section","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->SectionID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->SectionID->SourceTableVar = 'courtsv';
		$this->fields['SectionID'] = &$this->SectionID;

		// AddressID
		$this->AddressID = new DbField('Courts_Report', 'Courts Report', 'x_AddressID', 'AddressID', '`AddressID`', '`AddressID`', 3, -1, FALSE, '`AddressID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AddressID->Sortable = TRUE; // Allow sort
		$this->AddressID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->AddressID->SourceTableVar = 'courtsv';
		$this->fields['AddressID'] = &$this->AddressID;

		// ContactID
		$this->ContactID = new DbField('Courts_Report', 'Courts Report', 'x_ContactID', 'ContactID', '`ContactID`', '`ContactID`', 3, -1, FALSE, '`ContactID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ContactID->Sortable = TRUE; // Allow sort
		$this->ContactID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->ContactID->SourceTableVar = 'courtsv';
		$this->fields['ContactID'] = &$this->ContactID;

		// Activated
		$this->Activated = new DbField('Courts_Report', 'Courts Report', 'x_Activated', 'Activated', '`Activated`', '`Activated`', 202, -1, FALSE, '`Activated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->Activated->Nullable = FALSE; // NOT NULL field
		$this->Activated->Sortable = TRUE; // Allow sort
		$this->Activated->DataType = DATATYPE_BOOLEAN;
		$this->Activated->TrueValue = 'Y';
		$this->Activated->FalseValue = 'N';
		switch ($CurrentLanguage) {
			case "ar":
				$this->Activated->Lookup = new Lookup('Activated', 'Courts_Report', FALSE, '', [null,null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->Activated->Lookup = new Lookup('Activated', 'Courts_Report', FALSE, '', [null,null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->Activated->Lookup = new Lookup('Activated', 'Courts_Report', FALSE, '', [null,null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->Activated->Lookup = new Lookup('Activated', 'Courts_Report', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->Activated->OptionCount = 2;
		$this->Activated->SourceTableVar = 'courtsv';
		$this->fields['Activated'] = &$this->Activated;

		// Notes
		$this->Notes = new DbField('Courts_Report', 'Courts Report', 'x_Notes', 'Notes', '`Notes`', '`Notes`', 201, -1, FALSE, '`Notes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Notes->Sortable = TRUE; // Allow sort
		$this->Notes->SourceTableVar = 'courtsv';
		$this->fields['Notes'] = &$this->Notes;

		// UserID
		$this->_UserID = new DbField('Courts_Report', 'Courts Report', 'x__UserID', 'UserID', '`UserID`', '`UserID`', 3, -1, FALSE, '`UserID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_UserID->Sortable = FALSE; // Allow sort
		$this->_UserID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->_UserID->SourceTableVar = 'courtsv';
		$this->fields['UserID'] = &$this->_UserID;

		// CreatedBy
		$this->CreatedBy = new DbField('Courts_Report', 'Courts Report', 'x_CreatedBy', 'CreatedBy', '`CreatedBy`', '`CreatedBy`', 200, -1, FALSE, '`CreatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedBy->Sortable = FALSE; // Allow sort
		$this->CreatedBy->SourceTableVar = 'courtsv';
		$this->fields['CreatedBy'] = &$this->CreatedBy;

		// CreatedDate
		$this->CreatedDate = new DbField('Courts_Report', 'Courts Report', 'x_CreatedDate', 'CreatedDate', '`CreatedDate`', CastDateFieldForLike('`CreatedDate`', 0, "DB"), 135, 0, FALSE, '`CreatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedDate->Sortable = FALSE; // Allow sort
		$this->CreatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->CreatedDate->SourceTableVar = 'courtsv';
		$this->fields['CreatedDate'] = &$this->CreatedDate;

		// UpdatedBy
		$this->UpdatedBy = new DbField('Courts_Report', 'Courts Report', 'x_UpdatedBy', 'UpdatedBy', '`UpdatedBy`', '`UpdatedBy`', 200, -1, FALSE, '`UpdatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedBy->Sortable = FALSE; // Allow sort
		$this->UpdatedBy->SourceTableVar = 'courtsv';
		$this->fields['UpdatedBy'] = &$this->UpdatedBy;

		// UpdatedDate
		$this->UpdatedDate = new DbField('Courts_Report', 'Courts Report', 'x_UpdatedDate', 'UpdatedDate', '`UpdatedDate`', CastDateFieldForLike('`UpdatedDate`', 1, "DB"), 135, 1, FALSE, '`UpdatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedDate->Sortable = FALSE; // Allow sort
		$this->UpdatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->UpdatedDate->SourceTableVar = 'courtsv';
		$this->fields['UpdatedDate'] = &$this->UpdatedDate;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Report group level SQL
	public function getSqlGroupSelect() // Select
	{
		return ($this->SqlGroupSelect <> "") ? $this->SqlGroupSelect : "SELECT DISTINCT `CourtType`,`Governorate`,`CourtLocation` FROM `courtsv`";
	}
	public function sqlGroupSelect() // For backward compatibility
	{
		return $this->getSqlGroupSelect();
	}
	public function setSqlGroupSelect($v)
	{
		$this->SqlGroupSelect = $v;
	}
	public function getSqlGroupWhere() // Where
	{
		return ($this->SqlGroupWhere <> "") ? $this->SqlGroupWhere : "";
	}
	public function sqlGroupWhere() // For backward compatibility
	{
		return $this->getSqlGroupWhere();
	}
	public function setSqlGroupWhere($v)
	{
		$this->SqlGroupWhere = $v;
	}
	public function getSqlGroupGroupBy() // Group By
	{
		return ($this->SqlGroupGroupBy <> "") ? $this->SqlGroupGroupBy : "";
	}
	public function sqlGroupGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupGroupBy();
	}
	public function setSqlGroupGroupBy($v)
	{
		$this->SqlGroupGroupBy = $v;
	}
	public function getSqlGroupHaving() // Having
	{
		return ($this->SqlGroupHaving <> "") ? $this->SqlGroupHaving : "";
	}
	public function sqlGroupHaving() // For backward compatibility
	{
		return $this->getSqlGroupHaving();
	}
	public function setSqlGroupHaving($v)
	{
		$this->SqlGroupHaving = $v;
	}
	public function getSqlGroupOrderBy() // Order By
	{
		return ($this->SqlGroupOrderBy <> "") ? $this->SqlGroupOrderBy : "`CourtType` ASC,`Governorate` ASC,`CourtLocation` ASC";
	}
	public function sqlGroupOrderBy() // For backward compatibility
	{
		return $this->getSqlGroupOrderBy();
	}
	public function setSqlGroupOrderBy($v)
	{
		$this->SqlGroupOrderBy = $v;
	}

	// Report detail level SQL
	public function getSqlDetailSelect() // Select
	{
		return ($this->SqlDetailSelect <> "") ? $this->SqlDetailSelect : "SELECT * FROM `courtsv`";
	}
	public function sqlDetailSelect() // For backward compatibility
	{
		return $this->getSqlDetailSelect();
	}
	public function setSqlDetailSelect($v)
	{
		$this->SqlDetailSelect = $v;
	}
	public function getSqlDetailWhere() // Where
	{
		return ($this->SqlDetailWhere <> "") ? $this->SqlDetailWhere : "";
	}
	public function sqlDetailWhere() // For backward compatibility
	{
		return $this->getSqlDetailWhere();
	}
	public function setSqlDetailWhere($v)
	{
		$this->SqlDetailWhere = $v;
	}
	public function getSqlDetailGroupBy() // Group By
	{
		return ($this->SqlDetailGroupBy <> "") ? $this->SqlDetailGroupBy : "";
	}
	public function sqlDetailGroupBy() // For backward compatibility
	{
		return $this->getSqlDetailGroupBy();
	}
	public function setSqlDetailGroupBy($v)
	{
		$this->SqlDetailGroupBy = $v;
	}
	public function getSqlDetailHaving() // Having
	{
		return ($this->SqlDetailHaving <> "") ? $this->SqlDetailHaving : "";
	}
	public function sqlDetailHaving() // For backward compatibility
	{
		return $this->getSqlDetailHaving();
	}
	public function setSqlDetailHaving($v)
	{
		$this->SqlDetailHaving = $v;
	}
	public function getSqlDetailOrderBy() // Order By
	{
		return ($this->SqlDetailOrderBy <> "") ? $this->SqlDetailOrderBy : "`Court` ASC";
	}
	public function sqlDetailOrderBy() // For backward compatibility
	{
		return $this->getSqlDetailOrderBy();
	}
	public function setSqlDetailOrderBy($v)
	{
		$this->SqlDetailOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Report group SQL
	public function getGroupSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = "";
		return BuildSelectSql($this->getSqlGroupSelect(), $this->getSqlGroupWhere(),
			 $this->getSqlGroupGroupBy(), $this->getSqlGroupHaving(),
			 $this->getSqlGroupOrderBy(), $filter, $sort);
	}

	// Report detail SQL
	public function getDetailSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = "";
		return BuildSelectSql($this->getSqlDetailSelect(), $this->getSqlDetailWhere(),
			$this->getSqlDetailGroupBy(), $this->getSqlDetailHaving(),
			$this->getSqlDetailOrderBy(), $filter, $sort);
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "Courts_Reportreport.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "")
			return $Language->phrase("View");
		elseif ($pageName == "")
			return $Language->phrase("Edit");
		elseif ($pageName == "")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "Courts_Reportreport.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "?" . $this->getUrlParm($parm);
		else
			$url = "";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "courttypeCourtTypeID:" . JsonEncode($this->courttypeCourtTypeID->CurrentValue, "number");
		$json .= ",courtLocationCourtLocationID:" . JsonEncode($this->courtLocationCourtLocationID->CurrentValue, "number");
		$json .= ",governoratesGovernorateID:" . JsonEncode($this->governoratesGovernorateID->CurrentValue, "number");
		$json .= ",ChambersChamberID:" . JsonEncode($this->ChambersChamberID->CurrentValue, "number");
		$json .= ",sectionsSectionID:" . JsonEncode($this->sectionsSectionID->CurrentValue, "number");
		$json .= ",CourtID:" . JsonEncode($this->CourtID->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->courttypeCourtTypeID->CurrentValue != NULL) {
			$url .= "courttypeCourtTypeID=" . urlencode($this->courttypeCourtTypeID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->courtLocationCourtLocationID->CurrentValue != NULL) {
			$url .= "&courtLocationCourtLocationID=" . urlencode($this->courtLocationCourtLocationID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->governoratesGovernorateID->CurrentValue != NULL) {
			$url .= "&governoratesGovernorateID=" . urlencode($this->governoratesGovernorateID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->ChambersChamberID->CurrentValue != NULL) {
			$url .= "&ChambersChamberID=" . urlencode($this->ChambersChamberID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->sectionsSectionID->CurrentValue != NULL) {
			$url .= "&sectionsSectionID=" . urlencode($this->sectionsSectionID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->CourtID->CurrentValue != NULL) {
			$url .= "&CourtID=" . urlencode($this->CourtID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
			for ($i = 0; $i < $cnt; $i++)
				$arKeys[$i] = explode($COMPOSITE_KEY_SEPARATOR, $arKeys[$i]);
		} else {
			if (Param("courttypeCourtTypeID") !== NULL)
				$arKey[] = Param("courttypeCourtTypeID");
			elseif (IsApi() && Key(0) !== NULL)
				$arKey[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKey[] = Route(2);
			else
				$arKeys = NULL; // Do not setup
			if (Param("courtLocationCourtLocationID") !== NULL)
				$arKey[] = Param("courtLocationCourtLocationID");
			elseif (IsApi() && Key(1) !== NULL)
				$arKey[] = Key(1);
			elseif (IsApi() && Route(3) !== NULL)
				$arKey[] = Route(3);
			else
				$arKeys = NULL; // Do not setup
			if (Param("governoratesGovernorateID") !== NULL)
				$arKey[] = Param("governoratesGovernorateID");
			elseif (IsApi() && Key(2) !== NULL)
				$arKey[] = Key(2);
			elseif (IsApi() && Route(4) !== NULL)
				$arKey[] = Route(4);
			else
				$arKeys = NULL; // Do not setup
			if (Param("ChambersChamberID") !== NULL)
				$arKey[] = Param("ChambersChamberID");
			elseif (IsApi() && Key(3) !== NULL)
				$arKey[] = Key(3);
			elseif (IsApi() && Route(5) !== NULL)
				$arKey[] = Route(5);
			else
				$arKeys = NULL; // Do not setup
			if (Param("sectionsSectionID") !== NULL)
				$arKey[] = Param("sectionsSectionID");
			elseif (IsApi() && Key(4) !== NULL)
				$arKey[] = Key(4);
			elseif (IsApi() && Route(6) !== NULL)
				$arKey[] = Route(6);
			else
				$arKeys = NULL; // Do not setup
			if (Param("CourtID") !== NULL)
				$arKey[] = Param("CourtID");
			elseif (IsApi() && Key(5) !== NULL)
				$arKey[] = Key(5);
			elseif (IsApi() && Route(7) !== NULL)
				$arKey[] = Route(7);
			else
				$arKeys = NULL; // Do not setup
			if (is_array($arKeys)) $arKeys[] = $arKey;

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_array($key) || count($key) <> 6)
					continue; // Just skip so other keys will still work
				if (!is_numeric($key[0])) // courttypeCourtTypeID
					continue;
				if (!is_numeric($key[1])) // courtLocationCourtLocationID
					continue;
				if (!is_numeric($key[2])) // governoratesGovernorateID
					continue;
				if (!is_numeric($key[3])) // ChambersChamberID
					continue;
				if (!is_numeric($key[4])) // sectionsSectionID
					continue;
				if (!is_numeric($key[5])) // CourtID
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->courttypeCourtTypeID->CurrentValue = $key[0];
			$this->courtLocationCourtLocationID->CurrentValue = $key[1];
			$this->governoratesGovernorateID->CurrentValue = $key[2];
			$this->ChambersChamberID->CurrentValue = $key[3];
			$this->sectionsSectionID->CurrentValue = $key[4];
			$this->CourtID->CurrentValue = $key[5];
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class Courts_Report_report extends Courts_Report
{

	// Page ID
	public $PageID = "report";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'Courts Report';

	// Page object name
	public $PageObjName = "Courts_Report_report";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (Courts_Report)
		if (!isset($GLOBALS["Courts_Report"]) || get_class($GLOBALS["Courts_Report"]) == PROJECT_NAMESPACE . "Courts_Report") {
			$GLOBALS["Courts_Report"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Courts_Report"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'report');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'Courts Report');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT_REPORT;
		if ($this->isExport() && array_key_exists($this->Export, $EXPORT_REPORT)) {
			$content = ob_get_clean(); // ob_get_contents() and ob_end_clean()
			$fn = $EXPORT_REPORT[$this->Export];
			$this->$fn($content);
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}
	public $ExportOptions; // Export options
	public $RecCnt = 0;
	public $RowCnt = 0; // For custom view tag
	public $ReportSql = "";
	public $ReportFilter = "";
	public $DefaultFilter = "";
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $MasterRecordExists;
	public $Command;
	public $DtlRecordCount;
	public $ReportGroups;
	public $ReportCounts;
	public $LevelBreak;
	public $ReportTotals;
	public $ReportMaxs;
	public $ReportMins;
	public $DetailRecordset;
	public $RecordExists;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canReport()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Setup export options
		$this->setupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();
		$this->ReportGroups = &InitArray(4, NULL);
		$this->ReportCounts = &InitArray(4, 0);
		$this->LevelBreak = &InitArray(4, FALSE);
		$this->ReportTotals = &Init2DArray(4, 4, 0);
		$this->ReportMaxs = &Init2DArray(4, 4, 0);
		$this->ReportMins = &Init2DArray(4, 4, 0);

		// Set up Breadcrumb
		$this->setupBreadcrumb();
	}

	// Check level break
	public function checkLevelBreak()
	{
		$this->LevelBreak[1] = FALSE;
		$this->LevelBreak[2] = FALSE;
		$this->LevelBreak[3] = FALSE;
		if ($this->RecCnt == 0) { // Start Or End of Recordset
			$this->LevelBreak[1] = TRUE;
			$this->LevelBreak[2] = TRUE;
			$this->LevelBreak[3] = TRUE;
		} else {
			if (!CompareValue($this->CourtType->CurrentValue, $this->ReportGroups[0])) {
				$this->LevelBreak[1] = TRUE;
				$this->LevelBreak[2] = TRUE;
				$this->LevelBreak[3] = TRUE;
			}
			if (!CompareValue($this->Governorate->CurrentValue, $this->ReportGroups[1])) {
				$this->LevelBreak[2] = TRUE;
				$this->LevelBreak[3] = TRUE;
			}
			if (!CompareValue($this->CourtLocation->CurrentValue, $this->ReportGroups[2])) {
				$this->LevelBreak[3] = TRUE;
			}
		}
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// courttypeCourtTypeID
		// CourtType
		// CourtTypeEn
		// CourtTypeNotes
		// courtLocationCourtLocationID
		// CourtLocation
		// CourtLocationEn
		// CourtLocationGovernorateID
		// CourtLocationNotes
		// governoratesGovernorateID
		// Governorate
		// GovernorateEn
		// GovernoratesNotes
		// ChambersChamberID
		// Chamber
		// ChamberEn
		// chambersNotes
		// ChambersActivated
		// sectionsSectionID
		// Section
		// SectionEn
		// SectionsNotes
		// SectionsActivated
		// CourtID
		// Court
		// CourtEn
		// CourtTypeID
		// ChamberID
		// CourtLocationID
		// GovernorateID
		// SectionID
		// AddressID
		// ContactID
		// Activated
		// Notes
		// UserID
		// CreatedBy
		// CreatedDate
		// UpdatedBy
		// UpdatedDate

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// courttypeCourtTypeID
			$this->courttypeCourtTypeID->ViewValue = $this->courttypeCourtTypeID->CurrentValue;
			$this->courttypeCourtTypeID->ViewCustomAttributes = "";

			// CourtType
			$this->CourtType->ViewValue = $this->CourtType->CurrentValue;
			$this->CourtType->ViewCustomAttributes = "";

			// CourtTypeEn
			$this->CourtTypeEn->ViewValue = $this->CourtTypeEn->CurrentValue;
			$this->CourtTypeEn->ViewCustomAttributes = "";

			// CourtTypeNotes
			$this->CourtTypeNotes->ViewValue = $this->CourtTypeNotes->CurrentValue;
			$this->CourtTypeNotes->ViewCustomAttributes = "";

			// courtLocationCourtLocationID
			$this->courtLocationCourtLocationID->ViewValue = $this->courtLocationCourtLocationID->CurrentValue;
			$this->courtLocationCourtLocationID->ViewCustomAttributes = "";

			// CourtLocation
			$this->CourtLocation->ViewValue = $this->CourtLocation->CurrentValue;
			$this->CourtLocation->ViewCustomAttributes = "";

			// CourtLocationEn
			$this->CourtLocationEn->ViewValue = $this->CourtLocationEn->CurrentValue;
			$this->CourtLocationEn->ViewCustomAttributes = "";

			// CourtLocationGovernorateID
			$this->CourtLocationGovernorateID->ViewValue = $this->CourtLocationGovernorateID->CurrentValue;
			$this->CourtLocationGovernorateID->ViewValue = FormatNumber($this->CourtLocationGovernorateID->ViewValue, 0, -2, -2, -2);
			$this->CourtLocationGovernorateID->ViewCustomAttributes = "";

			// CourtLocationNotes
			$this->CourtLocationNotes->ViewValue = $this->CourtLocationNotes->CurrentValue;
			$this->CourtLocationNotes->ViewCustomAttributes = "";

			// governoratesGovernorateID
			$this->governoratesGovernorateID->ViewValue = $this->governoratesGovernorateID->CurrentValue;
			$this->governoratesGovernorateID->ViewCustomAttributes = "";

			// Governorate
			$this->Governorate->ViewValue = $this->Governorate->CurrentValue;
			$this->Governorate->ViewCustomAttributes = "";

			// GovernorateEn
			$this->GovernorateEn->ViewValue = $this->GovernorateEn->CurrentValue;
			$this->GovernorateEn->ViewCustomAttributes = "";

			// GovernoratesNotes
			$this->GovernoratesNotes->ViewValue = $this->GovernoratesNotes->CurrentValue;
			$this->GovernoratesNotes->ViewCustomAttributes = "";

			// ChambersChamberID
			$this->ChambersChamberID->ViewValue = $this->ChambersChamberID->CurrentValue;
			$this->ChambersChamberID->ViewCustomAttributes = "";

			// Chamber
			$this->Chamber->ViewValue = $this->Chamber->CurrentValue;
			$this->Chamber->ViewCustomAttributes = "";

			// ChamberEn
			$this->ChamberEn->ViewValue = $this->ChamberEn->CurrentValue;
			$this->ChamberEn->ViewCustomAttributes = "";

			// ChambersActivated
			if (ConvertToBool($this->ChambersActivated->CurrentValue)) {
				$this->ChambersActivated->ViewValue = $this->ChambersActivated->tagCaption(1) <> "" ? $this->ChambersActivated->tagCaption(1) : "Y";
			} else {
				$this->ChambersActivated->ViewValue = $this->ChambersActivated->tagCaption(2) <> "" ? $this->ChambersActivated->tagCaption(2) : "N";
			}
			$this->ChambersActivated->ViewCustomAttributes = "";

			// sectionsSectionID
			$this->sectionsSectionID->ViewValue = $this->sectionsSectionID->CurrentValue;
			$this->sectionsSectionID->ViewCustomAttributes = "";

			// Section
			$this->Section->ViewValue = $this->Section->CurrentValue;
			$this->Section->ViewCustomAttributes = "";

			// SectionEn
			$this->SectionEn->ViewValue = $this->SectionEn->CurrentValue;
			$this->SectionEn->ViewCustomAttributes = "";

			// SectionsActivated
			if (ConvertToBool($this->SectionsActivated->CurrentValue)) {
				$this->SectionsActivated->ViewValue = $this->SectionsActivated->tagCaption(1) <> "" ? $this->SectionsActivated->tagCaption(1) : "Y";
			} else {
				$this->SectionsActivated->ViewValue = $this->SectionsActivated->tagCaption(2) <> "" ? $this->SectionsActivated->tagCaption(2) : "N";
			}
			$this->SectionsActivated->ViewCustomAttributes = "";

			// CourtID
			$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
			$this->CourtID->ViewCustomAttributes = "";

			// Court
			$this->Court->ViewValue = $this->Court->CurrentValue;
			$this->Court->ViewCustomAttributes = "";

			// CourtEn
			$this->CourtEn->ViewValue = $this->CourtEn->CurrentValue;
			$this->CourtEn->ViewCustomAttributes = "";

			// CourtTypeID
			$curVal = strval($this->CourtTypeID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->lookupCacheOption($curVal);
				if ($this->CourtTypeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtTypeID->ViewValue = $this->CourtTypeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtTypeID->ViewValue = $this->CourtTypeID->CurrentValue;
					}
				}
			} else {
				$this->CourtTypeID->ViewValue = NULL;
			}
			$this->CourtTypeID->ViewCustomAttributes = "";

			// ChamberID
			$curVal = strval($this->ChamberID->CurrentValue);
			if ($curVal <> "") {
				$this->ChamberID->ViewValue = $this->ChamberID->lookupCacheOption($curVal);
				if ($this->ChamberID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ChamberID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ChamberID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ChamberID->ViewValue = $this->ChamberID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ChamberID->ViewValue = $this->ChamberID->CurrentValue;
					}
				}
			} else {
				$this->ChamberID->ViewValue = NULL;
			}
			$this->ChamberID->ViewCustomAttributes = "";

			// CourtLocationID
			$curVal = strval($this->CourtLocationID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtLocationID->ViewValue = $this->CourtLocationID->lookupCacheOption($curVal);
				if ($this->CourtLocationID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtLocationID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtLocationID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtLocationID->ViewValue = $this->CourtLocationID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtLocationID->ViewValue = $this->CourtLocationID->CurrentValue;
					}
				}
			} else {
				$this->CourtLocationID->ViewValue = NULL;
			}
			$this->CourtLocationID->ViewCustomAttributes = "";

			// GovernorateID
			$curVal = strval($this->GovernorateID->CurrentValue);
			if ($curVal <> "") {
				$this->GovernorateID->ViewValue = $this->GovernorateID->lookupCacheOption($curVal);
				if ($this->GovernorateID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`GovernorateID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->GovernorateID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->GovernorateID->ViewValue = $this->GovernorateID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->GovernorateID->ViewValue = $this->GovernorateID->CurrentValue;
					}
				}
			} else {
				$this->GovernorateID->ViewValue = NULL;
			}
			$this->GovernorateID->ViewCustomAttributes = "";

			// SectionID
			$curVal = strval($this->SectionID->CurrentValue);
			if ($curVal <> "") {
				$this->SectionID->ViewValue = $this->SectionID->lookupCacheOption($curVal);
				if ($this->SectionID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`SectionID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->SectionID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->SectionID->ViewValue = $this->SectionID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->SectionID->ViewValue = $this->SectionID->CurrentValue;
					}
				}
			} else {
				$this->SectionID->ViewValue = NULL;
			}
			$this->SectionID->ViewCustomAttributes = "";

			// AddressID
			$this->AddressID->ViewValue = $this->AddressID->CurrentValue;
			$this->AddressID->ViewValue = FormatNumber($this->AddressID->ViewValue, 0, -2, -2, -2);
			$this->AddressID->ViewCustomAttributes = "";

			// ContactID
			$this->ContactID->ViewValue = $this->ContactID->CurrentValue;
			$this->ContactID->ViewValue = FormatNumber($this->ContactID->ViewValue, 0, -2, -2, -2);
			$this->ContactID->ViewCustomAttributes = "";

			// Activated
			if (ConvertToBool($this->Activated->CurrentValue)) {
				$this->Activated->ViewValue = $this->Activated->tagCaption(1) <> "" ? $this->Activated->tagCaption(1) : "Y";
			} else {
				$this->Activated->ViewValue = $this->Activated->tagCaption(2) <> "" ? $this->Activated->tagCaption(2) : "N";
			}
			$this->Activated->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// CourtType
			$this->CourtType->LinkCustomAttributes = "";
			$this->CourtType->HrefValue = "";
			$this->CourtType->TooltipValue = "";

			// CourtLocation
			$this->CourtLocation->LinkCustomAttributes = "";
			$this->CourtLocation->HrefValue = "";
			$this->CourtLocation->TooltipValue = "";

			// Governorate
			$this->Governorate->LinkCustomAttributes = "";
			$this->Governorate->HrefValue = "";
			$this->Governorate->TooltipValue = "";

			// Chamber
			$this->Chamber->LinkCustomAttributes = "";
			$this->Chamber->HrefValue = "";
			$this->Chamber->TooltipValue = "";

			// SectionEn
			$this->SectionEn->LinkCustomAttributes = "";
			$this->SectionEn->HrefValue = "";
			$this->SectionEn->TooltipValue = "";

			// Court
			$this->Court->LinkCustomAttributes = "";
			$this->Court->HrefValue = "";
			$this->Court->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.freport,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.freport,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.freport,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = TRUE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->isExport())
			$this->ExportOptions->hideAllOptions();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("report", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_CourtTypeID":
							break;
						case "x_ChamberID":
							break;
						case "x_CourtLocationID":
							break;
						case "x_GovernorateID":
							break;
						case "x_SectionID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Export report to HTML
	public function exportReportHtml($html)
	{

		//global $ExportFileName;
		//AddHeader('Content-Type', 'text/html' . (PROJECT_CHARSET <> '' ? '; charset=' . PROJECT_CHARSET : ''));
		//AddHeader('Content-Disposition', 'attachment; filename=' . $ExportFileName . '.html');

		Write($html);
	}

	// Export to Word
	public function exportReportWord($html)
	{
		global $ExportFileName;
		$doc = new \DOMDocument();
		$html = preg_replace('/<meta\b(?:[^"\'>]|"[^"]*"|\'[^\']*\')*>/i', "", $html); // Remove meta tags
		@$doc->loadHTML('<?xml encoding="uft-8">' . ConvertToUtf8($html)); // Convert to utf-8
		$tables = $doc->getElementsByTagName("table");
		$phpword = new \PhpOffice\PhpWord\PhpWord();
		$section = $phpword->createSection(array("orientation" => $this->ExportWordPageOrientation));
		$cellwidth = $this->ExportWordColumnWidth;
		foreach ($tables as $table) {
			if ($table->getAttribute("class") == "ew-report-table") {
				$styleTable = array("borderSize" => 0, "borderColor" => "FFFFFF", "cellMargin" => 10); // Customize table cell styles here
				$phpword->addTableStyle("phpWord", $styleTable);
				$tbl = $section->addTable("phpWord");
				$rows = $table->getElementsByTagName("tr");
				$rowcnt = $rows->length;
				for ($i = 0; $i < $rowcnt; $i++) {
					$row = $rows->item($i);
					if (!($row->parentNode->tagName == "table" && $row->parentNode->getAttribute("class") == "ew-table-header-btn")) {
						$cells = $row->childNodes;
						$cellcnt = $cells->length;
						$tbl->addRow(0);
						for ($j = 0; $j < $cellcnt; $j++) {
							$cell = $cells->item($j);
							if ($cell->nodeType <> XML_ELEMENT_NODE || $cell->tagName <> "td")
								continue;
							$k = 1;
							if ($cell->hasAttribute("colspan"))
								$k = (int)$cell->getAttribute("colspan");
							$images = $cell->getElementsByTagName("img");
							if ($images->length > 0) { // Images
								foreach ($images as $image) {
									$fn = $image->getAttribute("src");
									$path = parse_url($fn, PHP_URL_PATH);
									$ext = pathinfo($path, PATHINFO_EXTENSION);
									if (SameText($ext, "php")) { // Image by script
										$fn = FullUrl($fn);
										$data = file_get_contents($fn);
										$fn = TempImage($data);
									}
									if (!file_exists($fn) || is_dir($fn))
										continue;
									$size = @getimagesize($fn);
									$style = array();
									$maxImageWidth = ExportWord2::$MaxImageWidth;
									if ($maxImageWidth > 0 && @$size[0] > $maxImageWidth) {
										$style["width"] = $maxImageWidth;
										$style["height"] = $maxImageWidth / $size[0] * $size[1];
									}
									$tbl->addCell($cellwidth)->addImage($fn, $style);
								}
							} else { // Text
								$text = htmlspecialchars(trim($cell->textContent), ENT_NOQUOTES);
								if ($row->parentNode->tagName == "thead") { // Caption
									$tbl->addCell($cellwidth, array("gridSpan" => $k, "bgColor" => "E4E4E4"))->addText($text, array("bold" => TRUE)); // Customize table header cell styles here
								} else {
									$tbl->addCell($cellwidth, array("gridSpan" => $k))->addText($text);
								}
							}
						}
					}
				}
			}
		}
		if (!DEBUG_ENABLED && ob_get_length())
			ob_end_clean();
		header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
		header('Content-Disposition: attachment; filename=' . $ExportFileName . '.docx');
		header('Cache-Control: max-age=0');
		header('Set-Cookie: fileDownload=true; path=/');
		$objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpword, 'Word2007');
		@$objWriter->save('php://output');
		DeleteTempImages();
		exit();
	}

	// Export report to Excel
	public function exportReportExcel($html, $format = "Excel5")
	{
		global $ExportFileName;
		$doc = new \DOMDocument();
		$html = preg_replace('/<meta\b(?:[^"\'>]|"[^"]*"|\'[^\']*\')*>/i', "", $html); // Remove meta tags
		@$doc->loadHTML('<?xml encoding="uft-8">' . ConvertToUtf8($html)); // Convert to utf-8
		$tables = $doc->getElementsByTagName("table");
		$phpspreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
		$phpspreadsheet->setActiveSheetIndex(0);
		$sheet = $phpspreadsheet->getActiveSheet();
		if ($this->ExportExcelPageOrientation <> "")
			$sheet->getPageSetup()->setOrientation($this->ExportExcelPageOrientation);
		if ($this->ExportExcelPageSize <> "")
			$sheet->getPageSetup()->setPaperSize($this->ExportExcelPageSize);
		if (function_exists("PhpSpreadsheet_Rendering")) // For user's own use only
			PhpSpreadsheet_Rendering($sheet);
		$maxImageWidth = ($format == "Excel5") ? ExportExcel5::$MaxImageWidth : ExportExcel2007::$MaxImageWidth; // Max image width <= 400 is recommended
		$widthMultiplier = ($format == "Excel5") ? ExportExcel5::$WidthMultiplier : ExportExcel2007::$WidthMultiplier; // Cell width multipler for image fields
		$heightMultiplier = ($format == "Excel5") ? ExportExcel5::$HeightMultiplier : ExportExcel2007::$HeightMultiplier; // Row height multipler for image fields
		$m = 1; $maxcellcnt = 1;
		foreach ($tables as $table) {
			if ($table->getAttribute("class") == "ew-report-table") {
				$rows = $table->getElementsByTagName("tr");
				$rowcnt = $rows->length;
				for ($i = 0; $i < $rowcnt; $i++) {
					$row = $rows->item($i);
					$cells = $row->childNodes;
					$cellcnt = $cells->length;
					$k = 1;
					for ($j = 0; $j < $cellcnt; $j++) {
						$cell = $cells->item($j);
						if ($cell->nodeType <> XML_ELEMENT_NODE || $cell->tagName <> "td")
							continue;
						$letter =\PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($k);
						$images = $cell->getElementsByTagName("img");
						if ($images->length > 0) { // Images
							$totalW = 0;
							$maxH = 0;
							foreach ($images as $image) {
								$fn = $image->getAttribute("src");
								$path = parse_url($fn, PHP_URL_PATH);
								$ext = pathinfo($path, PATHINFO_EXTENSION);
								if (SameText($ext, "php")) { // Image by script
									$fn = FullUrl($fn);
									$data = file_get_contents($fn);
									$fn = TempImage($data);
								}
								if (!file_exists($fn) || is_dir($fn))
									continue;
								$objDrawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
								$objDrawing->setWorksheet($sheet);
								$objDrawing->setPath($fn);
								$objDrawing->setOffsetX($totalW);
								$objDrawing->setCoordinates($letter . strval($m));
								if ($maxImageWidth > 0 && $objDrawing->getWidth() > $maxImageWidth)
									$objDrawing->setWidth($maxImageWidth);
								$size = array($objDrawing->getWidth(), $objDrawing->getHeight()); // Get image size
								if ($size[0] > 0) // Width
									$totalW += $size[0];
								$maxH = max($maxH, $size[1]); // Height
							}
							if ($totalW > 0) // Width
								$sheet->getColumnDimension($letter)->setAutoSize(FALSE)->setWidth($totalW * $widthMultiplier); // Set column width, no auto size
							if ($maxH > 0) // Height
								$sheet->getRowDimension($m)->setRowHeight($maxH * $heightMultiplier); // Set row height
						} else { // Text
							$value = trim($cell->textContent);
							if (function_exists("PhpSpreadsheet_Cell_Rendering")) // For user's own use only
								PhpSpreadsheet_Cell_Rendering($k, $m, $value, $sheet);
							if ($format == "Excel2007" && $row->parentNode->tagName == "thead") { // Caption
								$objRichText = new \PhpOffice\PhpSpreadsheet\RichText\RichText(); // Rich Text
								$obj = $objRichText->createTextRun($value);
								$obj->getFont()->setBold(TRUE); // Bold

								//$obj->getFont()->setItalic(true);
								//$obj->getFont()->setColor(new \PhpOffice\PhpSpreadsheet\Style\Color(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_DARKGREEN)); // Set color

								$sheet->getCellByColumnAndRow($k, $m)->setValue($objRichText);
							} else {
								$sheet->setCellValueByColumnAndRow($k, $m, $value);
							}
							$sheet->getColumnDimension($letter)->setAutoSize(TRUE);
							if (function_exists("PhpSpreadsheet_Cell_Rendered")) // For user's own use only
								PhpSpreadsheet_Cell_Rendered($k, $m, $value, $sheet);
						}
						if ($cell->hasAttribute("colspan")) {
							$k += (int)$cell->getAttribute("colspan");
						} else {
							$k++;
						}
					}
					if ($k > $maxcellcnt)
						$maxcellcnt = $k;
					$m++;
				}
				$m++;
			}
		}
		if (!DEBUG_ENABLED && ob_get_length())
			ob_end_clean();
		if ($format == "Excel5") {
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment; filename=' . $ExportFileName . '.xls');
		} else { // Excel2007
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment; filename=' . $ExportFileName . '.xlsx');
		}
		header('Cache-Control: max-age=0');
		header('Set-Cookie: fileDownload=true; path=/');
		$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($phpspreadsheet, ($format == "Excel5") ? "Xls" : "Xlsx");
		$objWriter->save('php://output');
		DeleteTempImages();
		exit();
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
