<?php
namespace PHPMaker2019\project_germanos;

/**
 * Table class for Cases Report1
 */
class Cases_Report1 extends DbTableBase
{
	protected $SqlGroupSelect = "";
	protected $SqlGroupWhere = "";
	protected $SqlGroupGroupBy = "";
	protected $SqlGroupHaving = "";
	protected $SqlGroupOrderBy = "";
	protected $SqlDetailSelect = "";
	protected $SqlDetailWhere = "";
	protected $SqlDetailGroupBy = "";
	protected $SqlDetailHaving = "";
	protected $SqlDetailOrderBy = "";

	// Export
	public $ExportDoc;

	// Fields
	public $CaseID;
	public $ClientID;
	public $LitigantID;
	public $CaseTypeID;
	public $FileNumber;
	public $EnvelopeNumber;
	public $CaseNumber;
	public $ClientStatusID;
	public $LitigantStatusID;
	public $CourtID;
	public $CourtTypeID;
	public $CourtGenderID;
	public $JudgeID;
	public $Notes;
	public $FileLocation;
	public $_Case;
	public $CaseEn;
	public $CaseSortID;
	public $CaseRegisteredDate;
	public $CaseStatusID;
	public $_UserID;
	public $CreatedBy;
	public $CreatedDate;
	public $UpdatedBy;
	public $UpdatedDate;
	public $CaseTypeConv;
	public $CaseConv;
	public $ClientStatusConv;
	public $LitigantStatusConv;
	public $ClientNameConv;
	public $LitigantNameConv;
	public $ClientNameConvFiles;
	public $LitigantNameConvFiles;
	public $CaseTypeConvFiles;
	public $CourtConvFiles;
	public $FileNumberConvFiles;
	public $CaseNumberConvFiles;
	public $NotesConvFiles;
	public $TitleID;
	public $FirstName;
	public $MiddleName;
	public $LastName;
	public $TitleID1;
	public $FirstName1;
	public $MiddleName1;
	public $LastName1;
	public $PartnersName;
	public $PartnersName1;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'Cases_Report1';
		$this->TableName = 'Cases Report1';
		$this->TableType = 'REPORT';

		// Update Table
		$this->UpdateTable = "`cases report`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->UserIDAllowSecurity = 0; // User ID Allow

		// CaseID
		$this->CaseID = new DbField('Cases_Report1', 'Cases Report1', 'x_CaseID', 'CaseID', '`CaseID`', '`CaseID`', 3, -1, FALSE, '`CaseID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->CaseID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->CaseID->IsPrimaryKey = TRUE; // Primary key field
		$this->CaseID->Sortable = TRUE; // Allow sort
		$this->CaseID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->CaseID->SourceTableVar = '_cases_report';
		$this->fields['CaseID'] = &$this->CaseID;

		// ClientID
		$this->ClientID = new DbField('Cases_Report1', 'Cases Report1', 'x_ClientID', 'ClientID', '`ClientID`', '`ClientID`', 3, -1, FALSE, '`EV__ClientID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->ClientID->Required = TRUE; // Required field
		$this->ClientID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->ClientID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->ClientID->SourceTableVar = '_cases_report';
		$this->fields['ClientID'] = &$this->ClientID;

		// LitigantID
		$this->LitigantID = new DbField('Cases_Report1', 'Cases Report1', 'x_LitigantID', 'LitigantID', '`LitigantID`', '`LitigantID`', 3, -1, FALSE, '`EV__LitigantID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->LitigantID->Required = TRUE; // Required field
		$this->LitigantID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->LitigantID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->LitigantID->SourceTableVar = '_cases_report';
		$this->fields['LitigantID'] = &$this->LitigantID;

		// CaseTypeID
		$this->CaseTypeID = new DbField('Cases_Report1', 'Cases Report1', 'x_CaseTypeID', 'CaseTypeID', '`CaseTypeID`', '`CaseTypeID`', 3, -1, FALSE, '`EV__CaseTypeID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CaseTypeID->Nullable = FALSE; // NOT NULL field
		$this->CaseTypeID->Required = TRUE; // Required field
		$this->CaseTypeID->Sortable = TRUE; // Allow sort
		$this->CaseTypeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CaseTypeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseType",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseType",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseType",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseType","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CaseTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->CaseTypeID->SourceTableVar = '_cases_report';
		$this->fields['CaseTypeID'] = &$this->CaseTypeID;

		// FileNumber
		$this->FileNumber = new DbField('Cases_Report1', 'Cases Report1', 'x_FileNumber', 'FileNumber', '`FileNumber`', '`FileNumber`', 200, -1, FALSE, '`FileNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->FileNumber->Nullable = FALSE; // NOT NULL field
		$this->FileNumber->Required = TRUE; // Required field
		$this->FileNumber->Sortable = TRUE; // Allow sort
		$this->FileNumber->SourceTableVar = '_cases_report';
		$this->fields['FileNumber'] = &$this->FileNumber;

		// EnvelopeNumber
		$this->EnvelopeNumber = new DbField('Cases_Report1', 'Cases Report1', 'x_EnvelopeNumber', 'EnvelopeNumber', '`EnvelopeNumber`', '`EnvelopeNumber`', 3, -1, FALSE, '`EnvelopeNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->EnvelopeNumber->Sortable = TRUE; // Allow sort
		$this->EnvelopeNumber->SourceTableVar = '_cases_report';
		$this->fields['EnvelopeNumber'] = &$this->EnvelopeNumber;

		// CaseNumber
		$this->CaseNumber = new DbField('Cases_Report1', 'Cases Report1', 'x_CaseNumber', 'CaseNumber', '`CaseNumber`', '`CaseNumber`', 200, -1, FALSE, '`CaseNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseNumber->Required = TRUE; // Required field
		$this->CaseNumber->Sortable = TRUE; // Allow sort
		$this->CaseNumber->SourceTableVar = '_cases_report';
		$this->fields['CaseNumber'] = &$this->CaseNumber;

		// ClientStatusID
		$this->ClientStatusID = new DbField('Cases_Report1', 'Cases Report1', 'x_ClientStatusID', 'ClientStatusID', '`ClientStatusID`', '`ClientStatusID`', 3, -1, FALSE, '`EV__ClientStatusID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->ClientStatusID->Nullable = FALSE; // NOT NULL field
		$this->ClientStatusID->Required = TRUE; // Required field
		$this->ClientStatusID->Sortable = TRUE; // Allow sort
		$this->ClientStatusID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ClientStatusID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->ClientStatusID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->ClientStatusID->SourceTableVar = '_cases_report';
		$this->fields['ClientStatusID'] = &$this->ClientStatusID;

		// LitigantStatusID
		$this->LitigantStatusID = new DbField('Cases_Report1', 'Cases Report1', 'x_LitigantStatusID', 'LitigantStatusID', '`LitigantStatusID`', '`LitigantStatusID`', 3, -1, FALSE, '`EV__LitigantStatusID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->LitigantStatusID->Nullable = FALSE; // NOT NULL field
		$this->LitigantStatusID->Required = TRUE; // Required field
		$this->LitigantStatusID->Sortable = TRUE; // Allow sort
		$this->LitigantStatusID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->LitigantStatusID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->LitigantStatusID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->LitigantStatusID->SourceTableVar = '_cases_report';
		$this->fields['LitigantStatusID'] = &$this->LitigantStatusID;

		// CourtID
		$this->CourtID = new DbField('Cases_Report1', 'Cases Report1', 'x_CourtID', 'CourtID', '`CourtID`', '`CourtID`', 3, -1, FALSE, '`EV__CourtID`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->CourtID->SourceTableVar = '_cases_report';
		$this->fields['CourtID'] = &$this->CourtID;

		// CourtTypeID
		$this->CourtTypeID = new DbField('Cases_Report1', 'Cases Report1', 'x_CourtTypeID', 'CourtTypeID', '`CourtTypeID`', '`CourtTypeID`', 3, -1, FALSE, '`EV__CourtTypeID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CourtTypeID->Sortable = FALSE; // Allow sort
		$this->CourtTypeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CourtTypeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtType",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtType",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtType",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtType","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->CourtTypeID->SourceTableVar = '_cases_report';
		$this->fields['CourtTypeID'] = &$this->CourtTypeID;

		// CourtGenderID
		$this->CourtGenderID = new DbField('Cases_Report1', 'Cases Report1', 'x_CourtGenderID', 'CourtGenderID', '`CourtGenderID`', '`CourtGenderID`', 3, -1, FALSE, '`EV__CourtGenderID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CourtGenderID->Sortable = FALSE; // Allow sort
		$this->CourtGenderID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CourtGenderID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtGenderID->Lookup = new Lookup('CourtGenderID', 'courtgender', TRUE, 'CourtGenderID', ["CourtGender",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtGenderID->Lookup = new Lookup('CourtGenderID', 'courtgender', TRUE, 'CourtGenderID', ["CourtGender",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtGenderID->Lookup = new Lookup('CourtGenderID', 'courtgender', TRUE, 'CourtGenderID', ["CourtGender",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtGenderID->Lookup = new Lookup('CourtGenderID', 'courtgender', TRUE, 'CourtGenderID', ["CourtGender","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtGenderID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->CourtGenderID->SourceTableVar = '_cases_report';
		$this->fields['CourtGenderID'] = &$this->CourtGenderID;

		// JudgeID
		$this->JudgeID = new DbField('Cases_Report1', 'Cases Report1', 'x_JudgeID', 'JudgeID', '`JudgeID`', '`JudgeID`', 3, -1, FALSE, '`EV__JudgeID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->JudgeID->Sortable = TRUE; // Allow sort
		$this->JudgeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->JudgeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->JudgeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->JudgeID->SourceTableVar = '_cases_report';
		$this->fields['JudgeID'] = &$this->JudgeID;

		// Notes
		$this->Notes = new DbField('Cases_Report1', 'Cases Report1', 'x_Notes', 'Notes', '`Notes`', '`Notes`', 201, -1, FALSE, '`Notes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Notes->Sortable = TRUE; // Allow sort
		$this->Notes->SourceTableVar = '_cases_report';
		$this->fields['Notes'] = &$this->Notes;

		// FileLocation
		$this->FileLocation = new DbField('Cases_Report1', 'Cases Report1', 'x_FileLocation', 'FileLocation', '`FileLocation`', '`FileLocation`', 200, -1, FALSE, '`FileLocation`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->FileLocation->Sortable = TRUE; // Allow sort
		$this->FileLocation->SourceTableVar = '_cases_report';
		$this->fields['FileLocation'] = &$this->FileLocation;

		// Case
		$this->_Case = new DbField('Cases_Report1', 'Cases Report1', 'x__Case', 'Case', '`Case`', '`Case`', 200, -1, FALSE, '`Case`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_Case->Sortable = TRUE; // Allow sort
		$this->_Case->SourceTableVar = '_cases_report';
		$this->fields['Case'] = &$this->_Case;

		// CaseEn
		$this->CaseEn = new DbField('Cases_Report1', 'Cases Report1', 'x_CaseEn', 'CaseEn', '`CaseEn`', '`CaseEn`', 200, -1, FALSE, '`CaseEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseEn->Sortable = FALSE; // Allow sort
		$this->CaseEn->SourceTableVar = '_cases_report';
		$this->fields['CaseEn'] = &$this->CaseEn;

		// CaseSortID
		$this->CaseSortID = new DbField('Cases_Report1', 'Cases Report1', 'x_CaseSortID', 'CaseSortID', '`CaseSortID`', '`CaseSortID`', 3, -1, FALSE, '`EV__CaseSortID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CaseSortID->Nullable = FALSE; // NOT NULL field
		$this->CaseSortID->Sortable = TRUE; // Allow sort
		$this->CaseSortID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CaseSortID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSort",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSort",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSort",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSort","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CaseSortID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->CaseSortID->SourceTableVar = '_cases_report';
		$this->fields['CaseSortID'] = &$this->CaseSortID;

		// CaseRegisteredDate
		$this->CaseRegisteredDate = new DbField('Cases_Report1', 'Cases Report1', 'x_CaseRegisteredDate', 'CaseRegisteredDate', '`CaseRegisteredDate`', CastDateFieldForLike('`CaseRegisteredDate`', 7, "DB"), 133, 7, FALSE, '`CaseRegisteredDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseRegisteredDate->Sortable = TRUE; // Allow sort
		$this->CaseRegisteredDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->CaseRegisteredDate->SourceTableVar = '_cases_report';
		$this->fields['CaseRegisteredDate'] = &$this->CaseRegisteredDate;

		// CaseStatusID
		$this->CaseStatusID = new DbField('Cases_Report1', 'Cases Report1', 'x_CaseStatusID', 'CaseStatusID', '`CaseStatusID`', '`CaseStatusID`', 3, -1, FALSE, '`EV__CaseStatusID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CaseStatusID->Nullable = FALSE; // NOT NULL field
		$this->CaseStatusID->Required = TRUE; // Required field
		$this->CaseStatusID->Sortable = TRUE; // Allow sort
		$this->CaseStatusID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CaseStatusID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatus",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatus",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatus",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatus","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CaseStatusID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->CaseStatusID->SourceTableVar = '_cases_report';
		$this->fields['CaseStatusID'] = &$this->CaseStatusID;

		// UserID
		$this->_UserID = new DbField('Cases_Report1', 'Cases Report1', 'x__UserID', 'UserID', '`UserID`', '`UserID`', 3, -1, FALSE, '`UserID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_UserID->Sortable = FALSE; // Allow sort
		$this->_UserID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->_UserID->SourceTableVar = '_cases_report';
		$this->fields['UserID'] = &$this->_UserID;

		// CreatedBy
		$this->CreatedBy = new DbField('Cases_Report1', 'Cases Report1', 'x_CreatedBy', 'CreatedBy', '`CreatedBy`', '`CreatedBy`', 200, -1, FALSE, '`CreatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedBy->Sortable = FALSE; // Allow sort
		$this->CreatedBy->SourceTableVar = '_cases_report';
		$this->fields['CreatedBy'] = &$this->CreatedBy;

		// CreatedDate
		$this->CreatedDate = new DbField('Cases_Report1', 'Cases Report1', 'x_CreatedDate', 'CreatedDate', '`CreatedDate`', CastDateFieldForLike('`CreatedDate`', 0, "DB"), 135, 0, FALSE, '`CreatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedDate->Sortable = FALSE; // Allow sort
		$this->CreatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->CreatedDate->SourceTableVar = '_cases_report';
		$this->fields['CreatedDate'] = &$this->CreatedDate;

		// UpdatedBy
		$this->UpdatedBy = new DbField('Cases_Report1', 'Cases Report1', 'x_UpdatedBy', 'UpdatedBy', '`UpdatedBy`', '`UpdatedBy`', 200, -1, FALSE, '`UpdatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedBy->Sortable = FALSE; // Allow sort
		$this->UpdatedBy->SourceTableVar = '_cases_report';
		$this->fields['UpdatedBy'] = &$this->UpdatedBy;

		// UpdatedDate
		$this->UpdatedDate = new DbField('Cases_Report1', 'Cases Report1', 'x_UpdatedDate', 'UpdatedDate', '`UpdatedDate`', CastDateFieldForLike('`UpdatedDate`', 0, "DB"), 135, 0, FALSE, '`UpdatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedDate->Sortable = FALSE; // Allow sort
		$this->UpdatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->UpdatedDate->SourceTableVar = '_cases_report';
		$this->fields['UpdatedDate'] = &$this->UpdatedDate;

		// CaseTypeConv
		$this->CaseTypeConv = new DbField('Cases_Report1', 'Cases Report1', 'x_CaseTypeConv', 'CaseTypeConv', '`CaseTypeConv`', '`CaseTypeConv`', 200, -1, FALSE, '`CaseTypeConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseTypeConv->Sortable = FALSE; // Allow sort
		$this->CaseTypeConv->SourceTableVar = '_cases_report';
		$this->fields['CaseTypeConv'] = &$this->CaseTypeConv;

		// CaseConv
		$this->CaseConv = new DbField('Cases_Report1', 'Cases Report1', 'x_CaseConv', 'CaseConv', '`CaseConv`', '`CaseConv`', 200, -1, FALSE, '`CaseConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseConv->Sortable = FALSE; // Allow sort
		$this->CaseConv->SourceTableVar = '_cases_report';
		$this->fields['CaseConv'] = &$this->CaseConv;

		// ClientStatusConv
		$this->ClientStatusConv = new DbField('Cases_Report1', 'Cases Report1', 'x_ClientStatusConv', 'ClientStatusConv', '`ClientStatusConv`', '`ClientStatusConv`', 200, -1, FALSE, '`ClientStatusConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ClientStatusConv->Sortable = FALSE; // Allow sort
		$this->ClientStatusConv->SourceTableVar = '_cases_report';
		$this->fields['ClientStatusConv'] = &$this->ClientStatusConv;

		// LitigantStatusConv
		$this->LitigantStatusConv = new DbField('Cases_Report1', 'Cases Report1', 'x_LitigantStatusConv', 'LitigantStatusConv', '`LitigantStatusConv`', '`LitigantStatusConv`', 200, -1, FALSE, '`LitigantStatusConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->LitigantStatusConv->Sortable = FALSE; // Allow sort
		$this->LitigantStatusConv->SourceTableVar = '_cases_report';
		$this->fields['LitigantStatusConv'] = &$this->LitigantStatusConv;

		// ClientNameConv
		$this->ClientNameConv = new DbField('Cases_Report1', 'Cases Report1', 'x_ClientNameConv', 'ClientNameConv', '`ClientNameConv`', '`ClientNameConv`', 200, -1, FALSE, '`ClientNameConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ClientNameConv->Sortable = FALSE; // Allow sort
		$this->ClientNameConv->SourceTableVar = '_cases_report';
		$this->fields['ClientNameConv'] = &$this->ClientNameConv;

		// LitigantNameConv
		$this->LitigantNameConv = new DbField('Cases_Report1', 'Cases Report1', 'x_LitigantNameConv', 'LitigantNameConv', '`LitigantNameConv`', '`LitigantNameConv`', 200, -1, FALSE, '`LitigantNameConv`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->LitigantNameConv->Sortable = FALSE; // Allow sort
		$this->LitigantNameConv->SourceTableVar = '_cases_report';
		$this->fields['LitigantNameConv'] = &$this->LitigantNameConv;

		// ClientNameConvFiles
		$this->ClientNameConvFiles = new DbField('Cases_Report1', 'Cases Report1', 'x_ClientNameConvFiles', 'ClientNameConvFiles', '`ClientNameConvFiles`', '`ClientNameConvFiles`', 200, -1, FALSE, '`ClientNameConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ClientNameConvFiles->Sortable = FALSE; // Allow sort
		$this->ClientNameConvFiles->SourceTableVar = '_cases_report';
		$this->fields['ClientNameConvFiles'] = &$this->ClientNameConvFiles;

		// LitigantNameConvFiles
		$this->LitigantNameConvFiles = new DbField('Cases_Report1', 'Cases Report1', 'x_LitigantNameConvFiles', 'LitigantNameConvFiles', '`LitigantNameConvFiles`', '`LitigantNameConvFiles`', 200, -1, FALSE, '`LitigantNameConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->LitigantNameConvFiles->Sortable = FALSE; // Allow sort
		$this->LitigantNameConvFiles->SourceTableVar = '_cases_report';
		$this->fields['LitigantNameConvFiles'] = &$this->LitigantNameConvFiles;

		// CaseTypeConvFiles
		$this->CaseTypeConvFiles = new DbField('Cases_Report1', 'Cases Report1', 'x_CaseTypeConvFiles', 'CaseTypeConvFiles', '`CaseTypeConvFiles`', '`CaseTypeConvFiles`', 200, -1, FALSE, '`CaseTypeConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseTypeConvFiles->Sortable = FALSE; // Allow sort
		$this->CaseTypeConvFiles->SourceTableVar = '_cases_report';
		$this->fields['CaseTypeConvFiles'] = &$this->CaseTypeConvFiles;

		// CourtConvFiles
		$this->CourtConvFiles = new DbField('Cases_Report1', 'Cases Report1', 'x_CourtConvFiles', 'CourtConvFiles', '`CourtConvFiles`', '`CourtConvFiles`', 200, -1, FALSE, '`CourtConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtConvFiles->Sortable = FALSE; // Allow sort
		$this->CourtConvFiles->SourceTableVar = '_cases_report';
		$this->fields['CourtConvFiles'] = &$this->CourtConvFiles;

		// FileNumberConvFiles
		$this->FileNumberConvFiles = new DbField('Cases_Report1', 'Cases Report1', 'x_FileNumberConvFiles', 'FileNumberConvFiles', '`FileNumberConvFiles`', '`FileNumberConvFiles`', 200, -1, FALSE, '`FileNumberConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->FileNumberConvFiles->Sortable = FALSE; // Allow sort
		$this->FileNumberConvFiles->SourceTableVar = '_cases_report';
		$this->fields['FileNumberConvFiles'] = &$this->FileNumberConvFiles;

		// CaseNumberConvFiles
		$this->CaseNumberConvFiles = new DbField('Cases_Report1', 'Cases Report1', 'x_CaseNumberConvFiles', 'CaseNumberConvFiles', '`CaseNumberConvFiles`', '`CaseNumberConvFiles`', 200, -1, FALSE, '`CaseNumberConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseNumberConvFiles->Sortable = FALSE; // Allow sort
		$this->CaseNumberConvFiles->SourceTableVar = '_cases_report';
		$this->fields['CaseNumberConvFiles'] = &$this->CaseNumberConvFiles;

		// NotesConvFiles
		$this->NotesConvFiles = new DbField('Cases_Report1', 'Cases Report1', 'x_NotesConvFiles', 'NotesConvFiles', '`NotesConvFiles`', '`NotesConvFiles`', 200, -1, FALSE, '`NotesConvFiles`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NotesConvFiles->Sortable = FALSE; // Allow sort
		$this->NotesConvFiles->SourceTableVar = '_cases_report';
		$this->fields['NotesConvFiles'] = &$this->NotesConvFiles;

		// TitleID
		$this->TitleID = new DbField('Cases_Report1', 'Cases Report1', 'x_TitleID', 'TitleID', '`TitleID`', '`TitleID`', 3, -1, FALSE, '`TitleID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->TitleID->Sortable = TRUE; // Allow sort
		$this->TitleID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->TitleID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->TitleID->Lookup = new Lookup('TitleID', 'titles', FALSE, 'TitleID', ["Title",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->TitleID->Lookup = new Lookup('TitleID', 'titles', FALSE, 'TitleID', ["Title",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->TitleID->Lookup = new Lookup('TitleID', 'titles', FALSE, 'TitleID', ["Title",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->TitleID->Lookup = new Lookup('TitleID', 'titles', FALSE, 'TitleID', ["Title","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->TitleID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->TitleID->SourceTableVar = '_cases_report';
		$this->fields['TitleID'] = &$this->TitleID;

		// FirstName
		$this->FirstName = new DbField('Cases_Report1', 'Cases Report1', 'x_FirstName', 'FirstName', '`FirstName`', '`FirstName`', 200, -1, FALSE, '`FirstName`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->FirstName->Sortable = TRUE; // Allow sort
		$this->FirstName->SourceTableVar = '_cases_report';
		$this->fields['FirstName'] = &$this->FirstName;

		// MiddleName
		$this->MiddleName = new DbField('Cases_Report1', 'Cases Report1', 'x_MiddleName', 'MiddleName', '`MiddleName`', '`MiddleName`', 200, -1, FALSE, '`MiddleName`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->MiddleName->Sortable = TRUE; // Allow sort
		$this->MiddleName->SourceTableVar = '_cases_report';
		$this->fields['MiddleName'] = &$this->MiddleName;

		// LastName
		$this->LastName = new DbField('Cases_Report1', 'Cases Report1', 'x_LastName', 'LastName', '`LastName`', '`LastName`', 200, -1, FALSE, '`LastName`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->LastName->Sortable = TRUE; // Allow sort
		$this->LastName->SourceTableVar = '_cases_report';
		$this->fields['LastName'] = &$this->LastName;

		// TitleID1
		$this->TitleID1 = new DbField('Cases_Report1', 'Cases Report1', 'x_TitleID1', 'TitleID1', '`TitleID1`', '`TitleID1`', 3, -1, FALSE, '`TitleID1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->TitleID1->Sortable = TRUE; // Allow sort
		$this->TitleID1->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->TitleID1->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->TitleID1->Lookup = new Lookup('TitleID1', 'titles', FALSE, 'TitleID', ["Title",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->TitleID1->Lookup = new Lookup('TitleID1', 'titles', FALSE, 'TitleID', ["Title",null,"",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->TitleID1->Lookup = new Lookup('TitleID1', 'titles', FALSE, 'TitleID', ["Title",null,"",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->TitleID1->Lookup = new Lookup('TitleID1', 'titles', FALSE, 'TitleID', ["Title","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->TitleID1->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->TitleID1->SourceTableVar = '_cases_report';
		$this->fields['TitleID1'] = &$this->TitleID1;

		// FirstName1
		$this->FirstName1 = new DbField('Cases_Report1', 'Cases Report1', 'x_FirstName1', 'FirstName1', '`FirstName1`', '`FirstName1`', 200, -1, FALSE, '`FirstName1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->FirstName1->Sortable = TRUE; // Allow sort
		$this->FirstName1->SourceTableVar = '_cases_report';
		$this->fields['FirstName1'] = &$this->FirstName1;

		// MiddleName1
		$this->MiddleName1 = new DbField('Cases_Report1', 'Cases Report1', 'x_MiddleName1', 'MiddleName1', '`MiddleName1`', '`MiddleName1`', 200, -1, FALSE, '`MiddleName1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->MiddleName1->Sortable = TRUE; // Allow sort
		$this->MiddleName1->SourceTableVar = '_cases_report';
		$this->fields['MiddleName1'] = &$this->MiddleName1;

		// LastName1
		$this->LastName1 = new DbField('Cases_Report1', 'Cases Report1', 'x_LastName1', 'LastName1', '`LastName1`', '`LastName1`', 200, -1, FALSE, '`LastName1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->LastName1->Sortable = TRUE; // Allow sort
		$this->LastName1->SourceTableVar = '_cases_report';
		$this->fields['LastName1'] = &$this->LastName1;

		// PartnersName
		$this->PartnersName = new DbField('Cases_Report1', 'Cases Report1', 'x_PartnersName', 'PartnersName', '`PartnersName`', '`PartnersName`', 200, -1, FALSE, '`PartnersName`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PartnersName->Sortable = TRUE; // Allow sort
		$this->PartnersName->SourceTableVar = '_cases_report';
		$this->fields['PartnersName'] = &$this->PartnersName;

		// PartnersName1
		$this->PartnersName1 = new DbField('Cases_Report1', 'Cases Report1', 'x_PartnersName1', 'PartnersName1', '`PartnersName1`', '`PartnersName1`', 200, -1, FALSE, '`PartnersName1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PartnersName1->Sortable = TRUE; // Allow sort
		$this->PartnersName1->SourceTableVar = '_cases_report';
		$this->fields['PartnersName1'] = &$this->PartnersName1;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Report group level SQL
	public function getSqlGroupSelect() // Select
	{
		return ($this->SqlGroupSelect <> "") ? $this->SqlGroupSelect : "SELECT DISTINCT `FileNumber`,`FirstName` FROM `cases report`";
	}
	public function sqlGroupSelect() // For backward compatibility
	{
		return $this->getSqlGroupSelect();
	}
	public function setSqlGroupSelect($v)
	{
		$this->SqlGroupSelect = $v;
	}
	public function getSqlGroupWhere() // Where
	{
		return ($this->SqlGroupWhere <> "") ? $this->SqlGroupWhere : "";
	}
	public function sqlGroupWhere() // For backward compatibility
	{
		return $this->getSqlGroupWhere();
	}
	public function setSqlGroupWhere($v)
	{
		$this->SqlGroupWhere = $v;
	}
	public function getSqlGroupGroupBy() // Group By
	{
		return ($this->SqlGroupGroupBy <> "") ? $this->SqlGroupGroupBy : "";
	}
	public function sqlGroupGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupGroupBy();
	}
	public function setSqlGroupGroupBy($v)
	{
		$this->SqlGroupGroupBy = $v;
	}
	public function getSqlGroupHaving() // Having
	{
		return ($this->SqlGroupHaving <> "") ? $this->SqlGroupHaving : "";
	}
	public function sqlGroupHaving() // For backward compatibility
	{
		return $this->getSqlGroupHaving();
	}
	public function setSqlGroupHaving($v)
	{
		$this->SqlGroupHaving = $v;
	}
	public function getSqlGroupOrderBy() // Order By
	{
		return ($this->SqlGroupOrderBy <> "") ? $this->SqlGroupOrderBy : "`FileNumber` ASC,`FirstName` ASC";
	}
	public function sqlGroupOrderBy() // For backward compatibility
	{
		return $this->getSqlGroupOrderBy();
	}
	public function setSqlGroupOrderBy($v)
	{
		$this->SqlGroupOrderBy = $v;
	}

	// Report detail level SQL
	public function getSqlDetailSelect() // Select
	{
		return ($this->SqlDetailSelect <> "") ? $this->SqlDetailSelect : "SELECT * FROM `cases report`";
	}
	public function sqlDetailSelect() // For backward compatibility
	{
		return $this->getSqlDetailSelect();
	}
	public function setSqlDetailSelect($v)
	{
		$this->SqlDetailSelect = $v;
	}
	public function getSqlDetailWhere() // Where
	{
		return ($this->SqlDetailWhere <> "") ? $this->SqlDetailWhere : "";
	}
	public function sqlDetailWhere() // For backward compatibility
	{
		return $this->getSqlDetailWhere();
	}
	public function setSqlDetailWhere($v)
	{
		$this->SqlDetailWhere = $v;
	}
	public function getSqlDetailGroupBy() // Group By
	{
		return ($this->SqlDetailGroupBy <> "") ? $this->SqlDetailGroupBy : "";
	}
	public function sqlDetailGroupBy() // For backward compatibility
	{
		return $this->getSqlDetailGroupBy();
	}
	public function setSqlDetailGroupBy($v)
	{
		$this->SqlDetailGroupBy = $v;
	}
	public function getSqlDetailHaving() // Having
	{
		return ($this->SqlDetailHaving <> "") ? $this->SqlDetailHaving : "";
	}
	public function sqlDetailHaving() // For backward compatibility
	{
		return $this->getSqlDetailHaving();
	}
	public function setSqlDetailHaving($v)
	{
		$this->SqlDetailHaving = $v;
	}
	public function getSqlDetailOrderBy() // Order By
	{
		return ($this->SqlDetailOrderBy <> "") ? $this->SqlDetailOrderBy : "";
	}
	public function sqlDetailOrderBy() // For backward compatibility
	{
		return $this->getSqlDetailOrderBy();
	}
	public function setSqlDetailOrderBy($v)
	{
		$this->SqlDetailOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Report group SQL
	public function getGroupSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = "";
		return BuildSelectSql($this->getSqlGroupSelect(), $this->getSqlGroupWhere(),
			 $this->getSqlGroupGroupBy(), $this->getSqlGroupHaving(),
			 $this->getSqlGroupOrderBy(), $filter, $sort);
	}

	// Report detail SQL
	public function getDetailSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = "";
		return BuildSelectSql($this->getSqlDetailSelect(), $this->getSqlDetailWhere(),
			$this->getSqlDetailGroupBy(), $this->getSqlDetailHaving(),
			$this->getSqlDetailOrderBy(), $filter, $sort);
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "Cases_Report1report.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "")
			return $Language->phrase("View");
		elseif ($pageName == "")
			return $Language->phrase("Edit");
		elseif ($pageName == "")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "Cases_Report1report.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "?" . $this->getUrlParm($parm);
		else
			$url = "";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "CaseID:" . JsonEncode($this->CaseID->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->CaseID->CurrentValue != NULL) {
			$url .= "CaseID=" . urlencode($this->CaseID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("CaseID") !== NULL)
				$arKeys[] = Param("CaseID");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->CaseID->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class Cases_Report1_report extends Cases_Report1
{

	// Page ID
	public $PageID = "report";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'Cases Report1';

	// Page object name
	public $PageObjName = "Cases_Report1_report";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (Cases_Report1)
		if (!isset($GLOBALS["Cases_Report1"]) || get_class($GLOBALS["Cases_Report1"]) == PROJECT_NAMESPACE . "Cases_Report1") {
			$GLOBALS["Cases_Report1"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Cases_Report1"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'report');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'Cases Report1');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT_REPORT;
		if ($this->isExport() && array_key_exists($this->Export, $EXPORT_REPORT)) {
			$content = ob_get_clean(); // ob_get_contents() and ob_end_clean()
			$fn = $EXPORT_REPORT[$this->Export];
			$this->$fn($content);
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}
	public $ExportOptions; // Export options
	public $RecCnt = 0;
	public $RowCnt = 0; // For custom view tag
	public $ReportSql = "";
	public $ReportFilter = "";
	public $DefaultFilter = "";
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $MasterRecordExists;
	public $Command;
	public $DtlRecordCount;
	public $ReportGroups;
	public $ReportCounts;
	public $LevelBreak;
	public $ReportTotals;
	public $ReportMaxs;
	public $ReportMins;
	public $DetailRecordset;
	public $RecordExists;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canReport()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Setup export options
		$this->setupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();
		$this->ReportGroups = &InitArray(3, NULL);
		$this->ReportCounts = &InitArray(3, 0);
		$this->LevelBreak = &InitArray(3, FALSE);
		$this->ReportTotals = &Init2DArray(3, 8, 0);
		$this->ReportMaxs = &Init2DArray(3, 8, 0);
		$this->ReportMins = &Init2DArray(3, 8, 0);

		// Set up Breadcrumb
		$this->setupBreadcrumb();
	}

	// Check level break
	public function checkLevelBreak()
	{
		$this->LevelBreak[1] = FALSE;
		$this->LevelBreak[2] = FALSE;
		if ($this->RecCnt == 0) { // Start Or End of Recordset
			$this->LevelBreak[1] = TRUE;
			$this->LevelBreak[2] = TRUE;
		} else {
			if (!CompareValue($this->FileNumber->CurrentValue, $this->ReportGroups[0])) {
				$this->LevelBreak[1] = TRUE;
				$this->LevelBreak[2] = TRUE;
			}
			if (!CompareValue($this->FirstName->CurrentValue, $this->ReportGroups[1])) {
				$this->LevelBreak[2] = TRUE;
			}
		}
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// CaseID
		// ClientID
		// LitigantID
		// CaseTypeID
		// FileNumber
		// EnvelopeNumber
		// CaseNumber
		// ClientStatusID
		// LitigantStatusID
		// CourtID
		// CourtTypeID
		// CourtGenderID
		// JudgeID
		// Notes
		// FileLocation
		// Case
		// CaseEn
		// CaseSortID
		// CaseRegisteredDate
		// CaseStatusID
		// UserID
		// CreatedBy
		// CreatedDate
		// UpdatedBy
		// UpdatedDate
		// CaseTypeConv
		// CaseConv
		// ClientStatusConv
		// LitigantStatusConv
		// ClientNameConv
		// LitigantNameConv
		// ClientNameConvFiles
		// LitigantNameConvFiles
		// CaseTypeConvFiles
		// CourtConvFiles
		// FileNumberConvFiles
		// CaseNumberConvFiles
		// NotesConvFiles
		// TitleID
		// FirstName
		// MiddleName
		// LastName
		// TitleID1
		// FirstName1
		// MiddleName1
		// LastName1
		// PartnersName
		// PartnersName1

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// CaseID
			$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
			$this->CaseID->ViewCustomAttributes = "";

			// ClientID
			if ($this->ClientID->VirtualValue <> "") {
				$this->ClientID->ViewValue = $this->ClientID->VirtualValue;
			} else {
				$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
					}
				}
			} else {
				$this->ClientID->ViewValue = NULL;
			}
			}
			$this->ClientID->CssStyle = "font-weight: bold;";
			$this->ClientID->ViewCustomAttributes = "";

			// LitigantID
			if ($this->LitigantID->VirtualValue <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->VirtualValue;
			} else {
				$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->LitigantID->ViewValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
					}
				}
			} else {
				$this->LitigantID->ViewValue = NULL;
			}
			}
			$this->LitigantID->CssStyle = "font-weight: bold;";
			$this->LitigantID->ViewCustomAttributes = "";

			// CaseTypeID
			if ($this->CaseTypeID->VirtualValue <> "") {
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->VirtualValue;
			} else {
			$curVal = strval($this->CaseTypeID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->lookupCacheOption($curVal);
				if ($this->CaseTypeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseTypeID->ViewValue = $this->CaseTypeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseTypeID->ViewValue = $this->CaseTypeID->CurrentValue;
					}
				}
			} else {
				$this->CaseTypeID->ViewValue = NULL;
			}
			}
			$this->CaseTypeID->CssStyle = "font-style: italic;";
			$this->CaseTypeID->ViewCustomAttributes = "";

			// FileNumber
			$this->FileNumber->ViewValue = $this->FileNumber->CurrentValue;
			$this->FileNumber->ViewCustomAttributes = "";

			// EnvelopeNumber
			$this->EnvelopeNumber->ViewValue = $this->EnvelopeNumber->CurrentValue;
			$this->EnvelopeNumber->ViewCustomAttributes = "";

			// CaseNumber
			$this->CaseNumber->ViewValue = $this->CaseNumber->CurrentValue;
			$this->CaseNumber->ViewCustomAttributes = "";

			// ClientStatusID
			if ($this->ClientStatusID->VirtualValue <> "") {
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->VirtualValue;
			} else {
			$curVal = strval($this->ClientStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->lookupCacheOption($curVal);
				if ($this->ClientStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ClientStatusID->ViewValue = $this->ClientStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientStatusID->ViewValue = $this->ClientStatusID->CurrentValue;
					}
				}
			} else {
				$this->ClientStatusID->ViewValue = NULL;
			}
			}
			$this->ClientStatusID->CssStyle = "font-style: italic;";
			$this->ClientStatusID->ViewCustomAttributes = "";

			// LitigantStatusID
			if ($this->LitigantStatusID->VirtualValue <> "") {
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->VirtualValue;
			} else {
			$curVal = strval($this->LitigantStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->lookupCacheOption($curVal);
				if ($this->LitigantStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->CurrentValue;
					}
				}
			} else {
				$this->LitigantStatusID->ViewValue = NULL;
			}
			}
			$this->LitigantStatusID->CssStyle = "font-style: italic;";
			$this->LitigantStatusID->ViewCustomAttributes = "";

			// CourtID
			if ($this->CourtID->VirtualValue <> "") {
				$this->CourtID->ViewValue = $this->CourtID->VirtualValue;
			} else {
				$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
			$curVal = strval($this->CourtID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtID->ViewValue = $this->CourtID->lookupCacheOption($curVal);
				if ($this->CourtID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtID->ViewValue = $this->CourtID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
					}
				}
			} else {
				$this->CourtID->ViewValue = NULL;
			}
			}
			$this->CourtID->ViewCustomAttributes = "";

			// JudgeID
			if ($this->JudgeID->VirtualValue <> "") {
				$this->JudgeID->ViewValue = $this->JudgeID->VirtualValue;
			} else {
			$curVal = strval($this->JudgeID->CurrentValue);
			if ($curVal <> "") {
				$this->JudgeID->ViewValue = $this->JudgeID->lookupCacheOption($curVal);
				if ($this->JudgeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`JudgeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->JudgeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->JudgeID->ViewValue = $this->JudgeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->JudgeID->ViewValue = $this->JudgeID->CurrentValue;
					}
				}
			} else {
				$this->JudgeID->ViewValue = NULL;
			}
			}
			$this->JudgeID->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// FileLocation
			$this->FileLocation->ViewValue = $this->FileLocation->CurrentValue;
			$this->FileLocation->ViewCustomAttributes = "";

			// Case
			$this->_Case->ViewValue = $this->_Case->CurrentValue;
			$this->_Case->ViewCustomAttributes = "";

			// CaseSortID
			if ($this->CaseSortID->VirtualValue <> "") {
				$this->CaseSortID->ViewValue = $this->CaseSortID->VirtualValue;
			} else {
			$curVal = strval($this->CaseSortID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseSortID->ViewValue = $this->CaseSortID->lookupCacheOption($curVal);
				if ($this->CaseSortID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseSortID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseSortID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseSortID->ViewValue = $this->CaseSortID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseSortID->ViewValue = $this->CaseSortID->CurrentValue;
					}
				}
			} else {
				$this->CaseSortID->ViewValue = NULL;
			}
			}
			$this->CaseSortID->ViewCustomAttributes = "";

			// CaseRegisteredDate
			$this->CaseRegisteredDate->ViewValue = $this->CaseRegisteredDate->CurrentValue;
			$this->CaseRegisteredDate->ViewValue = FormatDateTime($this->CaseRegisteredDate->ViewValue, 7);
			$this->CaseRegisteredDate->ViewCustomAttributes = "";

			// CaseStatusID
			if ($this->CaseStatusID->VirtualValue <> "") {
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->VirtualValue;
			} else {
			$curVal = strval($this->CaseStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->lookupCacheOption($curVal);
				if ($this->CaseStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseStatusID->ViewValue = $this->CaseStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseStatusID->ViewValue = $this->CaseStatusID->CurrentValue;
					}
				}
			} else {
				$this->CaseStatusID->ViewValue = NULL;
			}
			}
			$this->CaseStatusID->CssStyle = "font-style: italic;";
			$this->CaseStatusID->ViewCustomAttributes = "";

			// ClientNameConvFiles
			$this->ClientNameConvFiles->ViewValue = $this->ClientNameConvFiles->CurrentValue;
			$this->ClientNameConvFiles->ViewCustomAttributes = "";

			// TitleID
			$curVal = strval($this->TitleID->CurrentValue);
			if ($curVal <> "") {
				$this->TitleID->ViewValue = $this->TitleID->lookupCacheOption($curVal);
				if ($this->TitleID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`TitleID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->TitleID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->TitleID->ViewValue = $this->TitleID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->TitleID->ViewValue = $this->TitleID->CurrentValue;
					}
				}
			} else {
				$this->TitleID->ViewValue = NULL;
			}
			$this->TitleID->ViewCustomAttributes = "";

			// FirstName
			$this->FirstName->ViewValue = $this->FirstName->CurrentValue;
			$this->FirstName->ViewCustomAttributes = "";

			// MiddleName
			$this->MiddleName->ViewValue = $this->MiddleName->CurrentValue;
			$this->MiddleName->ViewCustomAttributes = "";

			// LastName
			$this->LastName->ViewValue = $this->LastName->CurrentValue;
			$this->LastName->ViewCustomAttributes = "";

			// TitleID1
			$curVal = strval($this->TitleID1->CurrentValue);
			if ($curVal <> "") {
				$this->TitleID1->ViewValue = $this->TitleID1->lookupCacheOption($curVal);
				if ($this->TitleID1->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`TitleID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->TitleID1->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->TitleID1->ViewValue = $this->TitleID1->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->TitleID1->ViewValue = $this->TitleID1->CurrentValue;
					}
				}
			} else {
				$this->TitleID1->ViewValue = NULL;
			}
			$this->TitleID1->ViewCustomAttributes = "";

			// FirstName1
			$this->FirstName1->ViewValue = $this->FirstName1->CurrentValue;
			$this->FirstName1->ViewCustomAttributes = "";

			// MiddleName1
			$this->MiddleName1->ViewValue = $this->MiddleName1->CurrentValue;
			$this->MiddleName1->ViewCustomAttributes = "";

			// LastName1
			$this->LastName1->ViewValue = $this->LastName1->CurrentValue;
			$this->LastName1->ViewCustomAttributes = "";

			// PartnersName
			$this->PartnersName->ViewValue = $this->PartnersName->CurrentValue;
			$this->PartnersName->ViewCustomAttributes = "";

			// PartnersName1
			$this->PartnersName1->ViewValue = $this->PartnersName1->CurrentValue;
			$this->PartnersName1->ViewCustomAttributes = "";

			// FileNumber
			$this->FileNumber->LinkCustomAttributes = "";
			$this->FileNumber->HrefValue = "";
			$this->FileNumber->TooltipValue = "";

			// EnvelopeNumber
			$this->EnvelopeNumber->LinkCustomAttributes = "";
			$this->EnvelopeNumber->HrefValue = "";
			$this->EnvelopeNumber->TooltipValue = "";

			// CaseNumber
			$this->CaseNumber->LinkCustomAttributes = "";
			$this->CaseNumber->HrefValue = "";
			$this->CaseNumber->TooltipValue = "";

			// FirstName
			$this->FirstName->LinkCustomAttributes = "";
			$this->FirstName->HrefValue = "";
			$this->FirstName->TooltipValue = "";

			// MiddleName
			$this->MiddleName->LinkCustomAttributes = "";
			$this->MiddleName->HrefValue = "";
			$this->MiddleName->TooltipValue = "";

			// LastName
			$this->LastName->LinkCustomAttributes = "";
			$this->LastName->HrefValue = "";
			$this->LastName->TooltipValue = "";

			// FirstName1
			$this->FirstName1->LinkCustomAttributes = "";
			$this->FirstName1->HrefValue = "";
			$this->FirstName1->TooltipValue = "";

			// MiddleName1
			$this->MiddleName1->LinkCustomAttributes = "";
			$this->MiddleName1->HrefValue = "";
			$this->MiddleName1->TooltipValue = "";

			// LastName1
			$this->LastName1->LinkCustomAttributes = "";
			$this->LastName1->HrefValue = "";
			$this->LastName1->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.freport,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.freport,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.freport,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = TRUE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->isExport())
			$this->ExportOptions->hideAllOptions();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("report", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_ClientID":
							break;
						case "x_LitigantID":
							break;
						case "x_CaseTypeID":
							break;
						case "x_ClientStatusID":
							break;
						case "x_LitigantStatusID":
							break;
						case "x_CourtID":
							break;
						case "x_CourtTypeID":
							break;
						case "x_CourtGenderID":
							break;
						case "x_JudgeID":
							break;
						case "x_CaseSortID":
							break;
						case "x_CaseStatusID":
							break;
						case "x_TitleID":
							break;
						case "x_TitleID1":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Export report to HTML
	public function exportReportHtml($html)
	{

		//global $ExportFileName;
		//AddHeader('Content-Type', 'text/html' . (PROJECT_CHARSET <> '' ? '; charset=' . PROJECT_CHARSET : ''));
		//AddHeader('Content-Disposition', 'attachment; filename=' . $ExportFileName . '.html');

		Write($html);
	}

	// Export to Word
	public function exportReportWord($html)
	{
		global $ExportFileName;
		$doc = new \DOMDocument();
		$html = preg_replace('/<meta\b(?:[^"\'>]|"[^"]*"|\'[^\']*\')*>/i', "", $html); // Remove meta tags
		@$doc->loadHTML('<?xml encoding="uft-8">' . ConvertToUtf8($html)); // Convert to utf-8
		$tables = $doc->getElementsByTagName("table");
		$phpword = new \PhpOffice\PhpWord\PhpWord();
		$section = $phpword->createSection(array("orientation" => $this->ExportWordPageOrientation));
		$cellwidth = $this->ExportWordColumnWidth;
		foreach ($tables as $table) {
			if ($table->getAttribute("class") == "ew-report-table") {
				$styleTable = array("borderSize" => 0, "borderColor" => "FFFFFF", "cellMargin" => 10); // Customize table cell styles here
				$phpword->addTableStyle("phpWord", $styleTable);
				$tbl = $section->addTable("phpWord");
				$rows = $table->getElementsByTagName("tr");
				$rowcnt = $rows->length;
				for ($i = 0; $i < $rowcnt; $i++) {
					$row = $rows->item($i);
					if (!($row->parentNode->tagName == "table" && $row->parentNode->getAttribute("class") == "ew-table-header-btn")) {
						$cells = $row->childNodes;
						$cellcnt = $cells->length;
						$tbl->addRow(0);
						for ($j = 0; $j < $cellcnt; $j++) {
							$cell = $cells->item($j);
							if ($cell->nodeType <> XML_ELEMENT_NODE || $cell->tagName <> "td")
								continue;
							$k = 1;
							if ($cell->hasAttribute("colspan"))
								$k = (int)$cell->getAttribute("colspan");
							$images = $cell->getElementsByTagName("img");
							if ($images->length > 0) { // Images
								foreach ($images as $image) {
									$fn = $image->getAttribute("src");
									$path = parse_url($fn, PHP_URL_PATH);
									$ext = pathinfo($path, PATHINFO_EXTENSION);
									if (SameText($ext, "php")) { // Image by script
										$fn = FullUrl($fn);
										$data = file_get_contents($fn);
										$fn = TempImage($data);
									}
									if (!file_exists($fn) || is_dir($fn))
										continue;
									$size = @getimagesize($fn);
									$style = array();
									$maxImageWidth = ExportWord2::$MaxImageWidth;
									if ($maxImageWidth > 0 && @$size[0] > $maxImageWidth) {
										$style["width"] = $maxImageWidth;
										$style["height"] = $maxImageWidth / $size[0] * $size[1];
									}
									$tbl->addCell($cellwidth)->addImage($fn, $style);
								}
							} else { // Text
								$text = htmlspecialchars(trim($cell->textContent), ENT_NOQUOTES);
								if ($row->parentNode->tagName == "thead") { // Caption
									$tbl->addCell($cellwidth, array("gridSpan" => $k, "bgColor" => "E4E4E4"))->addText($text, array("bold" => TRUE)); // Customize table header cell styles here
								} else {
									$tbl->addCell($cellwidth, array("gridSpan" => $k))->addText($text);
								}
							}
						}
					}
				}
			}
		}
		if (!DEBUG_ENABLED && ob_get_length())
			ob_end_clean();
		header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
		header('Content-Disposition: attachment; filename=' . $ExportFileName . '.docx');
		header('Cache-Control: max-age=0');
		header('Set-Cookie: fileDownload=true; path=/');
		$objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpword, 'Word2007');
		@$objWriter->save('php://output');
		DeleteTempImages();
		exit();
	}

	// Export report to Excel
	public function exportReportExcel($html, $format = "Excel5")
	{
		global $ExportFileName;
		$doc = new \DOMDocument();
		$html = preg_replace('/<meta\b(?:[^"\'>]|"[^"]*"|\'[^\']*\')*>/i', "", $html); // Remove meta tags
		@$doc->loadHTML('<?xml encoding="uft-8">' . ConvertToUtf8($html)); // Convert to utf-8
		$tables = $doc->getElementsByTagName("table");
		$phpspreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
		$phpspreadsheet->setActiveSheetIndex(0);
		$sheet = $phpspreadsheet->getActiveSheet();
		if ($this->ExportExcelPageOrientation <> "")
			$sheet->getPageSetup()->setOrientation($this->ExportExcelPageOrientation);
		if ($this->ExportExcelPageSize <> "")
			$sheet->getPageSetup()->setPaperSize($this->ExportExcelPageSize);
		if (function_exists("PhpSpreadsheet_Rendering")) // For user's own use only
			PhpSpreadsheet_Rendering($sheet);
		$maxImageWidth = ($format == "Excel5") ? ExportExcel5::$MaxImageWidth : ExportExcel2007::$MaxImageWidth; // Max image width <= 400 is recommended
		$widthMultiplier = ($format == "Excel5") ? ExportExcel5::$WidthMultiplier : ExportExcel2007::$WidthMultiplier; // Cell width multipler for image fields
		$heightMultiplier = ($format == "Excel5") ? ExportExcel5::$HeightMultiplier : ExportExcel2007::$HeightMultiplier; // Row height multipler for image fields
		$m = 1; $maxcellcnt = 1;
		foreach ($tables as $table) {
			if ($table->getAttribute("class") == "ew-report-table") {
				$rows = $table->getElementsByTagName("tr");
				$rowcnt = $rows->length;
				for ($i = 0; $i < $rowcnt; $i++) {
					$row = $rows->item($i);
					$cells = $row->childNodes;
					$cellcnt = $cells->length;
					$k = 1;
					for ($j = 0; $j < $cellcnt; $j++) {
						$cell = $cells->item($j);
						if ($cell->nodeType <> XML_ELEMENT_NODE || $cell->tagName <> "td")
							continue;
						$letter =\PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($k);
						$images = $cell->getElementsByTagName("img");
						if ($images->length > 0) { // Images
							$totalW = 0;
							$maxH = 0;
							foreach ($images as $image) {
								$fn = $image->getAttribute("src");
								$path = parse_url($fn, PHP_URL_PATH);
								$ext = pathinfo($path, PATHINFO_EXTENSION);
								if (SameText($ext, "php")) { // Image by script
									$fn = FullUrl($fn);
									$data = file_get_contents($fn);
									$fn = TempImage($data);
								}
								if (!file_exists($fn) || is_dir($fn))
									continue;
								$objDrawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
								$objDrawing->setWorksheet($sheet);
								$objDrawing->setPath($fn);
								$objDrawing->setOffsetX($totalW);
								$objDrawing->setCoordinates($letter . strval($m));
								if ($maxImageWidth > 0 && $objDrawing->getWidth() > $maxImageWidth)
									$objDrawing->setWidth($maxImageWidth);
								$size = array($objDrawing->getWidth(), $objDrawing->getHeight()); // Get image size
								if ($size[0] > 0) // Width
									$totalW += $size[0];
								$maxH = max($maxH, $size[1]); // Height
							}
							if ($totalW > 0) // Width
								$sheet->getColumnDimension($letter)->setAutoSize(FALSE)->setWidth($totalW * $widthMultiplier); // Set column width, no auto size
							if ($maxH > 0) // Height
								$sheet->getRowDimension($m)->setRowHeight($maxH * $heightMultiplier); // Set row height
						} else { // Text
							$value = trim($cell->textContent);
							if (function_exists("PhpSpreadsheet_Cell_Rendering")) // For user's own use only
								PhpSpreadsheet_Cell_Rendering($k, $m, $value, $sheet);
							if ($format == "Excel2007" && $row->parentNode->tagName == "thead") { // Caption
								$objRichText = new \PhpOffice\PhpSpreadsheet\RichText\RichText(); // Rich Text
								$obj = $objRichText->createTextRun($value);
								$obj->getFont()->setBold(TRUE); // Bold

								//$obj->getFont()->setItalic(true);
								//$obj->getFont()->setColor(new \PhpOffice\PhpSpreadsheet\Style\Color(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_DARKGREEN)); // Set color

								$sheet->getCellByColumnAndRow($k, $m)->setValue($objRichText);
							} else {
								$sheet->setCellValueByColumnAndRow($k, $m, $value);
							}
							$sheet->getColumnDimension($letter)->setAutoSize(TRUE);
							if (function_exists("PhpSpreadsheet_Cell_Rendered")) // For user's own use only
								PhpSpreadsheet_Cell_Rendered($k, $m, $value, $sheet);
						}
						if ($cell->hasAttribute("colspan")) {
							$k += (int)$cell->getAttribute("colspan");
						} else {
							$k++;
						}
					}
					if ($k > $maxcellcnt)
						$maxcellcnt = $k;
					$m++;
				}
				$m++;
			}
		}
		if (!DEBUG_ENABLED && ob_get_length())
			ob_end_clean();
		if ($format == "Excel5") {
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment; filename=' . $ExportFileName . '.xls');
		} else { // Excel2007
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment; filename=' . $ExportFileName . '.xlsx');
		}
		header('Cache-Control: max-age=0');
		header('Set-Cookie: fileDownload=true; path=/');
		$objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($phpspreadsheet, ($format == "Excel5") ? "Xls" : "Xlsx");
		$objWriter->save('php://output');
		DeleteTempImages();
		exit();
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
