<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$chambers_list = new chambers_list();

// Run the page
$chambers_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$chambers_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$chambers->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fchamberslist = currentForm = new ew.Form("fchamberslist", "list");
fchamberslist.formKeyCountName = '<?php echo $chambers_list->FormKeyCountName ?>';

// Form_CustomValidate event
fchamberslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fchamberslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fchamberslistsrch = currentSearchForm = new ew.Form("fchamberslistsrch");

// Filters
fchamberslistsrch.filterList = <?php echo $chambers_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$chambers->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($chambers_list->TotalRecs > 0 && $chambers_list->ExportOptions->visible()) { ?>
<?php $chambers_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($chambers_list->ImportOptions->visible()) { ?>
<?php $chambers_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($chambers_list->SearchOptions->visible()) { ?>
<?php $chambers_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($chambers_list->FilterOptions->visible()) { ?>
<?php $chambers_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$chambers_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$chambers->isExport() && !$chambers->CurrentAction) { ?>
<form name="fchamberslistsrch" id="fchamberslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($chambers_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fchamberslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="chambers">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($chambers_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($chambers_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $chambers_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($chambers_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($chambers_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($chambers_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($chambers_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $chambers_list->showPageHeader(); ?>
<?php
$chambers_list->showMessage();
?>
<?php if ($chambers_list->TotalRecs > 0 || $chambers->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($chambers_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> chambers">
<?php if (!$chambers->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$chambers->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($chambers_list->Pager)) $chambers_list->Pager = new PrevNextPager($chambers_list->StartRec, $chambers_list->DisplayRecs, $chambers_list->TotalRecs, $chambers_list->AutoHidePager) ?>
<?php if ($chambers_list->Pager->RecordCount > 0 && $chambers_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($chambers_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $chambers_list->pageUrl() ?>start=<?php echo $chambers_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($chambers_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $chambers_list->pageUrl() ?>start=<?php echo $chambers_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $chambers_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($chambers_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $chambers_list->pageUrl() ?>start=<?php echo $chambers_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($chambers_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $chambers_list->pageUrl() ?>start=<?php echo $chambers_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $chambers_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($chambers_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $chambers_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $chambers_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $chambers_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($chambers_list->TotalRecs > 0 && (!$chambers_list->AutoHidePageSizeSelector || $chambers_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="chambers">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($chambers_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($chambers_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($chambers_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($chambers_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($chambers_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($chambers_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($chambers_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($chambers_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($chambers_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($chambers->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $chambers_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fchamberslist" id="fchamberslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($chambers_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $chambers_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="chambers">
<div id="gmp_chambers" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($chambers_list->TotalRecs > 0 || $chambers->isGridEdit()) { ?>
<table id="tbl_chamberslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$chambers_list->RowType = ROWTYPE_HEADER;

// Render list options
$chambers_list->renderListOptions();

// Render list options (header, left)
$chambers_list->ListOptions->render("header", "left");
?>
<?php if ($chambers->Chamber->Visible) { // Chamber ?>
	<?php if ($chambers->sortUrl($chambers->Chamber) == "") { ?>
		<th data-name="Chamber" class="<?php echo $chambers->Chamber->headerCellClass() ?>"><div id="elh_chambers_Chamber" class="chambers_Chamber"><div class="ew-table-header-caption"><?php echo $chambers->Chamber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Chamber" class="<?php echo $chambers->Chamber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $chambers->SortUrl($chambers->Chamber) ?>',2);"><div id="elh_chambers_Chamber" class="chambers_Chamber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $chambers->Chamber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($chambers->Chamber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($chambers->Chamber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$chambers_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($chambers->ExportAll && $chambers->isExport()) {
	$chambers_list->StopRec = $chambers_list->TotalRecs;
} else {

	// Set the last record to display
	if ($chambers_list->TotalRecs > $chambers_list->StartRec + $chambers_list->DisplayRecs - 1)
		$chambers_list->StopRec = $chambers_list->StartRec + $chambers_list->DisplayRecs - 1;
	else
		$chambers_list->StopRec = $chambers_list->TotalRecs;
}
$chambers_list->RecCnt = $chambers_list->StartRec - 1;
if ($chambers_list->Recordset && !$chambers_list->Recordset->EOF) {
	$chambers_list->Recordset->moveFirst();
	$selectLimit = $chambers_list->UseSelectLimit;
	if (!$selectLimit && $chambers_list->StartRec > 1)
		$chambers_list->Recordset->move($chambers_list->StartRec - 1);
} elseif (!$chambers->AllowAddDeleteRow && $chambers_list->StopRec == 0) {
	$chambers_list->StopRec = $chambers->GridAddRowCount;
}

// Initialize aggregate
$chambers->RowType = ROWTYPE_AGGREGATEINIT;
$chambers->resetAttributes();
$chambers_list->renderRow();
while ($chambers_list->RecCnt < $chambers_list->StopRec) {
	$chambers_list->RecCnt++;
	if ($chambers_list->RecCnt >= $chambers_list->StartRec) {
		$chambers_list->RowCnt++;

		// Set up key count
		$chambers_list->KeyCount = $chambers_list->RowIndex;

		// Init row class and style
		$chambers->resetAttributes();
		$chambers->CssClass = "";
		if ($chambers->isGridAdd()) {
		} else {
			$chambers_list->loadRowValues($chambers_list->Recordset); // Load row values
		}
		$chambers->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$chambers->RowAttrs = array_merge($chambers->RowAttrs, array('data-rowindex'=>$chambers_list->RowCnt, 'id'=>'r' . $chambers_list->RowCnt . '_chambers', 'data-rowtype'=>$chambers->RowType));

		// Render row
		$chambers_list->renderRow();

		// Render list options
		$chambers_list->renderListOptions();
?>
	<tr<?php echo $chambers->rowAttributes() ?>>
<?php

// Render list options (body, left)
$chambers_list->ListOptions->render("body", "left", $chambers_list->RowCnt);
?>
	<?php if ($chambers->Chamber->Visible) { // Chamber ?>
		<td data-name="Chamber"<?php echo $chambers->Chamber->cellAttributes() ?>>
<span id="el<?php echo $chambers_list->RowCnt ?>_chambers_Chamber" class="chambers_Chamber">
<span<?php echo $chambers->Chamber->viewAttributes() ?>>
<?php echo $chambers->Chamber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$chambers_list->ListOptions->render("body", "right", $chambers_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$chambers->isGridAdd())
		$chambers_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$chambers->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($chambers_list->Recordset)
	$chambers_list->Recordset->Close();
?>
<?php if (!$chambers->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$chambers->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($chambers_list->Pager)) $chambers_list->Pager = new PrevNextPager($chambers_list->StartRec, $chambers_list->DisplayRecs, $chambers_list->TotalRecs, $chambers_list->AutoHidePager) ?>
<?php if ($chambers_list->Pager->RecordCount > 0 && $chambers_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($chambers_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $chambers_list->pageUrl() ?>start=<?php echo $chambers_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($chambers_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $chambers_list->pageUrl() ?>start=<?php echo $chambers_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $chambers_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($chambers_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $chambers_list->pageUrl() ?>start=<?php echo $chambers_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($chambers_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $chambers_list->pageUrl() ?>start=<?php echo $chambers_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $chambers_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($chambers_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $chambers_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $chambers_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $chambers_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($chambers_list->TotalRecs > 0 && (!$chambers_list->AutoHidePageSizeSelector || $chambers_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="chambers">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($chambers_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($chambers_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($chambers_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($chambers_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($chambers_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($chambers_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($chambers_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($chambers_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($chambers_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($chambers->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $chambers_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($chambers_list->TotalRecs == 0 && !$chambers->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $chambers_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$chambers_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$chambers->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$chambers->isExport()) { ?>
<script>
ew.scrollableTable("gmp_chambers", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$chambers_list->terminate();
?>
