<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cases_search = new cases_search();

// Run the page
$cases_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cases_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($cases_search->IsModal) { ?>
var fcasessearch = currentAdvancedSearchForm = new ew.Form("fcasessearch", "search");
<?php } else { ?>
var fcasessearch = currentForm = new ew.Form("fcasessearch", "search");
<?php } ?>

// Form_CustomValidate event
fcasessearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcasessearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcasessearch.lists["x_ClientID"] = <?php echo $cases_search->ClientID->Lookup->toClientList() ?>;
fcasessearch.lists["x_ClientID"].options = <?php echo JsonEncode($cases_search->ClientID->lookupOptions()) ?>;
fcasessearch.autoSuggests["x_ClientID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasessearch.lists["x_LitigantID"] = <?php echo $cases_search->LitigantID->Lookup->toClientList() ?>;
fcasessearch.lists["x_LitigantID"].options = <?php echo JsonEncode($cases_search->LitigantID->lookupOptions()) ?>;
fcasessearch.autoSuggests["x_LitigantID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasessearch.lists["x_CaseTypeID"] = <?php echo $cases_search->CaseTypeID->Lookup->toClientList() ?>;
fcasessearch.lists["x_CaseTypeID"].options = <?php echo JsonEncode($cases_search->CaseTypeID->lookupOptions()) ?>;
fcasessearch.lists["x_CourtID"] = <?php echo $cases_search->CourtID->Lookup->toClientList() ?>;
fcasessearch.lists["x_CourtID"].options = <?php echo JsonEncode($cases_search->CourtID->lookupOptions()) ?>;
fcasessearch.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasessearch.lists["x_ClientStatusID"] = <?php echo $cases_search->ClientStatusID->Lookup->toClientList() ?>;
fcasessearch.lists["x_ClientStatusID"].options = <?php echo JsonEncode($cases_search->ClientStatusID->lookupOptions()) ?>;
fcasessearch.lists["x_LitigantStatusID"] = <?php echo $cases_search->LitigantStatusID->Lookup->toClientList() ?>;
fcasessearch.lists["x_LitigantStatusID"].options = <?php echo JsonEncode($cases_search->LitigantStatusID->lookupOptions()) ?>;
fcasessearch.lists["x_JudgeID"] = <?php echo $cases_search->JudgeID->Lookup->toClientList() ?>;
fcasessearch.lists["x_JudgeID"].options = <?php echo JsonEncode($cases_search->JudgeID->lookupOptions()) ?>;
fcasessearch.lists["x_CaseSortID"] = <?php echo $cases_search->CaseSortID->Lookup->toClientList() ?>;
fcasessearch.lists["x_CaseSortID"].options = <?php echo JsonEncode($cases_search->CaseSortID->lookupOptions()) ?>;
fcasessearch.lists["x_CaseStatusID"] = <?php echo $cases_search->CaseStatusID->Lookup->toClientList() ?>;
fcasessearch.lists["x_CaseStatusID"].options = <?php echo JsonEncode($cases_search->CaseStatusID->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fcasessearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_CaseRegisteredDate");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cases->CaseRegisteredDate->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ParentCaseID");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cases->ParentCaseID->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $cases_search->showPageHeader(); ?>
<?php
$cases_search->showMessage();
?>
<form name="fcasessearch" id="fcasessearch" class="<?php echo $cases_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cases_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cases_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cases">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$cases_search->IsModal ?>">
<?php if (!$cases_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_casessearch" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($cases->CaseID->Visible) { // CaseID ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_CaseID" class="form-group row">
		<label class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_CaseID"><?php echo $cases->CaseID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseID" id="z_CaseID" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->CaseID->cellAttributes() ?>>
			<span id="el_cases_CaseID">
<input type="text" data-table="cases" data-field="x_CaseID" name="x_CaseID" id="x_CaseID" placeholder="<?php echo HtmlEncode($cases->CaseID->getPlaceHolder()) ?>" value="<?php echo $cases->CaseID->EditValue ?>"<?php echo $cases->CaseID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseID">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_CaseID"><?php echo $cases->CaseID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseID" id="z_CaseID" value="="></span></td>
		<td<?php echo $cases->CaseID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_CaseID">
<input type="text" data-table="cases" data-field="x_CaseID" name="x_CaseID" id="x_CaseID" placeholder="<?php echo HtmlEncode($cases->CaseID->getPlaceHolder()) ?>" value="<?php echo $cases->CaseID->EditValue ?>"<?php echo $cases->CaseID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->ClientID->Visible) { // ClientID ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_ClientID" class="form-group row">
		<label class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_ClientID"><?php echo $cases->ClientID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientID" id="z_ClientID" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->ClientID->cellAttributes() ?>>
			<span id="el_cases_ClientID">
<?php
$wrkonchange = "" . trim(@$cases->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientID" id="sv_x_ClientID" value="<?php echo RemoveHtml($cases->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>"<?php echo $cases->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->ClientID->ReadOnly || $cases->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->ClientID->displayValueSeparatorAttribute() ?>" name="x_ClientID" id="x_ClientID" value="<?php echo HtmlEncode($cases->ClientID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasessearch.createAutoSuggest({"id":"x_ClientID","forceSelect":false});
</script>
<?php echo $cases->ClientID->Lookup->getParamTag("p_x_ClientID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientID">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_ClientID"><?php echo $cases->ClientID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientID" id="z_ClientID" value="="></span></td>
		<td<?php echo $cases->ClientID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_ClientID">
<?php
$wrkonchange = "" . trim(@$cases->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientID" id="sv_x_ClientID" value="<?php echo RemoveHtml($cases->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>"<?php echo $cases->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->ClientID->ReadOnly || $cases->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->ClientID->displayValueSeparatorAttribute() ?>" name="x_ClientID" id="x_ClientID" value="<?php echo HtmlEncode($cases->ClientID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasessearch.createAutoSuggest({"id":"x_ClientID","forceSelect":false});
</script>
<?php echo $cases->ClientID->Lookup->getParamTag("p_x_ClientID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->LitigantID->Visible) { // LitigantID ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_LitigantID" class="form-group row">
		<label class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_LitigantID"><?php echo $cases->LitigantID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LitigantID" id="z_LitigantID" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->LitigantID->cellAttributes() ?>>
			<span id="el_cases_LitigantID">
<?php
$wrkonchange = "" . trim(@$cases->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x_LitigantID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_LitigantID" id="sv_x_LitigantID" value="<?php echo RemoveHtml($cases->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>"<?php echo $cases->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_LitigantID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->LitigantID->ReadOnly || $cases->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->LitigantID->displayValueSeparatorAttribute() ?>" name="x_LitigantID" id="x_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasessearch.createAutoSuggest({"id":"x_LitigantID","forceSelect":false});
</script>
<?php echo $cases->LitigantID->Lookup->getParamTag("p_x_LitigantID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_LitigantID">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_LitigantID"><?php echo $cases->LitigantID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LitigantID" id="z_LitigantID" value="="></span></td>
		<td<?php echo $cases->LitigantID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_LitigantID">
<?php
$wrkonchange = "" . trim(@$cases->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x_LitigantID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_LitigantID" id="sv_x_LitigantID" value="<?php echo RemoveHtml($cases->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>"<?php echo $cases->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_LitigantID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->LitigantID->ReadOnly || $cases->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->LitigantID->displayValueSeparatorAttribute() ?>" name="x_LitigantID" id="x_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasessearch.createAutoSuggest({"id":"x_LitigantID","forceSelect":false});
</script>
<?php echo $cases->LitigantID->Lookup->getParamTag("p_x_LitigantID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CaseTypeID->Visible) { // CaseTypeID ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_CaseTypeID" class="form-group row">
		<label for="x_CaseTypeID" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_CaseTypeID"><?php echo $cases->CaseTypeID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseTypeID" id="z_CaseTypeID" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->CaseTypeID->cellAttributes() ?>>
			<span id="el_cases_CaseTypeID">
<input type="text" data-table="cases" data-field="x_CaseTypeID" name="x_CaseTypeID" id="x_CaseTypeID" size="30" placeholder="<?php echo HtmlEncode($cases->CaseTypeID->getPlaceHolder()) ?>" value="<?php echo $cases->CaseTypeID->EditValue ?>"<?php echo $cases->CaseTypeID->editAttributes() ?>>
<?php echo $cases->CaseTypeID->Lookup->getParamTag("p_x_CaseTypeID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseTypeID">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_CaseTypeID"><?php echo $cases->CaseTypeID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseTypeID" id="z_CaseTypeID" value="="></span></td>
		<td<?php echo $cases->CaseTypeID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_CaseTypeID">
<input type="text" data-table="cases" data-field="x_CaseTypeID" name="x_CaseTypeID" id="x_CaseTypeID" size="30" placeholder="<?php echo HtmlEncode($cases->CaseTypeID->getPlaceHolder()) ?>" value="<?php echo $cases->CaseTypeID->EditValue ?>"<?php echo $cases->CaseTypeID->editAttributes() ?>>
<?php echo $cases->CaseTypeID->Lookup->getParamTag("p_x_CaseTypeID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CourtID->Visible) { // CourtID ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_CourtID" class="form-group row">
		<label class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_CourtID"><?php echo $cases->CourtID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CourtID" id="z_CourtID" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->CourtID->cellAttributes() ?>>
			<span id="el_cases_CourtID">
<?php
$wrkonchange = "" . trim(@$cases->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($cases->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>"<?php echo $cases->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CourtID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->CourtID->ReadOnly || $cases->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($cases->CourtID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasessearch.createAutoSuggest({"id":"x_CourtID","forceSelect":false});
</script>
<?php echo $cases->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtID">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_CourtID"><?php echo $cases->CourtID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CourtID" id="z_CourtID" value="="></span></td>
		<td<?php echo $cases->CourtID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_CourtID">
<?php
$wrkonchange = "" . trim(@$cases->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($cases->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>"<?php echo $cases->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CourtID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->CourtID->ReadOnly || $cases->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($cases->CourtID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasessearch.createAutoSuggest({"id":"x_CourtID","forceSelect":false});
</script>
<?php echo $cases->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CaseNumber->Visible) { // CaseNumber ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_CaseNumber" class="form-group row">
		<label for="x_CaseNumber" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_CaseNumber"><?php echo $cases->CaseNumber->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CaseNumber" id="z_CaseNumber" value="LIKE"></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->CaseNumber->cellAttributes() ?>>
			<span id="el_cases_CaseNumber">
<input type="text" data-table="cases" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases->CaseNumber->EditValue ?>"<?php echo $cases->CaseNumber->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseNumber">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_CaseNumber"><?php echo $cases->CaseNumber->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CaseNumber" id="z_CaseNumber" value="LIKE"></span></td>
		<td<?php echo $cases->CaseNumber->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_CaseNumber">
<input type="text" data-table="cases" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases->CaseNumber->EditValue ?>"<?php echo $cases->CaseNumber->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->FileNumber->Visible) { // FileNumber ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_FileNumber" class="form-group row">
		<label for="x_FileNumber" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_FileNumber"><?php echo $cases->FileNumber->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileNumber" id="z_FileNumber" value="LIKE"></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->FileNumber->cellAttributes() ?>>
			<span id="el_cases_FileNumber">
<input type="text" data-table="cases" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases->FileNumber->EditValue ?>"<?php echo $cases->FileNumber->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_FileNumber">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_FileNumber"><?php echo $cases->FileNumber->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileNumber" id="z_FileNumber" value="LIKE"></span></td>
		<td<?php echo $cases->FileNumber->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_FileNumber">
<input type="text" data-table="cases" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases->FileNumber->EditValue ?>"<?php echo $cases->FileNumber->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->ClientStatusID->Visible) { // ClientStatusID ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_ClientStatusID" class="form-group row">
		<label for="x_ClientStatusID" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_ClientStatusID"><?php echo $cases->ClientStatusID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientStatusID" id="z_ClientStatusID" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->ClientStatusID->cellAttributes() ?>>
			<span id="el_cases_ClientStatusID">
<input type="text" data-table="cases" data-field="x_ClientStatusID" name="x_ClientStatusID" id="x_ClientStatusID" size="30" placeholder="<?php echo HtmlEncode($cases->ClientStatusID->getPlaceHolder()) ?>" value="<?php echo $cases->ClientStatusID->EditValue ?>"<?php echo $cases->ClientStatusID->editAttributes() ?>>
<?php echo $cases->ClientStatusID->Lookup->getParamTag("p_x_ClientStatusID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientStatusID">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_ClientStatusID"><?php echo $cases->ClientStatusID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientStatusID" id="z_ClientStatusID" value="="></span></td>
		<td<?php echo $cases->ClientStatusID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_ClientStatusID">
<input type="text" data-table="cases" data-field="x_ClientStatusID" name="x_ClientStatusID" id="x_ClientStatusID" size="30" placeholder="<?php echo HtmlEncode($cases->ClientStatusID->getPlaceHolder()) ?>" value="<?php echo $cases->ClientStatusID->EditValue ?>"<?php echo $cases->ClientStatusID->editAttributes() ?>>
<?php echo $cases->ClientStatusID->Lookup->getParamTag("p_x_ClientStatusID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->LitigantStatusID->Visible) { // LitigantStatusID ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_LitigantStatusID" class="form-group row">
		<label for="x_LitigantStatusID" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_LitigantStatusID"><?php echo $cases->LitigantStatusID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LitigantStatusID" id="z_LitigantStatusID" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->LitigantStatusID->cellAttributes() ?>>
			<span id="el_cases_LitigantStatusID">
<input type="text" data-table="cases" data-field="x_LitigantStatusID" name="x_LitigantStatusID" id="x_LitigantStatusID" size="30" placeholder="<?php echo HtmlEncode($cases->LitigantStatusID->getPlaceHolder()) ?>" value="<?php echo $cases->LitigantStatusID->EditValue ?>"<?php echo $cases->LitigantStatusID->editAttributes() ?>>
<?php echo $cases->LitigantStatusID->Lookup->getParamTag("p_x_LitigantStatusID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_LitigantStatusID">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_LitigantStatusID"><?php echo $cases->LitigantStatusID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LitigantStatusID" id="z_LitigantStatusID" value="="></span></td>
		<td<?php echo $cases->LitigantStatusID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_LitigantStatusID">
<input type="text" data-table="cases" data-field="x_LitigantStatusID" name="x_LitigantStatusID" id="x_LitigantStatusID" size="30" placeholder="<?php echo HtmlEncode($cases->LitigantStatusID->getPlaceHolder()) ?>" value="<?php echo $cases->LitigantStatusID->EditValue ?>"<?php echo $cases->LitigantStatusID->editAttributes() ?>>
<?php echo $cases->LitigantStatusID->Lookup->getParamTag("p_x_LitigantStatusID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->JudgeID->Visible) { // JudgeID ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_JudgeID" class="form-group row">
		<label for="x_JudgeID" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_JudgeID"><?php echo $cases->JudgeID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_JudgeID" id="z_JudgeID" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->JudgeID->cellAttributes() ?>>
			<span id="el_cases_JudgeID">
<input type="text" data-table="cases" data-field="x_JudgeID" name="x_JudgeID" id="x_JudgeID" size="30" placeholder="<?php echo HtmlEncode($cases->JudgeID->getPlaceHolder()) ?>" value="<?php echo $cases->JudgeID->EditValue ?>"<?php echo $cases->JudgeID->editAttributes() ?>>
<?php echo $cases->JudgeID->Lookup->getParamTag("p_x_JudgeID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_JudgeID">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_JudgeID"><?php echo $cases->JudgeID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_JudgeID" id="z_JudgeID" value="="></span></td>
		<td<?php echo $cases->JudgeID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_JudgeID">
<input type="text" data-table="cases" data-field="x_JudgeID" name="x_JudgeID" id="x_JudgeID" size="30" placeholder="<?php echo HtmlEncode($cases->JudgeID->getPlaceHolder()) ?>" value="<?php echo $cases->JudgeID->EditValue ?>"<?php echo $cases->JudgeID->editAttributes() ?>>
<?php echo $cases->JudgeID->Lookup->getParamTag("p_x_JudgeID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->Notes->Visible) { // Notes ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_Notes"><?php echo $cases->Notes->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->Notes->cellAttributes() ?>>
			<span id="el_cases_Notes">
<input type="text" data-table="cases" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($cases->Notes->getPlaceHolder()) ?>" value="<?php echo $cases->Notes->EditValue ?>"<?php echo $cases->Notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_Notes"><?php echo $cases->Notes->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span></td>
		<td<?php echo $cases->Notes->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_Notes">
<input type="text" data-table="cases" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($cases->Notes->getPlaceHolder()) ?>" value="<?php echo $cases->Notes->EditValue ?>"<?php echo $cases->Notes->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->FileLocation->Visible) { // FileLocation ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_FileLocation" class="form-group row">
		<label for="x_FileLocation" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_FileLocation"><?php echo $cases->FileLocation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileLocation" id="z_FileLocation" value="LIKE"></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->FileLocation->cellAttributes() ?>>
			<span id="el_cases_FileLocation">
<input type="text" data-table="cases" data-field="x_FileLocation" name="x_FileLocation" id="x_FileLocation" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($cases->FileLocation->getPlaceHolder()) ?>" value="<?php echo $cases->FileLocation->EditValue ?>"<?php echo $cases->FileLocation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_FileLocation">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_FileLocation"><?php echo $cases->FileLocation->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileLocation" id="z_FileLocation" value="LIKE"></span></td>
		<td<?php echo $cases->FileLocation->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_FileLocation">
<input type="text" data-table="cases" data-field="x_FileLocation" name="x_FileLocation" id="x_FileLocation" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($cases->FileLocation->getPlaceHolder()) ?>" value="<?php echo $cases->FileLocation->EditValue ?>"<?php echo $cases->FileLocation->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->_Case->Visible) { // Case ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r__Case" class="form-group row">
		<label for="x__Case" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases__Case"><?php echo $cases->_Case->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__Case" id="z__Case" value="LIKE"></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->_Case->cellAttributes() ?>>
			<span id="el_cases__Case">
<input type="text" data-table="cases" data-field="x__Case" name="x__Case" id="x__Case" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->_Case->getPlaceHolder()) ?>" value="<?php echo $cases->_Case->EditValue ?>"<?php echo $cases->_Case->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r__Case">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases__Case"><?php echo $cases->_Case->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__Case" id="z__Case" value="LIKE"></span></td>
		<td<?php echo $cases->_Case->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases__Case">
<input type="text" data-table="cases" data-field="x__Case" name="x__Case" id="x__Case" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->_Case->getPlaceHolder()) ?>" value="<?php echo $cases->_Case->EditValue ?>"<?php echo $cases->_Case->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CaseSortID->Visible) { // CaseSortID ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_CaseSortID" class="form-group row">
		<label for="x_CaseSortID" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_CaseSortID"><?php echo $cases->CaseSortID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseSortID" id="z_CaseSortID" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->CaseSortID->cellAttributes() ?>>
			<span id="el_cases_CaseSortID">
<input type="text" data-table="cases" data-field="x_CaseSortID" name="x_CaseSortID" id="x_CaseSortID" size="30" placeholder="<?php echo HtmlEncode($cases->CaseSortID->getPlaceHolder()) ?>" value="<?php echo $cases->CaseSortID->EditValue ?>"<?php echo $cases->CaseSortID->editAttributes() ?>>
<?php echo $cases->CaseSortID->Lookup->getParamTag("p_x_CaseSortID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseSortID">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_CaseSortID"><?php echo $cases->CaseSortID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseSortID" id="z_CaseSortID" value="="></span></td>
		<td<?php echo $cases->CaseSortID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_CaseSortID">
<input type="text" data-table="cases" data-field="x_CaseSortID" name="x_CaseSortID" id="x_CaseSortID" size="30" placeholder="<?php echo HtmlEncode($cases->CaseSortID->getPlaceHolder()) ?>" value="<?php echo $cases->CaseSortID->EditValue ?>"<?php echo $cases->CaseSortID->editAttributes() ?>>
<?php echo $cases->CaseSortID->Lookup->getParamTag("p_x_CaseSortID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CaseRegisteredDate->Visible) { // CaseRegisteredDate ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_CaseRegisteredDate" class="form-group row">
		<label for="x_CaseRegisteredDate" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_CaseRegisteredDate"><?php echo $cases->CaseRegisteredDate->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseRegisteredDate" id="z_CaseRegisteredDate" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->CaseRegisteredDate->cellAttributes() ?>>
			<span id="el_cases_CaseRegisteredDate">
<input type="text" data-table="cases" data-field="x_CaseRegisteredDate" data-format="7" name="x_CaseRegisteredDate" id="x_CaseRegisteredDate" placeholder="<?php echo HtmlEncode($cases->CaseRegisteredDate->getPlaceHolder()) ?>" value="<?php echo $cases->CaseRegisteredDate->EditValue ?>"<?php echo $cases->CaseRegisteredDate->editAttributes() ?>>
<?php if (!$cases->CaseRegisteredDate->ReadOnly && !$cases->CaseRegisteredDate->Disabled && !isset($cases->CaseRegisteredDate->EditAttrs["readonly"]) && !isset($cases->CaseRegisteredDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcasessearch", "x_CaseRegisteredDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseRegisteredDate">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_CaseRegisteredDate"><?php echo $cases->CaseRegisteredDate->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseRegisteredDate" id="z_CaseRegisteredDate" value="="></span></td>
		<td<?php echo $cases->CaseRegisteredDate->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_CaseRegisteredDate">
<input type="text" data-table="cases" data-field="x_CaseRegisteredDate" data-format="7" name="x_CaseRegisteredDate" id="x_CaseRegisteredDate" placeholder="<?php echo HtmlEncode($cases->CaseRegisteredDate->getPlaceHolder()) ?>" value="<?php echo $cases->CaseRegisteredDate->EditValue ?>"<?php echo $cases->CaseRegisteredDate->editAttributes() ?>>
<?php if (!$cases->CaseRegisteredDate->ReadOnly && !$cases->CaseRegisteredDate->Disabled && !isset($cases->CaseRegisteredDate->EditAttrs["readonly"]) && !isset($cases->CaseRegisteredDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcasessearch", "x_CaseRegisteredDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CaseStatusID->Visible) { // CaseStatusID ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_CaseStatusID" class="form-group row">
		<label for="x_CaseStatusID" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_CaseStatusID"><?php echo $cases->CaseStatusID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseStatusID" id="z_CaseStatusID" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->CaseStatusID->cellAttributes() ?>>
			<span id="el_cases_CaseStatusID">
<input type="text" data-table="cases" data-field="x_CaseStatusID" name="x_CaseStatusID" id="x_CaseStatusID" size="30" placeholder="<?php echo HtmlEncode($cases->CaseStatusID->getPlaceHolder()) ?>" value="<?php echo $cases->CaseStatusID->EditValue ?>"<?php echo $cases->CaseStatusID->editAttributes() ?>>
<?php echo $cases->CaseStatusID->Lookup->getParamTag("p_x_CaseStatusID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseStatusID">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_CaseStatusID"><?php echo $cases->CaseStatusID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseStatusID" id="z_CaseStatusID" value="="></span></td>
		<td<?php echo $cases->CaseStatusID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_CaseStatusID">
<input type="text" data-table="cases" data-field="x_CaseStatusID" name="x_CaseStatusID" id="x_CaseStatusID" size="30" placeholder="<?php echo HtmlEncode($cases->CaseStatusID->getPlaceHolder()) ?>" value="<?php echo $cases->CaseStatusID->EditValue ?>"<?php echo $cases->CaseStatusID->editAttributes() ?>>
<?php echo $cases->CaseStatusID->Lookup->getParamTag("p_x_CaseStatusID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->ParentCaseID->Visible) { // ParentCaseID ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
	<div id="r_ParentCaseID" class="form-group row">
		<label for="x_ParentCaseID" class="<?php echo $cases_search->LeftColumnClass ?>"><span id="elh_cases_ParentCaseID"><?php echo $cases->ParentCaseID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ParentCaseID" id="z_ParentCaseID" value="="></span>
		</label>
		<div class="<?php echo $cases_search->RightColumnClass ?>"><div<?php echo $cases->ParentCaseID->cellAttributes() ?>>
			<span id="el_cases_ParentCaseID">
<input type="text" data-table="cases" data-field="x_ParentCaseID" name="x_ParentCaseID" id="x_ParentCaseID" size="30" placeholder="<?php echo HtmlEncode($cases->ParentCaseID->getPlaceHolder()) ?>" value="<?php echo $cases->ParentCaseID->EditValue ?>"<?php echo $cases->ParentCaseID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ParentCaseID">
		<td class="<?php echo $cases_search->TableLeftColumnClass ?>"><span id="elh_cases_ParentCaseID"><?php echo $cases->ParentCaseID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ParentCaseID" id="z_ParentCaseID" value="="></span></td>
		<td<?php echo $cases->ParentCaseID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases_ParentCaseID">
<input type="text" data-table="cases" data-field="x_ParentCaseID" name="x_ParentCaseID" id="x_ParentCaseID" size="30" placeholder="<?php echo HtmlEncode($cases->ParentCaseID->getPlaceHolder()) ?>" value="<?php echo $cases->ParentCaseID->EditValue ?>"<?php echo $cases->ParentCaseID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$cases_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $cases_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$cases_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$cases_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$cases_search->terminate();
?>
