<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cases_list = new cases_list();

// Run the page
$cases_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cases_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$cases->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcaseslist = currentForm = new ew.Form("fcaseslist", "list");
fcaseslist.formKeyCountName = '<?php echo $cases_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcaseslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcaseslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcaseslist.lists["x_ClientID"] = <?php echo $cases_list->ClientID->Lookup->toClientList() ?>;
fcaseslist.lists["x_ClientID"].options = <?php echo JsonEncode($cases_list->ClientID->lookupOptions()) ?>;
fcaseslist.autoSuggests["x_ClientID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcaseslist.lists["x_LitigantID"] = <?php echo $cases_list->LitigantID->Lookup->toClientList() ?>;
fcaseslist.lists["x_LitigantID"].options = <?php echo JsonEncode($cases_list->LitigantID->lookupOptions()) ?>;
fcaseslist.autoSuggests["x_LitigantID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcaseslist.lists["x_CaseTypeID"] = <?php echo $cases_list->CaseTypeID->Lookup->toClientList() ?>;
fcaseslist.lists["x_CaseTypeID"].options = <?php echo JsonEncode($cases_list->CaseTypeID->lookupOptions()) ?>;
fcaseslist.lists["x_CourtID"] = <?php echo $cases_list->CourtID->Lookup->toClientList() ?>;
fcaseslist.lists["x_CourtID"].options = <?php echo JsonEncode($cases_list->CourtID->lookupOptions()) ?>;
fcaseslist.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcaseslist.lists["x_ClientStatusID"] = <?php echo $cases_list->ClientStatusID->Lookup->toClientList() ?>;
fcaseslist.lists["x_ClientStatusID"].options = <?php echo JsonEncode($cases_list->ClientStatusID->lookupOptions()) ?>;
fcaseslist.lists["x_LitigantStatusID"] = <?php echo $cases_list->LitigantStatusID->Lookup->toClientList() ?>;
fcaseslist.lists["x_LitigantStatusID"].options = <?php echo JsonEncode($cases_list->LitigantStatusID->lookupOptions()) ?>;

// Form object for search
var fcaseslistsrch = currentSearchForm = new ew.Form("fcaseslistsrch");

// Filters
fcaseslistsrch.filterList = <?php echo $cases_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #00FFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$cases->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($cases_list->TotalRecs > 0 && $cases_list->ExportOptions->visible()) { ?>
<?php $cases_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($cases_list->ImportOptions->visible()) { ?>
<?php $cases_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($cases_list->SearchOptions->visible()) { ?>
<?php $cases_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($cases_list->FilterOptions->visible()) { ?>
<?php $cases_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$cases->isExport() || EXPORT_MASTER_RECORD && $cases->isExport("print")) { ?>
<?php
if ($cases_list->DbMasterFilter <> "" && $cases->getCurrentMasterTable() == "clients") {
	if ($cases_list->MasterRecordExists) {
		include_once "clientsmaster.php";
	}
}
?>
<?php
if ($cases_list->DbMasterFilter <> "" && $cases->getCurrentMasterTable() == "litigants") {
	if ($cases_list->MasterRecordExists) {
		include_once "litigantsmaster.php";
	}
}
?>
<?php } ?>
<?php
$cases_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$cases->isExport() && !$cases->CurrentAction) { ?>
<form name="fcaseslistsrch" id="fcaseslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($cases_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fcaseslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="cases">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($cases_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($cases_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $cases_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($cases_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($cases_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($cases_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($cases_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $cases_list->showPageHeader(); ?>
<?php
$cases_list->showMessage();
?>
<?php if ($cases_list->TotalRecs > 0 || $cases->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($cases_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> cases">
<?php if (!$cases->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$cases->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cases_list->Pager)) $cases_list->Pager = new PrevNextPager($cases_list->StartRec, $cases_list->DisplayRecs, $cases_list->TotalRecs, $cases_list->AutoHidePager) ?>
<?php if ($cases_list->Pager->RecordCount > 0 && $cases_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cases_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cases_list->pageUrl() ?>start=<?php echo $cases_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cases_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cases_list->pageUrl() ?>start=<?php echo $cases_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cases_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cases_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cases_list->pageUrl() ?>start=<?php echo $cases_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cases_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cases_list->pageUrl() ?>start=<?php echo $cases_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cases_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($cases_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $cases_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $cases_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $cases_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($cases_list->TotalRecs > 0 && (!$cases_list->AutoHidePageSizeSelector || $cases_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="cases">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($cases_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($cases_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($cases_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($cases_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($cases_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($cases_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($cases_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($cases_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($cases_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($cases->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $cases_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcaseslist" id="fcaseslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cases_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cases_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cases">
<?php if ($cases->getCurrentMasterTable() == "clients" && $cases->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="clients">
<input type="hidden" name="fk_ClientID" value="<?php echo $cases->ClientID->getSessionValue() ?>">
<?php } ?>
<?php if ($cases->getCurrentMasterTable() == "litigants" && $cases->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="litigants">
<input type="hidden" name="fk_LitigantID" value="<?php echo $cases->LitigantID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_cases" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($cases_list->TotalRecs > 0 || $cases->isGridEdit()) { ?>
<table id="tbl_caseslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$cases_list->RowType = ROWTYPE_HEADER;

// Render list options
$cases_list->renderListOptions();

// Render list options (header, left)
$cases_list->ListOptions->render("header", "left");
?>
<?php if ($cases->ClientID->Visible) { // ClientID ?>
	<?php if ($cases->sortUrl($cases->ClientID) == "") { ?>
		<th data-name="ClientID" class="<?php echo $cases->ClientID->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_cases_ClientID" class="cases_ClientID"><div class="ew-table-header-caption"><?php echo $cases->ClientID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientID" class="<?php echo $cases->ClientID->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->ClientID) ?>',2);"><div id="elh_cases_ClientID" class="cases_ClientID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->ClientID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->ClientID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->ClientID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->LitigantID->Visible) { // LitigantID ?>
	<?php if ($cases->sortUrl($cases->LitigantID) == "") { ?>
		<th data-name="LitigantID" class="<?php echo $cases->LitigantID->headerCellClass() ?>" style="width: 250px; white-space: nowrap;"><div id="elh_cases_LitigantID" class="cases_LitigantID"><div class="ew-table-header-caption"><?php echo $cases->LitigantID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantID" class="<?php echo $cases->LitigantID->headerCellClass() ?>" style="width: 250px; white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->LitigantID) ?>',2);"><div id="elh_cases_LitigantID" class="cases_LitigantID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->LitigantID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->LitigantID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->LitigantID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->CaseTypeID->Visible) { // CaseTypeID ?>
	<?php if ($cases->sortUrl($cases->CaseTypeID) == "") { ?>
		<th data-name="CaseTypeID" class="<?php echo $cases->CaseTypeID->headerCellClass() ?>" style="min-width: 120px;"><div id="elh_cases_CaseTypeID" class="cases_CaseTypeID"><div class="ew-table-header-caption"><?php echo $cases->CaseTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseTypeID" class="<?php echo $cases->CaseTypeID->headerCellClass() ?>" style="min-width: 120px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->CaseTypeID) ?>',2);"><div id="elh_cases_CaseTypeID" class="cases_CaseTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->CaseTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->CaseTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->CaseTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->CourtID->Visible) { // CourtID ?>
	<?php if ($cases->sortUrl($cases->CourtID) == "") { ?>
		<th data-name="CourtID" class="<?php echo $cases->CourtID->headerCellClass() ?>" style="width: 200px; white-space: nowrap;"><div id="elh_cases_CourtID" class="cases_CourtID"><div class="ew-table-header-caption"><?php echo $cases->CourtID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtID" class="<?php echo $cases->CourtID->headerCellClass() ?>" style="width: 200px; white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->CourtID) ?>',2);"><div id="elh_cases_CourtID" class="cases_CourtID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->CourtID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->CourtID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->CourtID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($cases->sortUrl($cases->CaseNumber) == "") { ?>
		<th data-name="CaseNumber" class="<?php echo $cases->CaseNumber->headerCellClass() ?>"><div id="elh_cases_CaseNumber" class="cases_CaseNumber"><div class="ew-table-header-caption"><?php echo $cases->CaseNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseNumber" class="<?php echo $cases->CaseNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->CaseNumber) ?>',2);"><div id="elh_cases_CaseNumber" class="cases_CaseNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->CaseNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cases->CaseNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->CaseNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->FileNumber->Visible) { // FileNumber ?>
	<?php if ($cases->sortUrl($cases->FileNumber) == "") { ?>
		<th data-name="FileNumber" class="<?php echo $cases->FileNumber->headerCellClass() ?>"><div id="elh_cases_FileNumber" class="cases_FileNumber"><div class="ew-table-header-caption"><?php echo $cases->FileNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FileNumber" class="<?php echo $cases->FileNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->FileNumber) ?>',2);"><div id="elh_cases_FileNumber" class="cases_FileNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->FileNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cases->FileNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->FileNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->ClientStatusID->Visible) { // ClientStatusID ?>
	<?php if ($cases->sortUrl($cases->ClientStatusID) == "") { ?>
		<th data-name="ClientStatusID" class="<?php echo $cases->ClientStatusID->headerCellClass() ?>"><div id="elh_cases_ClientStatusID" class="cases_ClientStatusID"><div class="ew-table-header-caption"><?php echo $cases->ClientStatusID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientStatusID" class="<?php echo $cases->ClientStatusID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->ClientStatusID) ?>',2);"><div id="elh_cases_ClientStatusID" class="cases_ClientStatusID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->ClientStatusID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->ClientStatusID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->ClientStatusID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->LitigantStatusID->Visible) { // LitigantStatusID ?>
	<?php if ($cases->sortUrl($cases->LitigantStatusID) == "") { ?>
		<th data-name="LitigantStatusID" class="<?php echo $cases->LitigantStatusID->headerCellClass() ?>"><div id="elh_cases_LitigantStatusID" class="cases_LitigantStatusID"><div class="ew-table-header-caption"><?php echo $cases->LitigantStatusID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantStatusID" class="<?php echo $cases->LitigantStatusID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->LitigantStatusID) ?>',2);"><div id="elh_cases_LitigantStatusID" class="cases_LitigantStatusID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->LitigantStatusID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->LitigantStatusID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->LitigantStatusID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->Notes->Visible) { // Notes ?>
	<?php if ($cases->sortUrl($cases->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $cases->Notes->headerCellClass() ?>" style="min-width: 200px;"><div id="elh_cases_Notes" class="cases_Notes"><div class="ew-table-header-caption"><?php echo $cases->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $cases->Notes->headerCellClass() ?>" style="min-width: 200px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->Notes) ?>',2);"><div id="elh_cases_Notes" class="cases_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cases->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->ParentCaseID->Visible) { // ParentCaseID ?>
	<?php if ($cases->sortUrl($cases->ParentCaseID) == "") { ?>
		<th data-name="ParentCaseID" class="<?php echo $cases->ParentCaseID->headerCellClass() ?>"><div id="elh_cases_ParentCaseID" class="cases_ParentCaseID"><div class="ew-table-header-caption"><?php echo $cases->ParentCaseID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ParentCaseID" class="<?php echo $cases->ParentCaseID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->ParentCaseID) ?>',2);"><div id="elh_cases_ParentCaseID" class="cases_ParentCaseID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->ParentCaseID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->ParentCaseID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->ParentCaseID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->FileNumber2->Visible) { // FileNumber2 ?>
	<?php if ($cases->sortUrl($cases->FileNumber2) == "") { ?>
		<th data-name="FileNumber2" class="<?php echo $cases->FileNumber2->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_cases_FileNumber2" class="cases_FileNumber2"><div class="ew-table-header-caption"><?php echo $cases->FileNumber2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FileNumber2" class="<?php echo $cases->FileNumber2->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->FileNumber2) ?>',2);"><div id="elh_cases_FileNumber2" class="cases_FileNumber2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->FileNumber2->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->FileNumber2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->FileNumber2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->ClientNameConvFiles->Visible) { // ClientNameConvFiles ?>
	<?php if ($cases->sortUrl($cases->ClientNameConvFiles) == "") { ?>
		<th data-name="ClientNameConvFiles" class="<?php echo $cases->ClientNameConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_cases_ClientNameConvFiles" class="cases_ClientNameConvFiles"><div class="ew-table-header-caption"><?php echo $cases->ClientNameConvFiles->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientNameConvFiles" class="<?php echo $cases->ClientNameConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->ClientNameConvFiles) ?>',2);"><div id="elh_cases_ClientNameConvFiles" class="cases_ClientNameConvFiles">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->ClientNameConvFiles->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cases->ClientNameConvFiles->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->ClientNameConvFiles->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->LitigantNameConvFiles->Visible) { // LitigantNameConvFiles ?>
	<?php if ($cases->sortUrl($cases->LitigantNameConvFiles) == "") { ?>
		<th data-name="LitigantNameConvFiles" class="<?php echo $cases->LitigantNameConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_cases_LitigantNameConvFiles" class="cases_LitigantNameConvFiles"><div class="ew-table-header-caption"><?php echo $cases->LitigantNameConvFiles->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantNameConvFiles" class="<?php echo $cases->LitigantNameConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->LitigantNameConvFiles) ?>',2);"><div id="elh_cases_LitigantNameConvFiles" class="cases_LitigantNameConvFiles">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->LitigantNameConvFiles->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cases->LitigantNameConvFiles->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->LitigantNameConvFiles->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->CaseTypeConvFiles->Visible) { // CaseTypeConvFiles ?>
	<?php if ($cases->sortUrl($cases->CaseTypeConvFiles) == "") { ?>
		<th data-name="CaseTypeConvFiles" class="<?php echo $cases->CaseTypeConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_cases_CaseTypeConvFiles" class="cases_CaseTypeConvFiles"><div class="ew-table-header-caption"><?php echo $cases->CaseTypeConvFiles->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseTypeConvFiles" class="<?php echo $cases->CaseTypeConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases->SortUrl($cases->CaseTypeConvFiles) ?>',2);"><div id="elh_cases_CaseTypeConvFiles" class="cases_CaseTypeConvFiles">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->CaseTypeConvFiles->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cases->CaseTypeConvFiles->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->CaseTypeConvFiles->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$cases_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($cases->ExportAll && $cases->isExport()) {
	$cases_list->StopRec = $cases_list->TotalRecs;
} else {

	// Set the last record to display
	if ($cases_list->TotalRecs > $cases_list->StartRec + $cases_list->DisplayRecs - 1)
		$cases_list->StopRec = $cases_list->StartRec + $cases_list->DisplayRecs - 1;
	else
		$cases_list->StopRec = $cases_list->TotalRecs;
}
$cases_list->RecCnt = $cases_list->StartRec - 1;
if ($cases_list->Recordset && !$cases_list->Recordset->EOF) {
	$cases_list->Recordset->moveFirst();
	$selectLimit = $cases_list->UseSelectLimit;
	if (!$selectLimit && $cases_list->StartRec > 1)
		$cases_list->Recordset->move($cases_list->StartRec - 1);
} elseif (!$cases->AllowAddDeleteRow && $cases_list->StopRec == 0) {
	$cases_list->StopRec = $cases->GridAddRowCount;
}

// Initialize aggregate
$cases->RowType = ROWTYPE_AGGREGATEINIT;
$cases->resetAttributes();
$cases_list->renderRow();
while ($cases_list->RecCnt < $cases_list->StopRec) {
	$cases_list->RecCnt++;
	if ($cases_list->RecCnt >= $cases_list->StartRec) {
		$cases_list->RowCnt++;

		// Set up key count
		$cases_list->KeyCount = $cases_list->RowIndex;

		// Init row class and style
		$cases->resetAttributes();
		$cases->CssClass = "";
		if ($cases->isGridAdd()) {
		} else {
			$cases_list->loadRowValues($cases_list->Recordset); // Load row values
		}
		$cases->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$cases->RowAttrs = array_merge($cases->RowAttrs, array('data-rowindex'=>$cases_list->RowCnt, 'id'=>'r' . $cases_list->RowCnt . '_cases', 'data-rowtype'=>$cases->RowType));

		// Render row
		$cases_list->renderRow();

		// Render list options
		$cases_list->renderListOptions();
?>
	<tr<?php echo $cases->rowAttributes() ?>>
<?php

// Render list options (body, left)
$cases_list->ListOptions->render("body", "left", $cases_list->RowCnt);
?>
	<?php if ($cases->ClientID->Visible) { // ClientID ?>
		<td data-name="ClientID"<?php echo $cases->ClientID->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_ClientID" class="cases_ClientID">
<span<?php echo $cases->ClientID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->ClientID->getViewValue())) && $cases->ClientID->linkAttributes() <> "") { ?>
<a<?php echo $cases->ClientID->linkAttributes() ?>><?php echo $cases->ClientID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases->ClientID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->LitigantID->Visible) { // LitigantID ?>
		<td data-name="LitigantID"<?php echo $cases->LitigantID->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_LitigantID" class="cases_LitigantID">
<span<?php echo $cases->LitigantID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->LitigantID->getViewValue())) && $cases->LitigantID->linkAttributes() <> "") { ?>
<a<?php echo $cases->LitigantID->linkAttributes() ?>><?php echo $cases->LitigantID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases->LitigantID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->CaseTypeID->Visible) { // CaseTypeID ?>
		<td data-name="CaseTypeID"<?php echo $cases->CaseTypeID->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_CaseTypeID" class="cases_CaseTypeID">
<span<?php echo $cases->CaseTypeID->viewAttributes() ?>>
<?php echo $cases->CaseTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID"<?php echo $cases->CourtID->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_CourtID" class="cases_CourtID">
<span<?php echo $cases->CourtID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->CourtID->getViewValue())) && $cases->CourtID->linkAttributes() <> "") { ?>
<a<?php echo $cases->CourtID->linkAttributes() ?>><?php echo $cases->CourtID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases->CourtID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber"<?php echo $cases->CaseNumber->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_CaseNumber" class="cases_CaseNumber">
<span<?php echo $cases->CaseNumber->viewAttributes() ?>>
<?php echo $cases->CaseNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->FileNumber->Visible) { // FileNumber ?>
		<td data-name="FileNumber"<?php echo $cases->FileNumber->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_FileNumber" class="cases_FileNumber">
<span<?php echo $cases->FileNumber->viewAttributes() ?>>
<?php echo $cases->FileNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->ClientStatusID->Visible) { // ClientStatusID ?>
		<td data-name="ClientStatusID"<?php echo $cases->ClientStatusID->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_ClientStatusID" class="cases_ClientStatusID">
<span<?php echo $cases->ClientStatusID->viewAttributes() ?>>
<?php echo $cases->ClientStatusID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->LitigantStatusID->Visible) { // LitigantStatusID ?>
		<td data-name="LitigantStatusID"<?php echo $cases->LitigantStatusID->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_LitigantStatusID" class="cases_LitigantStatusID">
<span<?php echo $cases->LitigantStatusID->viewAttributes() ?>>
<?php echo $cases->LitigantStatusID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $cases->Notes->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_Notes" class="cases_Notes">
<span<?php echo $cases->Notes->viewAttributes() ?>>
<?php echo $cases->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->ParentCaseID->Visible) { // ParentCaseID ?>
		<td data-name="ParentCaseID"<?php echo $cases->ParentCaseID->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_ParentCaseID" class="cases_ParentCaseID">
<span<?php echo $cases->ParentCaseID->viewAttributes() ?>>
<?php echo $cases->ParentCaseID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->FileNumber2->Visible) { // FileNumber2 ?>
		<td data-name="FileNumber2"<?php echo $cases->FileNumber2->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_FileNumber2" class="cases_FileNumber2">
<span<?php echo $cases->FileNumber2->viewAttributes() ?>>
<?php echo $cases->FileNumber2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->ClientNameConvFiles->Visible) { // ClientNameConvFiles ?>
		<td data-name="ClientNameConvFiles"<?php echo $cases->ClientNameConvFiles->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_ClientNameConvFiles" class="cases_ClientNameConvFiles">
<span<?php echo $cases->ClientNameConvFiles->viewAttributes() ?>>
<?php echo $cases->ClientNameConvFiles->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->LitigantNameConvFiles->Visible) { // LitigantNameConvFiles ?>
		<td data-name="LitigantNameConvFiles"<?php echo $cases->LitigantNameConvFiles->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_LitigantNameConvFiles" class="cases_LitigantNameConvFiles">
<span<?php echo $cases->LitigantNameConvFiles->viewAttributes() ?>>
<?php echo $cases->LitigantNameConvFiles->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases->CaseTypeConvFiles->Visible) { // CaseTypeConvFiles ?>
		<td data-name="CaseTypeConvFiles"<?php echo $cases->CaseTypeConvFiles->cellAttributes() ?>>
<span id="el<?php echo $cases_list->RowCnt ?>_cases_CaseTypeConvFiles" class="cases_CaseTypeConvFiles">
<span<?php echo $cases->CaseTypeConvFiles->viewAttributes() ?>>
<?php echo $cases->CaseTypeConvFiles->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$cases_list->ListOptions->render("body", "right", $cases_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$cases->isGridAdd())
		$cases_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$cases->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($cases_list->Recordset)
	$cases_list->Recordset->Close();
?>
<?php if (!$cases->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$cases->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cases_list->Pager)) $cases_list->Pager = new PrevNextPager($cases_list->StartRec, $cases_list->DisplayRecs, $cases_list->TotalRecs, $cases_list->AutoHidePager) ?>
<?php if ($cases_list->Pager->RecordCount > 0 && $cases_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cases_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cases_list->pageUrl() ?>start=<?php echo $cases_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cases_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cases_list->pageUrl() ?>start=<?php echo $cases_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cases_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cases_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cases_list->pageUrl() ?>start=<?php echo $cases_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cases_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cases_list->pageUrl() ?>start=<?php echo $cases_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cases_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($cases_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $cases_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $cases_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $cases_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($cases_list->TotalRecs > 0 && (!$cases_list->AutoHidePageSizeSelector || $cases_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="cases">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($cases_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($cases_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($cases_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($cases_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($cases_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($cases_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($cases_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($cases_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($cases_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($cases->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $cases_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($cases_list->TotalRecs == 0 && !$cases->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $cases_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$cases_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$cases->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$cases->isExport()) { ?>
<script>
ew.scrollableTable("gmp_cases", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$cases_list->terminate();
?>
