<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cases_addopt = new cases_addopt();

// Run the page
$cases_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cases_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fcasesaddopt = currentForm = new ew.Form("fcasesaddopt", "addopt");

// Validate form
fcasesaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($cases_addopt->ClientID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->ClientID->caption(), $cases->ClientID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->LitigantID->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->LitigantID->caption(), $cases->LitigantID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->CaseTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseTypeID->caption(), $cases->CaseTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->CourtID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CourtID->caption(), $cases->CourtID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->CaseNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseNumber->caption(), $cases->CaseNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->FileNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_FileNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->FileNumber->caption(), $cases->FileNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->EnvelopeNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_EnvelopeNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->EnvelopeNumber->caption(), $cases->EnvelopeNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->ClientStatusID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientStatusID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->ClientStatusID->caption(), $cases->ClientStatusID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->LitigantStatusID->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantStatusID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->LitigantStatusID->caption(), $cases->LitigantStatusID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->JudgeID->Required) { ?>
			elm = this.getElements("x" + infix + "_JudgeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->JudgeID->caption(), $cases->JudgeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->Notes->caption(), $cases->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->FileLocation->Required) { ?>
			elm = this.getElements("x" + infix + "_FileLocation");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->FileLocation->caption(), $cases->FileLocation->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->_Case->Required) { ?>
			elm = this.getElements("x" + infix + "__Case");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->_Case->caption(), $cases->_Case->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->CaseRegisteredDate->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseRegisteredDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseRegisteredDate->caption(), $cases->CaseRegisteredDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_CaseRegisteredDate");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cases->CaseRegisteredDate->errorMessage()) ?>");
		<?php if ($cases_addopt->CaseStatusID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseStatusID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseStatusID->caption(), $cases->CaseStatusID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_addopt->ParentCaseID->Required) { ?>
			elm = this.getElements("x" + infix + "_ParentCaseID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->ParentCaseID->caption(), $cases->ParentCaseID->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ParentCaseID");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cases->ParentCaseID->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcasesaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcasesaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcasesaddopt.lists["x_ClientID"] = <?php echo $cases_addopt->ClientID->Lookup->toClientList() ?>;
fcasesaddopt.lists["x_ClientID"].options = <?php echo JsonEncode($cases_addopt->ClientID->lookupOptions()) ?>;
fcasesaddopt.autoSuggests["x_ClientID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesaddopt.lists["x_LitigantID"] = <?php echo $cases_addopt->LitigantID->Lookup->toClientList() ?>;
fcasesaddopt.lists["x_LitigantID"].options = <?php echo JsonEncode($cases_addopt->LitigantID->lookupOptions()) ?>;
fcasesaddopt.autoSuggests["x_LitigantID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesaddopt.lists["x_CaseTypeID"] = <?php echo $cases_addopt->CaseTypeID->Lookup->toClientList() ?>;
fcasesaddopt.lists["x_CaseTypeID"].options = <?php echo JsonEncode($cases_addopt->CaseTypeID->lookupOptions()) ?>;
fcasesaddopt.lists["x_CourtID"] = <?php echo $cases_addopt->CourtID->Lookup->toClientList() ?>;
fcasesaddopt.lists["x_CourtID"].options = <?php echo JsonEncode($cases_addopt->CourtID->lookupOptions()) ?>;
fcasesaddopt.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesaddopt.lists["x_ClientStatusID"] = <?php echo $cases_addopt->ClientStatusID->Lookup->toClientList() ?>;
fcasesaddopt.lists["x_ClientStatusID"].options = <?php echo JsonEncode($cases_addopt->ClientStatusID->lookupOptions()) ?>;
fcasesaddopt.lists["x_LitigantStatusID"] = <?php echo $cases_addopt->LitigantStatusID->Lookup->toClientList() ?>;
fcasesaddopt.lists["x_LitigantStatusID"].options = <?php echo JsonEncode($cases_addopt->LitigantStatusID->lookupOptions()) ?>;
fcasesaddopt.lists["x_JudgeID"] = <?php echo $cases_addopt->JudgeID->Lookup->toClientList() ?>;
fcasesaddopt.lists["x_JudgeID"].options = <?php echo JsonEncode($cases_addopt->JudgeID->lookupOptions()) ?>;
fcasesaddopt.lists["x_CaseStatusID"] = <?php echo $cases_addopt->CaseStatusID->Lookup->toClientList() ?>;
fcasesaddopt.lists["x_CaseStatusID"].options = <?php echo JsonEncode($cases_addopt->CaseStatusID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $cases_addopt->showPageHeader(); ?>
<?php
$cases_addopt->showMessage();
?>
<form name="fcasesaddopt" id="fcasesaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($cases_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cases_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $cases_addopt->TableVar ?>">
<?php if ($cases->ClientID->Visible) { // ClientID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $cases->ClientID->caption() ?><?php echo ($cases->ClientID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "" . trim(@$cases->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientID" id="sv_x_ClientID" value="<?php echo RemoveHtml($cases->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>"<?php echo $cases->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->ClientID->ReadOnly || $cases->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->ClientID->displayValueSeparatorAttribute() ?>" name="x_ClientID" id="x_ClientID" value="<?php echo HtmlEncode($cases->ClientID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesaddopt.createAutoSuggest({"id":"x_ClientID","forceSelect":true});
</script>
<?php echo $cases->ClientID->Lookup->getParamTag("p_x_ClientID") ?>
</div>
	</div>
<?php } ?>
<?php if ($cases->LitigantID->Visible) { // LitigantID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $cases->LitigantID->caption() ?><?php echo ($cases->LitigantID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "" . trim(@$cases->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x_LitigantID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_LitigantID" id="sv_x_LitigantID" value="<?php echo RemoveHtml($cases->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>"<?php echo $cases->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_LitigantID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->LitigantID->ReadOnly || $cases->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->LitigantID->displayValueSeparatorAttribute() ?>" name="x_LitigantID" id="x_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesaddopt.createAutoSuggest({"id":"x_LitigantID","forceSelect":true});
</script>
<?php echo $cases->LitigantID->Lookup->getParamTag("p_x_LitigantID") ?>
</div>
	</div>
<?php } ?>
<?php if ($cases->CaseTypeID->Visible) { // CaseTypeID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_CaseTypeID"><?php echo $cases->CaseTypeID->caption() ?><?php echo ($cases->CaseTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_CaseTypeID" data-value-separator="<?php echo $cases->CaseTypeID->displayValueSeparatorAttribute() ?>" id="x_CaseTypeID" name="x_CaseTypeID"<?php echo $cases->CaseTypeID->editAttributes() ?>>
		<?php echo $cases->CaseTypeID->selectOptionListHtml("x_CaseTypeID") ?>
	</select>
</div>
<?php echo $cases->CaseTypeID->Lookup->getParamTag("p_x_CaseTypeID") ?>
</div>
	</div>
<?php } ?>
<?php if ($cases->CourtID->Visible) { // CourtID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $cases->CourtID->caption() ?><?php echo ($cases->CourtID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "" . trim(@$cases->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($cases->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>"<?php echo $cases->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->CourtID->ReadOnly || $cases->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($cases->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesaddopt.createAutoSuggest({"id":"x_CourtID","forceSelect":true});
</script>
<?php echo $cases->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</div>
	</div>
<?php } ?>
<?php if ($cases->CaseNumber->Visible) { // CaseNumber ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_CaseNumber"><?php echo $cases->CaseNumber->caption() ?><?php echo ($cases->CaseNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="cases" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases->CaseNumber->EditValue ?>"<?php echo $cases->CaseNumber->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($cases->FileNumber->Visible) { // FileNumber ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_FileNumber"><?php echo $cases->FileNumber->caption() ?><?php echo ($cases->FileNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="cases" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases->FileNumber->EditValue ?>"<?php echo $cases->FileNumber->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($cases->EnvelopeNumber->Visible) { // EnvelopeNumber ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_EnvelopeNumber"><?php echo $cases->EnvelopeNumber->caption() ?><?php echo ($cases->EnvelopeNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="cases" data-field="x_EnvelopeNumber" name="x_EnvelopeNumber" id="x_EnvelopeNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->EnvelopeNumber->getPlaceHolder()) ?>" value="<?php echo $cases->EnvelopeNumber->EditValue ?>"<?php echo $cases->EnvelopeNumber->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($cases->ClientStatusID->Visible) { // ClientStatusID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_ClientStatusID"><?php echo $cases->ClientStatusID->caption() ?><?php echo ($cases->ClientStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_ClientStatusID" data-value-separator="<?php echo $cases->ClientStatusID->displayValueSeparatorAttribute() ?>" id="x_ClientStatusID" name="x_ClientStatusID"<?php echo $cases->ClientStatusID->editAttributes() ?>>
		<?php echo $cases->ClientStatusID->selectOptionListHtml("x_ClientStatusID") ?>
	</select>
</div>
<?php echo $cases->ClientStatusID->Lookup->getParamTag("p_x_ClientStatusID") ?>
</div>
	</div>
<?php } ?>
<?php if ($cases->LitigantStatusID->Visible) { // LitigantStatusID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_LitigantStatusID"><?php echo $cases->LitigantStatusID->caption() ?><?php echo ($cases->LitigantStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_LitigantStatusID" data-value-separator="<?php echo $cases->LitigantStatusID->displayValueSeparatorAttribute() ?>" id="x_LitigantStatusID" name="x_LitigantStatusID"<?php echo $cases->LitigantStatusID->editAttributes() ?>>
		<?php echo $cases->LitigantStatusID->selectOptionListHtml("x_LitigantStatusID") ?>
	</select>
</div>
<?php echo $cases->LitigantStatusID->Lookup->getParamTag("p_x_LitigantStatusID") ?>
</div>
	</div>
<?php } ?>
<?php if ($cases->JudgeID->Visible) { // JudgeID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_JudgeID"><?php echo $cases->JudgeID->caption() ?><?php echo ($cases->JudgeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_JudgeID" data-value-separator="<?php echo $cases->JudgeID->displayValueSeparatorAttribute() ?>" id="x_JudgeID" name="x_JudgeID"<?php echo $cases->JudgeID->editAttributes() ?>>
		<?php echo $cases->JudgeID->selectOptionListHtml("x_JudgeID") ?>
	</select>
</div>
<?php echo $cases->JudgeID->Lookup->getParamTag("p_x_JudgeID") ?>
</div>
	</div>
<?php } ?>
<?php if ($cases->Notes->Visible) { // Notes ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $cases->Notes->caption() ?><?php echo ($cases->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php AppendClass($cases->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="cases" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($cases->Notes->getPlaceHolder()) ?>"<?php echo $cases->Notes->editAttributes() ?>><?php echo $cases->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fcasesaddopt", "x_Notes", 35, 4, <?php echo ($cases->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</div>
	</div>
<?php } ?>
<?php if ($cases->FileLocation->Visible) { // FileLocation ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_FileLocation"><?php echo $cases->FileLocation->caption() ?><?php echo ($cases->FileLocation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="cases" data-field="x_FileLocation" name="x_FileLocation" id="x_FileLocation" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($cases->FileLocation->getPlaceHolder()) ?>" value="<?php echo $cases->FileLocation->EditValue ?>"<?php echo $cases->FileLocation->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($cases->_Case->Visible) { // Case ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__Case"><?php echo $cases->_Case->caption() ?><?php echo ($cases->_Case->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="cases" data-field="x__Case" name="x__Case" id="x__Case" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->_Case->getPlaceHolder()) ?>" value="<?php echo $cases->_Case->EditValue ?>"<?php echo $cases->_Case->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($cases->CaseRegisteredDate->Visible) { // CaseRegisteredDate ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_CaseRegisteredDate"><?php echo $cases->CaseRegisteredDate->caption() ?><?php echo ($cases->CaseRegisteredDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="cases" data-field="x_CaseRegisteredDate" data-format="7" name="x_CaseRegisteredDate" id="x_CaseRegisteredDate" placeholder="<?php echo HtmlEncode($cases->CaseRegisteredDate->getPlaceHolder()) ?>" value="<?php echo $cases->CaseRegisteredDate->EditValue ?>"<?php echo $cases->CaseRegisteredDate->editAttributes() ?>>
<?php if (!$cases->CaseRegisteredDate->ReadOnly && !$cases->CaseRegisteredDate->Disabled && !isset($cases->CaseRegisteredDate->EditAttrs["readonly"]) && !isset($cases->CaseRegisteredDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcasesaddopt", "x_CaseRegisteredDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</div>
	</div>
<?php } ?>
<?php if ($cases->CaseStatusID->Visible) { // CaseStatusID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_CaseStatusID"><?php echo $cases->CaseStatusID->caption() ?><?php echo ($cases->CaseStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_CaseStatusID" data-value-separator="<?php echo $cases->CaseStatusID->displayValueSeparatorAttribute() ?>" id="x_CaseStatusID" name="x_CaseStatusID"<?php echo $cases->CaseStatusID->editAttributes() ?>>
		<?php echo $cases->CaseStatusID->selectOptionListHtml("x_CaseStatusID") ?>
	</select>
</div>
<?php echo $cases->CaseStatusID->Lookup->getParamTag("p_x_CaseStatusID") ?>
</div>
	</div>
<?php } ?>
<?php if ($cases->ParentCaseID->Visible) { // ParentCaseID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_ParentCaseID"><?php echo $cases->ParentCaseID->caption() ?><?php echo ($cases->ParentCaseID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="cases" data-field="x_ParentCaseID" name="x_ParentCaseID" id="x_ParentCaseID" size="30" placeholder="<?php echo HtmlEncode($cases->ParentCaseID->getPlaceHolder()) ?>" value="<?php echo $cases->ParentCaseID->EditValue ?>"<?php echo $cases->ParentCaseID->editAttributes() ?>>
</div>
	</div>
<?php } ?>
</form>
<?php
$cases_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$cases_addopt->terminate();
?>
