<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cases_add = new cases_add();

// Run the page
$cases_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cases_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fcasesadd = currentForm = new ew.Form("fcasesadd", "add");

// Validate form
fcasesadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($cases_add->ClientID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->ClientID->caption(), $cases->ClientID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->LitigantID->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->LitigantID->caption(), $cases->LitigantID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->CaseTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseTypeID->caption(), $cases->CaseTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->CourtID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CourtID->caption(), $cases->CourtID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->CaseNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseNumber->caption(), $cases->CaseNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->FileNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_FileNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->FileNumber->caption(), $cases->FileNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->ClientStatusID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientStatusID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->ClientStatusID->caption(), $cases->ClientStatusID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->LitigantStatusID->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantStatusID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->LitigantStatusID->caption(), $cases->LitigantStatusID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->JudgeID->Required) { ?>
			elm = this.getElements("x" + infix + "_JudgeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->JudgeID->caption(), $cases->JudgeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->Notes->caption(), $cases->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->FileLocation->Required) { ?>
			elm = this.getElements("x" + infix + "_FileLocation");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->FileLocation->caption(), $cases->FileLocation->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->_Case->Required) { ?>
			elm = this.getElements("x" + infix + "__Case");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->_Case->caption(), $cases->_Case->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->CaseSortID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseSortID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseSortID->caption(), $cases->CaseSortID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->CaseRegisteredDate->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseRegisteredDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseRegisteredDate->caption(), $cases->CaseRegisteredDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_CaseRegisteredDate");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cases->CaseRegisteredDate->errorMessage()) ?>");
		<?php if ($cases_add->CaseStatusID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseStatusID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseStatusID->caption(), $cases->CaseStatusID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_add->ParentCaseID->Required) { ?>
			elm = this.getElements("x" + infix + "_ParentCaseID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->ParentCaseID->caption(), $cases->ParentCaseID->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ParentCaseID");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cases->ParentCaseID->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcasesadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcasesadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcasesadd.lists["x_ClientID"] = <?php echo $cases_add->ClientID->Lookup->toClientList() ?>;
fcasesadd.lists["x_ClientID"].options = <?php echo JsonEncode($cases_add->ClientID->lookupOptions()) ?>;
fcasesadd.autoSuggests["x_ClientID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesadd.lists["x_LitigantID"] = <?php echo $cases_add->LitigantID->Lookup->toClientList() ?>;
fcasesadd.lists["x_LitigantID"].options = <?php echo JsonEncode($cases_add->LitigantID->lookupOptions()) ?>;
fcasesadd.autoSuggests["x_LitigantID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesadd.lists["x_CaseTypeID"] = <?php echo $cases_add->CaseTypeID->Lookup->toClientList() ?>;
fcasesadd.lists["x_CaseTypeID"].options = <?php echo JsonEncode($cases_add->CaseTypeID->lookupOptions()) ?>;
fcasesadd.lists["x_CourtID"] = <?php echo $cases_add->CourtID->Lookup->toClientList() ?>;
fcasesadd.lists["x_CourtID"].options = <?php echo JsonEncode($cases_add->CourtID->lookupOptions()) ?>;
fcasesadd.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesadd.lists["x_ClientStatusID"] = <?php echo $cases_add->ClientStatusID->Lookup->toClientList() ?>;
fcasesadd.lists["x_ClientStatusID"].options = <?php echo JsonEncode($cases_add->ClientStatusID->lookupOptions()) ?>;
fcasesadd.lists["x_LitigantStatusID"] = <?php echo $cases_add->LitigantStatusID->Lookup->toClientList() ?>;
fcasesadd.lists["x_LitigantStatusID"].options = <?php echo JsonEncode($cases_add->LitigantStatusID->lookupOptions()) ?>;
fcasesadd.lists["x_JudgeID"] = <?php echo $cases_add->JudgeID->Lookup->toClientList() ?>;
fcasesadd.lists["x_JudgeID"].options = <?php echo JsonEncode($cases_add->JudgeID->lookupOptions()) ?>;
fcasesadd.lists["x_CaseSortID"] = <?php echo $cases_add->CaseSortID->Lookup->toClientList() ?>;
fcasesadd.lists["x_CaseSortID"].options = <?php echo JsonEncode($cases_add->CaseSortID->lookupOptions()) ?>;
fcasesadd.lists["x_CaseStatusID"] = <?php echo $cases_add->CaseStatusID->Lookup->toClientList() ?>;
fcasesadd.lists["x_CaseStatusID"].options = <?php echo JsonEncode($cases_add->CaseStatusID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $cases_add->showPageHeader(); ?>
<?php
$cases_add->showMessage();
?>
<form name="fcasesadd" id="fcasesadd" class="<?php echo $cases_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cases_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cases_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cases">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$cases_add->IsModal ?>">
<?php if ($cases->getCurrentMasterTable() == "clients") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="clients">
<input type="hidden" name="fk_ClientID" value="<?php echo $cases->ClientID->getSessionValue() ?>">
<?php } ?>
<?php if ($cases->getCurrentMasterTable() == "litigants") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="litigants">
<input type="hidden" name="fk_LitigantID" value="<?php echo $cases->LitigantID->getSessionValue() ?>">
<?php } ?>
<?php if (!$cases_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_casesadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($cases->ClientID->Visible) { // ClientID ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_ClientID" class="form-group row">
		<label id="elh_cases_ClientID" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->ClientID->caption() ?><?php echo ($cases->ClientID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->ClientID->cellAttributes() ?>>
<?php if ($cases->ClientID->getSessionValue() <> "") { ?>
<span id="el_cases_ClientID">
<span<?php echo $cases->ClientID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->ClientID->ViewValue)) && $cases->ClientID->linkAttributes() <> "") { ?>
<a<?php echo $cases->ClientID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x_ClientID" name="x_ClientID" value="<?php echo HtmlEncode($cases->ClientID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_cases_ClientID">
<?php
$wrkonchange = "" . trim(@$cases->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientID" id="sv_x_ClientID" value="<?php echo RemoveHtml($cases->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>"<?php echo $cases->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->ClientID->ReadOnly || $cases->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "clients") && !$cases->ClientID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->ClientID->caption() ?>" data-title="<?php echo $cases->ClientID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientID',url:'clientsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->ClientID->displayValueSeparatorAttribute() ?>" name="x_ClientID" id="x_ClientID" value="<?php echo HtmlEncode($cases->ClientID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesadd.createAutoSuggest({"id":"x_ClientID","forceSelect":true});
</script>
<?php echo $cases->ClientID->Lookup->getParamTag("p_x_ClientID") ?>
</span>
<?php } ?>
<?php echo $cases->ClientID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientID">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_ClientID"><?php echo $cases->ClientID->caption() ?><?php echo ($cases->ClientID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->ClientID->cellAttributes() ?>>
<?php if ($cases->ClientID->getSessionValue() <> "") { ?>
<span id="el_cases_ClientID">
<span<?php echo $cases->ClientID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->ClientID->ViewValue)) && $cases->ClientID->linkAttributes() <> "") { ?>
<a<?php echo $cases->ClientID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x_ClientID" name="x_ClientID" value="<?php echo HtmlEncode($cases->ClientID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_cases_ClientID">
<?php
$wrkonchange = "" . trim(@$cases->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientID" id="sv_x_ClientID" value="<?php echo RemoveHtml($cases->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>"<?php echo $cases->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->ClientID->ReadOnly || $cases->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "clients") && !$cases->ClientID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->ClientID->caption() ?>" data-title="<?php echo $cases->ClientID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientID',url:'clientsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->ClientID->displayValueSeparatorAttribute() ?>" name="x_ClientID" id="x_ClientID" value="<?php echo HtmlEncode($cases->ClientID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesadd.createAutoSuggest({"id":"x_ClientID","forceSelect":true});
</script>
<?php echo $cases->ClientID->Lookup->getParamTag("p_x_ClientID") ?>
</span>
<?php } ?>
<?php echo $cases->ClientID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->LitigantID->Visible) { // LitigantID ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_LitigantID" class="form-group row">
		<label id="elh_cases_LitigantID" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->LitigantID->caption() ?><?php echo ($cases->LitigantID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->LitigantID->cellAttributes() ?>>
<?php if ($cases->LitigantID->getSessionValue() <> "") { ?>
<span id="el_cases_LitigantID">
<span<?php echo $cases->LitigantID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->LitigantID->ViewValue)) && $cases->LitigantID->linkAttributes() <> "") { ?>
<a<?php echo $cases->LitigantID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x_LitigantID" name="x_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_cases_LitigantID">
<?php
$wrkonchange = "" . trim(@$cases->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x_LitigantID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_LitigantID" id="sv_x_LitigantID" value="<?php echo RemoveHtml($cases->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>"<?php echo $cases->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_LitigantID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->LitigantID->ReadOnly || $cases->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "litigants") && !$cases->LitigantID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LitigantID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->LitigantID->caption() ?>" data-title="<?php echo $cases->LitigantID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LitigantID',url:'litigantsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->LitigantID->displayValueSeparatorAttribute() ?>" name="x_LitigantID" id="x_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesadd.createAutoSuggest({"id":"x_LitigantID","forceSelect":true});
</script>
<?php echo $cases->LitigantID->Lookup->getParamTag("p_x_LitigantID") ?>
</span>
<?php } ?>
<?php echo $cases->LitigantID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LitigantID">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_LitigantID"><?php echo $cases->LitigantID->caption() ?><?php echo ($cases->LitigantID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->LitigantID->cellAttributes() ?>>
<?php if ($cases->LitigantID->getSessionValue() <> "") { ?>
<span id="el_cases_LitigantID">
<span<?php echo $cases->LitigantID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->LitigantID->ViewValue)) && $cases->LitigantID->linkAttributes() <> "") { ?>
<a<?php echo $cases->LitigantID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x_LitigantID" name="x_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->CurrentValue) ?>">
<?php } else { ?>
<span id="el_cases_LitigantID">
<?php
$wrkonchange = "" . trim(@$cases->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x_LitigantID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_LitigantID" id="sv_x_LitigantID" value="<?php echo RemoveHtml($cases->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>"<?php echo $cases->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_LitigantID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->LitigantID->ReadOnly || $cases->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "litigants") && !$cases->LitigantID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LitigantID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->LitigantID->caption() ?>" data-title="<?php echo $cases->LitigantID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LitigantID',url:'litigantsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->LitigantID->displayValueSeparatorAttribute() ?>" name="x_LitigantID" id="x_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesadd.createAutoSuggest({"id":"x_LitigantID","forceSelect":true});
</script>
<?php echo $cases->LitigantID->Lookup->getParamTag("p_x_LitigantID") ?>
</span>
<?php } ?>
<?php echo $cases->LitigantID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CaseTypeID->Visible) { // CaseTypeID ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_CaseTypeID" class="form-group row">
		<label id="elh_cases_CaseTypeID" for="x_CaseTypeID" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->CaseTypeID->caption() ?><?php echo ($cases->CaseTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->CaseTypeID->cellAttributes() ?>>
<span id="el_cases_CaseTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_CaseTypeID" data-value-separator="<?php echo $cases->CaseTypeID->displayValueSeparatorAttribute() ?>" id="x_CaseTypeID" name="x_CaseTypeID"<?php echo $cases->CaseTypeID->editAttributes() ?>>
		<?php echo $cases->CaseTypeID->selectOptionListHtml("x_CaseTypeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casetypes") && !$cases->CaseTypeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseTypeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CaseTypeID->caption() ?>" data-title="<?php echo $cases->CaseTypeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseTypeID',url:'casetypesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->CaseTypeID->Lookup->getParamTag("p_x_CaseTypeID") ?>
</span>
<?php echo $cases->CaseTypeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseTypeID">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_CaseTypeID"><?php echo $cases->CaseTypeID->caption() ?><?php echo ($cases->CaseTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->CaseTypeID->cellAttributes() ?>>
<span id="el_cases_CaseTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_CaseTypeID" data-value-separator="<?php echo $cases->CaseTypeID->displayValueSeparatorAttribute() ?>" id="x_CaseTypeID" name="x_CaseTypeID"<?php echo $cases->CaseTypeID->editAttributes() ?>>
		<?php echo $cases->CaseTypeID->selectOptionListHtml("x_CaseTypeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casetypes") && !$cases->CaseTypeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseTypeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CaseTypeID->caption() ?>" data-title="<?php echo $cases->CaseTypeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseTypeID',url:'casetypesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->CaseTypeID->Lookup->getParamTag("p_x_CaseTypeID") ?>
</span>
<?php echo $cases->CaseTypeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CourtID->Visible) { // CourtID ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_CourtID" class="form-group row">
		<label id="elh_cases_CourtID" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->CourtID->caption() ?><?php echo ($cases->CourtID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->CourtID->cellAttributes() ?>>
<span id="el_cases_CourtID">
<?php
$wrkonchange = "" . trim(@$cases->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($cases->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>"<?php echo $cases->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->CourtID->ReadOnly || $cases->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$cases->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CourtID->caption() ?>" data-title="<?php echo $cases->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($cases->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesadd.createAutoSuggest({"id":"x_CourtID","forceSelect":true});
</script>
<?php echo $cases->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</span>
<?php echo $cases->CourtID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtID">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_CourtID"><?php echo $cases->CourtID->caption() ?><?php echo ($cases->CourtID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->CourtID->cellAttributes() ?>>
<span id="el_cases_CourtID">
<?php
$wrkonchange = "" . trim(@$cases->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($cases->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>"<?php echo $cases->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->CourtID->ReadOnly || $cases->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$cases->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CourtID->caption() ?>" data-title="<?php echo $cases->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($cases->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesadd.createAutoSuggest({"id":"x_CourtID","forceSelect":true});
</script>
<?php echo $cases->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</span>
<?php echo $cases->CourtID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CaseNumber->Visible) { // CaseNumber ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_CaseNumber" class="form-group row">
		<label id="elh_cases_CaseNumber" for="x_CaseNumber" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->CaseNumber->caption() ?><?php echo ($cases->CaseNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->CaseNumber->cellAttributes() ?>>
<span id="el_cases_CaseNumber">
<input type="text" data-table="cases" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases->CaseNumber->EditValue ?>"<?php echo $cases->CaseNumber->editAttributes() ?>>
</span>
<?php echo $cases->CaseNumber->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseNumber">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_CaseNumber"><?php echo $cases->CaseNumber->caption() ?><?php echo ($cases->CaseNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->CaseNumber->cellAttributes() ?>>
<span id="el_cases_CaseNumber">
<input type="text" data-table="cases" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases->CaseNumber->EditValue ?>"<?php echo $cases->CaseNumber->editAttributes() ?>>
</span>
<?php echo $cases->CaseNumber->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->FileNumber->Visible) { // FileNumber ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_FileNumber" class="form-group row">
		<label id="elh_cases_FileNumber" for="x_FileNumber" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->FileNumber->caption() ?><?php echo ($cases->FileNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->FileNumber->cellAttributes() ?>>
<span id="el_cases_FileNumber">
<input type="text" data-table="cases" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases->FileNumber->EditValue ?>"<?php echo $cases->FileNumber->editAttributes() ?>>
</span>
<?php echo $cases->FileNumber->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_FileNumber">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_FileNumber"><?php echo $cases->FileNumber->caption() ?><?php echo ($cases->FileNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->FileNumber->cellAttributes() ?>>
<span id="el_cases_FileNumber">
<input type="text" data-table="cases" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases->FileNumber->EditValue ?>"<?php echo $cases->FileNumber->editAttributes() ?>>
</span>
<?php echo $cases->FileNumber->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->ClientStatusID->Visible) { // ClientStatusID ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_ClientStatusID" class="form-group row">
		<label id="elh_cases_ClientStatusID" for="x_ClientStatusID" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->ClientStatusID->caption() ?><?php echo ($cases->ClientStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->ClientStatusID->cellAttributes() ?>>
<span id="el_cases_ClientStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_ClientStatusID" data-value-separator="<?php echo $cases->ClientStatusID->displayValueSeparatorAttribute() ?>" id="x_ClientStatusID" name="x_ClientStatusID"<?php echo $cases->ClientStatusID->editAttributes() ?>>
		<?php echo $cases->ClientStatusID->selectOptionListHtml("x_ClientStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases->ClientStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->ClientStatusID->caption() ?>" data-title="<?php echo $cases->ClientStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->ClientStatusID->Lookup->getParamTag("p_x_ClientStatusID") ?>
</span>
<?php echo $cases->ClientStatusID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientStatusID">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_ClientStatusID"><?php echo $cases->ClientStatusID->caption() ?><?php echo ($cases->ClientStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->ClientStatusID->cellAttributes() ?>>
<span id="el_cases_ClientStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_ClientStatusID" data-value-separator="<?php echo $cases->ClientStatusID->displayValueSeparatorAttribute() ?>" id="x_ClientStatusID" name="x_ClientStatusID"<?php echo $cases->ClientStatusID->editAttributes() ?>>
		<?php echo $cases->ClientStatusID->selectOptionListHtml("x_ClientStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases->ClientStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->ClientStatusID->caption() ?>" data-title="<?php echo $cases->ClientStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->ClientStatusID->Lookup->getParamTag("p_x_ClientStatusID") ?>
</span>
<?php echo $cases->ClientStatusID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->LitigantStatusID->Visible) { // LitigantStatusID ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_LitigantStatusID" class="form-group row">
		<label id="elh_cases_LitigantStatusID" for="x_LitigantStatusID" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->LitigantStatusID->caption() ?><?php echo ($cases->LitigantStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->LitigantStatusID->cellAttributes() ?>>
<span id="el_cases_LitigantStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_LitigantStatusID" data-value-separator="<?php echo $cases->LitigantStatusID->displayValueSeparatorAttribute() ?>" id="x_LitigantStatusID" name="x_LitigantStatusID"<?php echo $cases->LitigantStatusID->editAttributes() ?>>
		<?php echo $cases->LitigantStatusID->selectOptionListHtml("x_LitigantStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases->LitigantStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LitigantStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->LitigantStatusID->caption() ?>" data-title="<?php echo $cases->LitigantStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LitigantStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->LitigantStatusID->Lookup->getParamTag("p_x_LitigantStatusID") ?>
</span>
<?php echo $cases->LitigantStatusID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LitigantStatusID">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_LitigantStatusID"><?php echo $cases->LitigantStatusID->caption() ?><?php echo ($cases->LitigantStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->LitigantStatusID->cellAttributes() ?>>
<span id="el_cases_LitigantStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_LitigantStatusID" data-value-separator="<?php echo $cases->LitigantStatusID->displayValueSeparatorAttribute() ?>" id="x_LitigantStatusID" name="x_LitigantStatusID"<?php echo $cases->LitigantStatusID->editAttributes() ?>>
		<?php echo $cases->LitigantStatusID->selectOptionListHtml("x_LitigantStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases->LitigantStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LitigantStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->LitigantStatusID->caption() ?>" data-title="<?php echo $cases->LitigantStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LitigantStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->LitigantStatusID->Lookup->getParamTag("p_x_LitigantStatusID") ?>
</span>
<?php echo $cases->LitigantStatusID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->JudgeID->Visible) { // JudgeID ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_JudgeID" class="form-group row">
		<label id="elh_cases_JudgeID" for="x_JudgeID" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->JudgeID->caption() ?><?php echo ($cases->JudgeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->JudgeID->cellAttributes() ?>>
<span id="el_cases_JudgeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_JudgeID" data-value-separator="<?php echo $cases->JudgeID->displayValueSeparatorAttribute() ?>" id="x_JudgeID" name="x_JudgeID"<?php echo $cases->JudgeID->editAttributes() ?>>
		<?php echo $cases->JudgeID->selectOptionListHtml("x_JudgeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "judges") && !$cases->JudgeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_JudgeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->JudgeID->caption() ?>" data-title="<?php echo $cases->JudgeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_JudgeID',url:'judgesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->JudgeID->Lookup->getParamTag("p_x_JudgeID") ?>
</span>
<?php echo $cases->JudgeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_JudgeID">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_JudgeID"><?php echo $cases->JudgeID->caption() ?><?php echo ($cases->JudgeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->JudgeID->cellAttributes() ?>>
<span id="el_cases_JudgeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_JudgeID" data-value-separator="<?php echo $cases->JudgeID->displayValueSeparatorAttribute() ?>" id="x_JudgeID" name="x_JudgeID"<?php echo $cases->JudgeID->editAttributes() ?>>
		<?php echo $cases->JudgeID->selectOptionListHtml("x_JudgeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "judges") && !$cases->JudgeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_JudgeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->JudgeID->caption() ?>" data-title="<?php echo $cases->JudgeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_JudgeID',url:'judgesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->JudgeID->Lookup->getParamTag("p_x_JudgeID") ?>
</span>
<?php echo $cases->JudgeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->Notes->Visible) { // Notes ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_cases_Notes" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->Notes->caption() ?><?php echo ($cases->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->Notes->cellAttributes() ?>>
<span id="el_cases_Notes">
<?php AppendClass($cases->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="cases" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($cases->Notes->getPlaceHolder()) ?>"<?php echo $cases->Notes->editAttributes() ?>><?php echo $cases->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fcasesadd", "x_Notes", 35, 4, <?php echo ($cases->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $cases->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_Notes"><?php echo $cases->Notes->caption() ?><?php echo ($cases->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->Notes->cellAttributes() ?>>
<span id="el_cases_Notes">
<?php AppendClass($cases->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="cases" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($cases->Notes->getPlaceHolder()) ?>"<?php echo $cases->Notes->editAttributes() ?>><?php echo $cases->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fcasesadd", "x_Notes", 35, 4, <?php echo ($cases->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $cases->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->FileLocation->Visible) { // FileLocation ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_FileLocation" class="form-group row">
		<label id="elh_cases_FileLocation" for="x_FileLocation" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->FileLocation->caption() ?><?php echo ($cases->FileLocation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->FileLocation->cellAttributes() ?>>
<span id="el_cases_FileLocation">
<input type="text" data-table="cases" data-field="x_FileLocation" name="x_FileLocation" id="x_FileLocation" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($cases->FileLocation->getPlaceHolder()) ?>" value="<?php echo $cases->FileLocation->EditValue ?>"<?php echo $cases->FileLocation->editAttributes() ?>>
</span>
<?php echo $cases->FileLocation->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_FileLocation">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_FileLocation"><?php echo $cases->FileLocation->caption() ?><?php echo ($cases->FileLocation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->FileLocation->cellAttributes() ?>>
<span id="el_cases_FileLocation">
<input type="text" data-table="cases" data-field="x_FileLocation" name="x_FileLocation" id="x_FileLocation" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($cases->FileLocation->getPlaceHolder()) ?>" value="<?php echo $cases->FileLocation->EditValue ?>"<?php echo $cases->FileLocation->editAttributes() ?>>
</span>
<?php echo $cases->FileLocation->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->_Case->Visible) { // Case ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r__Case" class="form-group row">
		<label id="elh_cases__Case" for="x__Case" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->_Case->caption() ?><?php echo ($cases->_Case->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->_Case->cellAttributes() ?>>
<span id="el_cases__Case">
<input type="text" data-table="cases" data-field="x__Case" name="x__Case" id="x__Case" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->_Case->getPlaceHolder()) ?>" value="<?php echo $cases->_Case->EditValue ?>"<?php echo $cases->_Case->editAttributes() ?>>
</span>
<?php echo $cases->_Case->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r__Case">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases__Case"><?php echo $cases->_Case->caption() ?><?php echo ($cases->_Case->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->_Case->cellAttributes() ?>>
<span id="el_cases__Case">
<input type="text" data-table="cases" data-field="x__Case" name="x__Case" id="x__Case" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->_Case->getPlaceHolder()) ?>" value="<?php echo $cases->_Case->EditValue ?>"<?php echo $cases->_Case->editAttributes() ?>>
</span>
<?php echo $cases->_Case->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CaseSortID->Visible) { // CaseSortID ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_CaseSortID" class="form-group row">
		<label id="elh_cases_CaseSortID" for="x_CaseSortID" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->CaseSortID->caption() ?><?php echo ($cases->CaseSortID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->CaseSortID->cellAttributes() ?>>
<span id="el_cases_CaseSortID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_CaseSortID" data-value-separator="<?php echo $cases->CaseSortID->displayValueSeparatorAttribute() ?>" id="x_CaseSortID" name="x_CaseSortID"<?php echo $cases->CaseSortID->editAttributes() ?>>
		<?php echo $cases->CaseSortID->selectOptionListHtml("x_CaseSortID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casesort") && !$cases->CaseSortID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseSortID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CaseSortID->caption() ?>" data-title="<?php echo $cases->CaseSortID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseSortID',url:'casesortaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->CaseSortID->Lookup->getParamTag("p_x_CaseSortID") ?>
</span>
<?php echo $cases->CaseSortID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseSortID">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_CaseSortID"><?php echo $cases->CaseSortID->caption() ?><?php echo ($cases->CaseSortID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->CaseSortID->cellAttributes() ?>>
<span id="el_cases_CaseSortID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_CaseSortID" data-value-separator="<?php echo $cases->CaseSortID->displayValueSeparatorAttribute() ?>" id="x_CaseSortID" name="x_CaseSortID"<?php echo $cases->CaseSortID->editAttributes() ?>>
		<?php echo $cases->CaseSortID->selectOptionListHtml("x_CaseSortID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casesort") && !$cases->CaseSortID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseSortID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CaseSortID->caption() ?>" data-title="<?php echo $cases->CaseSortID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseSortID',url:'casesortaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->CaseSortID->Lookup->getParamTag("p_x_CaseSortID") ?>
</span>
<?php echo $cases->CaseSortID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CaseRegisteredDate->Visible) { // CaseRegisteredDate ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_CaseRegisteredDate" class="form-group row">
		<label id="elh_cases_CaseRegisteredDate" for="x_CaseRegisteredDate" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->CaseRegisteredDate->caption() ?><?php echo ($cases->CaseRegisteredDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->CaseRegisteredDate->cellAttributes() ?>>
<span id="el_cases_CaseRegisteredDate">
<input type="text" data-table="cases" data-field="x_CaseRegisteredDate" data-format="7" name="x_CaseRegisteredDate" id="x_CaseRegisteredDate" placeholder="<?php echo HtmlEncode($cases->CaseRegisteredDate->getPlaceHolder()) ?>" value="<?php echo $cases->CaseRegisteredDate->EditValue ?>"<?php echo $cases->CaseRegisteredDate->editAttributes() ?>>
<?php if (!$cases->CaseRegisteredDate->ReadOnly && !$cases->CaseRegisteredDate->Disabled && !isset($cases->CaseRegisteredDate->EditAttrs["readonly"]) && !isset($cases->CaseRegisteredDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcasesadd", "x_CaseRegisteredDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $cases->CaseRegisteredDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseRegisteredDate">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_CaseRegisteredDate"><?php echo $cases->CaseRegisteredDate->caption() ?><?php echo ($cases->CaseRegisteredDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->CaseRegisteredDate->cellAttributes() ?>>
<span id="el_cases_CaseRegisteredDate">
<input type="text" data-table="cases" data-field="x_CaseRegisteredDate" data-format="7" name="x_CaseRegisteredDate" id="x_CaseRegisteredDate" placeholder="<?php echo HtmlEncode($cases->CaseRegisteredDate->getPlaceHolder()) ?>" value="<?php echo $cases->CaseRegisteredDate->EditValue ?>"<?php echo $cases->CaseRegisteredDate->editAttributes() ?>>
<?php if (!$cases->CaseRegisteredDate->ReadOnly && !$cases->CaseRegisteredDate->Disabled && !isset($cases->CaseRegisteredDate->EditAttrs["readonly"]) && !isset($cases->CaseRegisteredDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcasesadd", "x_CaseRegisteredDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $cases->CaseRegisteredDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->CaseStatusID->Visible) { // CaseStatusID ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_CaseStatusID" class="form-group row">
		<label id="elh_cases_CaseStatusID" for="x_CaseStatusID" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->CaseStatusID->caption() ?><?php echo ($cases->CaseStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->CaseStatusID->cellAttributes() ?>>
<span id="el_cases_CaseStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_CaseStatusID" data-value-separator="<?php echo $cases->CaseStatusID->displayValueSeparatorAttribute() ?>" id="x_CaseStatusID" name="x_CaseStatusID"<?php echo $cases->CaseStatusID->editAttributes() ?>>
		<?php echo $cases->CaseStatusID->selectOptionListHtml("x_CaseStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casestatus") && !$cases->CaseStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CaseStatusID->caption() ?>" data-title="<?php echo $cases->CaseStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseStatusID',url:'casestatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->CaseStatusID->Lookup->getParamTag("p_x_CaseStatusID") ?>
</span>
<?php echo $cases->CaseStatusID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseStatusID">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_CaseStatusID"><?php echo $cases->CaseStatusID->caption() ?><?php echo ($cases->CaseStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->CaseStatusID->cellAttributes() ?>>
<span id="el_cases_CaseStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_CaseStatusID" data-value-separator="<?php echo $cases->CaseStatusID->displayValueSeparatorAttribute() ?>" id="x_CaseStatusID" name="x_CaseStatusID"<?php echo $cases->CaseStatusID->editAttributes() ?>>
		<?php echo $cases->CaseStatusID->selectOptionListHtml("x_CaseStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casestatus") && !$cases->CaseStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CaseStatusID->caption() ?>" data-title="<?php echo $cases->CaseStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseStatusID',url:'casestatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->CaseStatusID->Lookup->getParamTag("p_x_CaseStatusID") ?>
</span>
<?php echo $cases->CaseStatusID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases->ParentCaseID->Visible) { // ParentCaseID ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
	<div id="r_ParentCaseID" class="form-group row">
		<label id="elh_cases_ParentCaseID" for="x_ParentCaseID" class="<?php echo $cases_add->LeftColumnClass ?>"><?php echo $cases->ParentCaseID->caption() ?><?php echo ($cases->ParentCaseID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases_add->RightColumnClass ?>"><div<?php echo $cases->ParentCaseID->cellAttributes() ?>>
<span id="el_cases_ParentCaseID">
<input type="text" data-table="cases" data-field="x_ParentCaseID" name="x_ParentCaseID" id="x_ParentCaseID" size="30" placeholder="<?php echo HtmlEncode($cases->ParentCaseID->getPlaceHolder()) ?>" value="<?php echo $cases->ParentCaseID->EditValue ?>"<?php echo $cases->ParentCaseID->editAttributes() ?>>
</span>
<?php echo $cases->ParentCaseID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ParentCaseID">
		<td class="<?php echo $cases_add->TableLeftColumnClass ?>"><span id="elh_cases_ParentCaseID"><?php echo $cases->ParentCaseID->caption() ?><?php echo ($cases->ParentCaseID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases->ParentCaseID->cellAttributes() ?>>
<span id="el_cases_ParentCaseID">
<input type="text" data-table="cases" data-field="x_ParentCaseID" name="x_ParentCaseID" id="x_ParentCaseID" size="30" placeholder="<?php echo HtmlEncode($cases->ParentCaseID->getPlaceHolder()) ?>" value="<?php echo $cases->ParentCaseID->EditValue ?>"<?php echo $cases->ParentCaseID->editAttributes() ?>>
</span>
<?php echo $cases->ParentCaseID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if ($cases->getCurrentDetailTable() <> "") { ?>
<?php
	$cases_add->DetailPages->ValidKeys = explode(",", $cases->getCurrentDetailTable());
	$firstActiveDetailTable = $cases_add->DetailPages->activePageIndex();
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav-tabs" id="cases_add_details"><!-- tabs -->
	<ul class="<?php echo $cases_add->DetailPages->navStyle() ?>"><!-- .nav -->
<?php
	if (in_array("hearings", explode(",", $cases->getCurrentDetailTable())) && $hearings->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "hearings") {
			$firstActiveDetailTable = "hearings";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $cases_add->DetailPages->pageStyle("hearings") ?>" href="#tab_hearings" data-toggle="tab"><?php echo $Language->TablePhrase("hearings", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("notices", explode(",", $cases->getCurrentDetailTable())) && $notices->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "notices") {
			$firstActiveDetailTable = "notices";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $cases_add->DetailPages->pageStyle("notices") ?>" href="#tab_notices" data-toggle="tab"><?php echo $Language->TablePhrase("notices", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("complaints", explode(",", $cases->getCurrentDetailTable())) && $complaints->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "complaints") {
			$firstActiveDetailTable = "complaints";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $cases_add->DetailPages->pageStyle("complaints") ?>" href="#tab_complaints" data-toggle="tab"><?php echo $Language->TablePhrase("complaints", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("notifications", explode(",", $cases->getCurrentDetailTable())) && $notifications->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "notifications") {
			$firstActiveDetailTable = "notifications";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $cases_add->DetailPages->pageStyle("notifications") ?>" href="#tab_notifications" data-toggle="tab"><?php echo $Language->TablePhrase("notifications", "TblCaption") ?></a></li>
<?php
	}
?>
<?php
	if (in_array("attachments", explode(",", $cases->getCurrentDetailTable())) && $attachments->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "attachments") {
			$firstActiveDetailTable = "attachments";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $cases_add->DetailPages->pageStyle("attachments") ?>" href="#tab_attachments" data-toggle="tab"><?php echo $Language->TablePhrase("attachments", "TblCaption") ?></a></li>
<?php
	}
?>
	</ul><!-- /.nav -->
	<div class="tab-content"><!-- .tab-content -->
<?php
	if (in_array("hearings", explode(",", $cases->getCurrentDetailTable())) && $hearings->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "hearings")
			$firstActiveDetailTable = "hearings";
?>
		<div class="tab-pane<?php echo $cases_add->DetailPages->pageStyle("hearings") ?>" id="tab_hearings"><!-- page* -->
<?php include_once "hearingsgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("notices", explode(",", $cases->getCurrentDetailTable())) && $notices->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "notices")
			$firstActiveDetailTable = "notices";
?>
		<div class="tab-pane<?php echo $cases_add->DetailPages->pageStyle("notices") ?>" id="tab_notices"><!-- page* -->
<?php include_once "noticesgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("complaints", explode(",", $cases->getCurrentDetailTable())) && $complaints->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "complaints")
			$firstActiveDetailTable = "complaints";
?>
		<div class="tab-pane<?php echo $cases_add->DetailPages->pageStyle("complaints") ?>" id="tab_complaints"><!-- page* -->
<?php include_once "complaintsgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("notifications", explode(",", $cases->getCurrentDetailTable())) && $notifications->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "notifications")
			$firstActiveDetailTable = "notifications";
?>
		<div class="tab-pane<?php echo $cases_add->DetailPages->pageStyle("notifications") ?>" id="tab_notifications"><!-- page* -->
<?php include_once "notificationsgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("attachments", explode(",", $cases->getCurrentDetailTable())) && $attachments->DetailAdd) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "attachments")
			$firstActiveDetailTable = "attachments";
?>
		<div class="tab-pane<?php echo $cases_add->DetailPages->pageStyle("attachments") ?>" id="tab_attachments"><!-- page* -->
<?php include_once "attachmentsgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
	</div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
<?php if (!$cases_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $cases_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $cases_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$cases_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$cases_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$cases_add->terminate();
?>
