<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$branches_list = new branches_list();

// Run the page
$branches_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$branches_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$branches->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fbrancheslist = currentForm = new ew.Form("fbrancheslist", "list");
fbrancheslist.formKeyCountName = '<?php echo $branches_list->FormKeyCountName ?>';

// Form_CustomValidate event
fbrancheslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbrancheslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbrancheslist.lists["x_LawFirmID"] = <?php echo $branches_list->LawFirmID->Lookup->toClientList() ?>;
fbrancheslist.lists["x_LawFirmID"].options = <?php echo JsonEncode($branches_list->LawFirmID->lookupOptions()) ?>;
fbrancheslist.lists["x_Activated[]"] = <?php echo $branches_list->Activated->Lookup->toClientList() ?>;
fbrancheslist.lists["x_Activated[]"].options = <?php echo JsonEncode($branches_list->Activated->options(FALSE, TRUE)) ?>;

// Form object for search
var fbrancheslistsrch = currentSearchForm = new ew.Form("fbrancheslistsrch");

// Validate function for search
fbrancheslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fbrancheslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbrancheslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbrancheslistsrch.lists["x_Activated[]"] = <?php echo $branches_list->Activated->Lookup->toClientList() ?>;
fbrancheslistsrch.lists["x_Activated[]"].options = <?php echo JsonEncode($branches_list->Activated->options(FALSE, TRUE)) ?>;

// Filters
fbrancheslistsrch.filterList = <?php echo $branches_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$branches->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($branches_list->TotalRecs > 0 && $branches_list->ExportOptions->visible()) { ?>
<?php $branches_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($branches_list->ImportOptions->visible()) { ?>
<?php $branches_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($branches_list->SearchOptions->visible()) { ?>
<?php $branches_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($branches_list->FilterOptions->visible()) { ?>
<?php $branches_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$branches_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$branches->isExport() && !$branches->CurrentAction) { ?>
<form name="fbrancheslistsrch" id="fbrancheslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($branches_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fbrancheslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="branches">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$branches_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$branches->RowType = ROWTYPE_SEARCH;

// Render row
$branches->resetAttributes();
$branches_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($branches->Activated->Visible) { // Activated ?>
	<div id="xsc_Activated" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $branches->Activated->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Activated" id="z_Activated" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($branches->Activated->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="branches" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $branches->Activated->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($branches_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($branches_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $branches_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($branches_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($branches_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($branches_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($branches_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $branches_list->showPageHeader(); ?>
<?php
$branches_list->showMessage();
?>
<?php if ($branches_list->TotalRecs > 0 || $branches->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($branches_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> branches">
<?php if (!$branches->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$branches->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($branches_list->Pager)) $branches_list->Pager = new PrevNextPager($branches_list->StartRec, $branches_list->DisplayRecs, $branches_list->TotalRecs, $branches_list->AutoHidePager) ?>
<?php if ($branches_list->Pager->RecordCount > 0 && $branches_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($branches_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $branches_list->pageUrl() ?>start=<?php echo $branches_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($branches_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $branches_list->pageUrl() ?>start=<?php echo $branches_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $branches_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($branches_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $branches_list->pageUrl() ?>start=<?php echo $branches_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($branches_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $branches_list->pageUrl() ?>start=<?php echo $branches_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $branches_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($branches_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $branches_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $branches_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $branches_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($branches_list->TotalRecs > 0 && (!$branches_list->AutoHidePageSizeSelector || $branches_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="branches">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($branches_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($branches_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($branches_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($branches_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($branches_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($branches_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($branches_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($branches_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($branches_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($branches->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $branches_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fbrancheslist" id="fbrancheslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($branches_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $branches_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="branches">
<div id="gmp_branches" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($branches_list->TotalRecs > 0 || $branches->isGridEdit()) { ?>
<table id="tbl_brancheslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$branches_list->RowType = ROWTYPE_HEADER;

// Render list options
$branches_list->renderListOptions();

// Render list options (header, left)
$branches_list->ListOptions->render("header", "left");
?>
<?php if ($branches->Branch->Visible) { // Branch ?>
	<?php if ($branches->sortUrl($branches->Branch) == "") { ?>
		<th data-name="Branch" class="<?php echo $branches->Branch->headerCellClass() ?>"><div id="elh_branches_Branch" class="branches_Branch"><div class="ew-table-header-caption"><?php echo $branches->Branch->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Branch" class="<?php echo $branches->Branch->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $branches->SortUrl($branches->Branch) ?>',2);"><div id="elh_branches_Branch" class="branches_Branch">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $branches->Branch->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($branches->Branch->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($branches->Branch->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($branches->BranchEn->Visible) { // BranchEn ?>
	<?php if ($branches->sortUrl($branches->BranchEn) == "") { ?>
		<th data-name="BranchEn" class="<?php echo $branches->BranchEn->headerCellClass() ?>"><div id="elh_branches_BranchEn" class="branches_BranchEn"><div class="ew-table-header-caption"><?php echo $branches->BranchEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="BranchEn" class="<?php echo $branches->BranchEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $branches->SortUrl($branches->BranchEn) ?>',2);"><div id="elh_branches_BranchEn" class="branches_BranchEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $branches->BranchEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($branches->BranchEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($branches->BranchEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($branches->LawFirmID->Visible) { // LawFirmID ?>
	<?php if ($branches->sortUrl($branches->LawFirmID) == "") { ?>
		<th data-name="LawFirmID" class="<?php echo $branches->LawFirmID->headerCellClass() ?>"><div id="elh_branches_LawFirmID" class="branches_LawFirmID"><div class="ew-table-header-caption"><?php echo $branches->LawFirmID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LawFirmID" class="<?php echo $branches->LawFirmID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $branches->SortUrl($branches->LawFirmID) ?>',2);"><div id="elh_branches_LawFirmID" class="branches_LawFirmID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $branches->LawFirmID->caption() ?></span><span class="ew-table-header-sort"><?php if ($branches->LawFirmID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($branches->LawFirmID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($branches->Activated->Visible) { // Activated ?>
	<?php if ($branches->sortUrl($branches->Activated) == "") { ?>
		<th data-name="Activated" class="<?php echo $branches->Activated->headerCellClass() ?>"><div id="elh_branches_Activated" class="branches_Activated"><div class="ew-table-header-caption"><?php echo $branches->Activated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Activated" class="<?php echo $branches->Activated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $branches->SortUrl($branches->Activated) ?>',2);"><div id="elh_branches_Activated" class="branches_Activated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $branches->Activated->caption() ?></span><span class="ew-table-header-sort"><?php if ($branches->Activated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($branches->Activated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$branches_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($branches->ExportAll && $branches->isExport()) {
	$branches_list->StopRec = $branches_list->TotalRecs;
} else {

	// Set the last record to display
	if ($branches_list->TotalRecs > $branches_list->StartRec + $branches_list->DisplayRecs - 1)
		$branches_list->StopRec = $branches_list->StartRec + $branches_list->DisplayRecs - 1;
	else
		$branches_list->StopRec = $branches_list->TotalRecs;
}
$branches_list->RecCnt = $branches_list->StartRec - 1;
if ($branches_list->Recordset && !$branches_list->Recordset->EOF) {
	$branches_list->Recordset->moveFirst();
	$selectLimit = $branches_list->UseSelectLimit;
	if (!$selectLimit && $branches_list->StartRec > 1)
		$branches_list->Recordset->move($branches_list->StartRec - 1);
} elseif (!$branches->AllowAddDeleteRow && $branches_list->StopRec == 0) {
	$branches_list->StopRec = $branches->GridAddRowCount;
}

// Initialize aggregate
$branches->RowType = ROWTYPE_AGGREGATEINIT;
$branches->resetAttributes();
$branches_list->renderRow();
while ($branches_list->RecCnt < $branches_list->StopRec) {
	$branches_list->RecCnt++;
	if ($branches_list->RecCnt >= $branches_list->StartRec) {
		$branches_list->RowCnt++;

		// Set up key count
		$branches_list->KeyCount = $branches_list->RowIndex;

		// Init row class and style
		$branches->resetAttributes();
		$branches->CssClass = "";
		if ($branches->isGridAdd()) {
		} else {
			$branches_list->loadRowValues($branches_list->Recordset); // Load row values
		}
		$branches->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$branches->RowAttrs = array_merge($branches->RowAttrs, array('data-rowindex'=>$branches_list->RowCnt, 'id'=>'r' . $branches_list->RowCnt . '_branches', 'data-rowtype'=>$branches->RowType));

		// Render row
		$branches_list->renderRow();

		// Render list options
		$branches_list->renderListOptions();
?>
	<tr<?php echo $branches->rowAttributes() ?>>
<?php

// Render list options (body, left)
$branches_list->ListOptions->render("body", "left", $branches_list->RowCnt);
?>
	<?php if ($branches->Branch->Visible) { // Branch ?>
		<td data-name="Branch"<?php echo $branches->Branch->cellAttributes() ?>>
<span id="el<?php echo $branches_list->RowCnt ?>_branches_Branch" class="branches_Branch">
<span<?php echo $branches->Branch->viewAttributes() ?>>
<?php echo $branches->Branch->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($branches->BranchEn->Visible) { // BranchEn ?>
		<td data-name="BranchEn"<?php echo $branches->BranchEn->cellAttributes() ?>>
<span id="el<?php echo $branches_list->RowCnt ?>_branches_BranchEn" class="branches_BranchEn">
<span<?php echo $branches->BranchEn->viewAttributes() ?>>
<?php echo $branches->BranchEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($branches->LawFirmID->Visible) { // LawFirmID ?>
		<td data-name="LawFirmID"<?php echo $branches->LawFirmID->cellAttributes() ?>>
<span id="el<?php echo $branches_list->RowCnt ?>_branches_LawFirmID" class="branches_LawFirmID">
<span<?php echo $branches->LawFirmID->viewAttributes() ?>>
<?php echo $branches->LawFirmID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($branches->Activated->Visible) { // Activated ?>
		<td data-name="Activated"<?php echo $branches->Activated->cellAttributes() ?>>
<span id="el<?php echo $branches_list->RowCnt ?>_branches_Activated" class="branches_Activated">
<span<?php echo $branches->Activated->viewAttributes() ?>>
<?php if (ConvertToBool($branches->Activated->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $branches->Activated->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $branches->Activated->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$branches_list->ListOptions->render("body", "right", $branches_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$branches->isGridAdd())
		$branches_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$branches->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($branches_list->Recordset)
	$branches_list->Recordset->Close();
?>
<?php if (!$branches->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$branches->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($branches_list->Pager)) $branches_list->Pager = new PrevNextPager($branches_list->StartRec, $branches_list->DisplayRecs, $branches_list->TotalRecs, $branches_list->AutoHidePager) ?>
<?php if ($branches_list->Pager->RecordCount > 0 && $branches_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($branches_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $branches_list->pageUrl() ?>start=<?php echo $branches_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($branches_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $branches_list->pageUrl() ?>start=<?php echo $branches_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $branches_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($branches_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $branches_list->pageUrl() ?>start=<?php echo $branches_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($branches_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $branches_list->pageUrl() ?>start=<?php echo $branches_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $branches_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($branches_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $branches_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $branches_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $branches_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($branches_list->TotalRecs > 0 && (!$branches_list->AutoHidePageSizeSelector || $branches_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="branches">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($branches_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($branches_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($branches_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($branches_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($branches_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($branches_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($branches_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($branches_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($branches_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($branches->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $branches_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($branches_list->TotalRecs == 0 && !$branches->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $branches_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$branches_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$branches->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$branches->isExport()) { ?>
<script>
ew.scrollableTable("gmp_branches", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$branches_list->terminate();
?>
