<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$addresstype_list = new addresstype_list();

// Run the page
$addresstype_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$addresstype_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$addresstype->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var faddresstypelist = currentForm = new ew.Form("faddresstypelist", "list");
faddresstypelist.formKeyCountName = '<?php echo $addresstype_list->FormKeyCountName ?>';

// Form_CustomValidate event
faddresstypelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faddresstypelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var faddresstypelistsrch = currentSearchForm = new ew.Form("faddresstypelistsrch");

// Filters
faddresstypelistsrch.filterList = <?php echo $addresstype_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$addresstype->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($addresstype_list->TotalRecs > 0 && $addresstype_list->ExportOptions->visible()) { ?>
<?php $addresstype_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($addresstype_list->ImportOptions->visible()) { ?>
<?php $addresstype_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($addresstype_list->SearchOptions->visible()) { ?>
<?php $addresstype_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($addresstype_list->FilterOptions->visible()) { ?>
<?php $addresstype_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$addresstype_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$addresstype->isExport() && !$addresstype->CurrentAction) { ?>
<form name="faddresstypelistsrch" id="faddresstypelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($addresstype_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="faddresstypelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="addresstype">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($addresstype_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($addresstype_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $addresstype_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($addresstype_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($addresstype_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($addresstype_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($addresstype_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $addresstype_list->showPageHeader(); ?>
<?php
$addresstype_list->showMessage();
?>
<?php if ($addresstype_list->TotalRecs > 0 || $addresstype->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($addresstype_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> addresstype">
<?php if (!$addresstype->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$addresstype->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($addresstype_list->Pager)) $addresstype_list->Pager = new PrevNextPager($addresstype_list->StartRec, $addresstype_list->DisplayRecs, $addresstype_list->TotalRecs, $addresstype_list->AutoHidePager) ?>
<?php if ($addresstype_list->Pager->RecordCount > 0 && $addresstype_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($addresstype_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $addresstype_list->pageUrl() ?>start=<?php echo $addresstype_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($addresstype_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $addresstype_list->pageUrl() ?>start=<?php echo $addresstype_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $addresstype_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($addresstype_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $addresstype_list->pageUrl() ?>start=<?php echo $addresstype_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($addresstype_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $addresstype_list->pageUrl() ?>start=<?php echo $addresstype_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $addresstype_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($addresstype_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $addresstype_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $addresstype_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $addresstype_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($addresstype_list->TotalRecs > 0 && (!$addresstype_list->AutoHidePageSizeSelector || $addresstype_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="addresstype">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($addresstype_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($addresstype_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($addresstype_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($addresstype_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($addresstype_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($addresstype_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($addresstype_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($addresstype_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($addresstype_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($addresstype->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $addresstype_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="faddresstypelist" id="faddresstypelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($addresstype_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $addresstype_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="addresstype">
<div id="gmp_addresstype" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($addresstype_list->TotalRecs > 0 || $addresstype->isGridEdit()) { ?>
<table id="tbl_addresstypelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$addresstype_list->RowType = ROWTYPE_HEADER;

// Render list options
$addresstype_list->renderListOptions();

// Render list options (header, left)
$addresstype_list->ListOptions->render("header", "left");
?>
<?php if ($addresstype->AddressTypeID->Visible) { // AddressTypeID ?>
	<?php if ($addresstype->sortUrl($addresstype->AddressTypeID) == "") { ?>
		<th data-name="AddressTypeID" class="<?php echo $addresstype->AddressTypeID->headerCellClass() ?>"><div id="elh_addresstype_AddressTypeID" class="addresstype_AddressTypeID"><div class="ew-table-header-caption"><?php echo $addresstype->AddressTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AddressTypeID" class="<?php echo $addresstype->AddressTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $addresstype->SortUrl($addresstype->AddressTypeID) ?>',2);"><div id="elh_addresstype_AddressTypeID" class="addresstype_AddressTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $addresstype->AddressTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($addresstype->AddressTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($addresstype->AddressTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($addresstype->AddressType->Visible) { // AddressType ?>
	<?php if ($addresstype->sortUrl($addresstype->AddressType) == "") { ?>
		<th data-name="AddressType" class="<?php echo $addresstype->AddressType->headerCellClass() ?>"><div id="elh_addresstype_AddressType" class="addresstype_AddressType"><div class="ew-table-header-caption"><?php echo $addresstype->AddressType->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AddressType" class="<?php echo $addresstype->AddressType->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $addresstype->SortUrl($addresstype->AddressType) ?>',2);"><div id="elh_addresstype_AddressType" class="addresstype_AddressType">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $addresstype->AddressType->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($addresstype->AddressType->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($addresstype->AddressType->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($addresstype->AddressTypeEn->Visible) { // AddressTypeEn ?>
	<?php if ($addresstype->sortUrl($addresstype->AddressTypeEn) == "") { ?>
		<th data-name="AddressTypeEn" class="<?php echo $addresstype->AddressTypeEn->headerCellClass() ?>"><div id="elh_addresstype_AddressTypeEn" class="addresstype_AddressTypeEn"><div class="ew-table-header-caption"><?php echo $addresstype->AddressTypeEn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AddressTypeEn" class="<?php echo $addresstype->AddressTypeEn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $addresstype->SortUrl($addresstype->AddressTypeEn) ?>',2);"><div id="elh_addresstype_AddressTypeEn" class="addresstype_AddressTypeEn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $addresstype->AddressTypeEn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($addresstype->AddressTypeEn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($addresstype->AddressTypeEn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($addresstype->Notes->Visible) { // Notes ?>
	<?php if ($addresstype->sortUrl($addresstype->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $addresstype->Notes->headerCellClass() ?>"><div id="elh_addresstype_Notes" class="addresstype_Notes"><div class="ew-table-header-caption"><?php echo $addresstype->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $addresstype->Notes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $addresstype->SortUrl($addresstype->Notes) ?>',2);"><div id="elh_addresstype_Notes" class="addresstype_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $addresstype->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($addresstype->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($addresstype->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$addresstype_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($addresstype->ExportAll && $addresstype->isExport()) {
	$addresstype_list->StopRec = $addresstype_list->TotalRecs;
} else {

	// Set the last record to display
	if ($addresstype_list->TotalRecs > $addresstype_list->StartRec + $addresstype_list->DisplayRecs - 1)
		$addresstype_list->StopRec = $addresstype_list->StartRec + $addresstype_list->DisplayRecs - 1;
	else
		$addresstype_list->StopRec = $addresstype_list->TotalRecs;
}
$addresstype_list->RecCnt = $addresstype_list->StartRec - 1;
if ($addresstype_list->Recordset && !$addresstype_list->Recordset->EOF) {
	$addresstype_list->Recordset->moveFirst();
	$selectLimit = $addresstype_list->UseSelectLimit;
	if (!$selectLimit && $addresstype_list->StartRec > 1)
		$addresstype_list->Recordset->move($addresstype_list->StartRec - 1);
} elseif (!$addresstype->AllowAddDeleteRow && $addresstype_list->StopRec == 0) {
	$addresstype_list->StopRec = $addresstype->GridAddRowCount;
}

// Initialize aggregate
$addresstype->RowType = ROWTYPE_AGGREGATEINIT;
$addresstype->resetAttributes();
$addresstype_list->renderRow();
while ($addresstype_list->RecCnt < $addresstype_list->StopRec) {
	$addresstype_list->RecCnt++;
	if ($addresstype_list->RecCnt >= $addresstype_list->StartRec) {
		$addresstype_list->RowCnt++;

		// Set up key count
		$addresstype_list->KeyCount = $addresstype_list->RowIndex;

		// Init row class and style
		$addresstype->resetAttributes();
		$addresstype->CssClass = "";
		if ($addresstype->isGridAdd()) {
		} else {
			$addresstype_list->loadRowValues($addresstype_list->Recordset); // Load row values
		}
		$addresstype->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$addresstype->RowAttrs = array_merge($addresstype->RowAttrs, array('data-rowindex'=>$addresstype_list->RowCnt, 'id'=>'r' . $addresstype_list->RowCnt . '_addresstype', 'data-rowtype'=>$addresstype->RowType));

		// Render row
		$addresstype_list->renderRow();

		// Render list options
		$addresstype_list->renderListOptions();
?>
	<tr<?php echo $addresstype->rowAttributes() ?>>
<?php

// Render list options (body, left)
$addresstype_list->ListOptions->render("body", "left", $addresstype_list->RowCnt);
?>
	<?php if ($addresstype->AddressTypeID->Visible) { // AddressTypeID ?>
		<td data-name="AddressTypeID"<?php echo $addresstype->AddressTypeID->cellAttributes() ?>>
<span id="el<?php echo $addresstype_list->RowCnt ?>_addresstype_AddressTypeID" class="addresstype_AddressTypeID">
<span<?php echo $addresstype->AddressTypeID->viewAttributes() ?>>
<?php echo $addresstype->AddressTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($addresstype->AddressType->Visible) { // AddressType ?>
		<td data-name="AddressType"<?php echo $addresstype->AddressType->cellAttributes() ?>>
<span id="el<?php echo $addresstype_list->RowCnt ?>_addresstype_AddressType" class="addresstype_AddressType">
<span<?php echo $addresstype->AddressType->viewAttributes() ?>>
<?php echo $addresstype->AddressType->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($addresstype->AddressTypeEn->Visible) { // AddressTypeEn ?>
		<td data-name="AddressTypeEn"<?php echo $addresstype->AddressTypeEn->cellAttributes() ?>>
<span id="el<?php echo $addresstype_list->RowCnt ?>_addresstype_AddressTypeEn" class="addresstype_AddressTypeEn">
<span<?php echo $addresstype->AddressTypeEn->viewAttributes() ?>>
<?php echo $addresstype->AddressTypeEn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($addresstype->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $addresstype->Notes->cellAttributes() ?>>
<span id="el<?php echo $addresstype_list->RowCnt ?>_addresstype_Notes" class="addresstype_Notes">
<span<?php echo $addresstype->Notes->viewAttributes() ?>>
<?php echo $addresstype->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$addresstype_list->ListOptions->render("body", "right", $addresstype_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$addresstype->isGridAdd())
		$addresstype_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$addresstype->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($addresstype_list->Recordset)
	$addresstype_list->Recordset->Close();
?>
<?php if (!$addresstype->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$addresstype->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($addresstype_list->Pager)) $addresstype_list->Pager = new PrevNextPager($addresstype_list->StartRec, $addresstype_list->DisplayRecs, $addresstype_list->TotalRecs, $addresstype_list->AutoHidePager) ?>
<?php if ($addresstype_list->Pager->RecordCount > 0 && $addresstype_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($addresstype_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $addresstype_list->pageUrl() ?>start=<?php echo $addresstype_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($addresstype_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $addresstype_list->pageUrl() ?>start=<?php echo $addresstype_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $addresstype_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($addresstype_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $addresstype_list->pageUrl() ?>start=<?php echo $addresstype_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($addresstype_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $addresstype_list->pageUrl() ?>start=<?php echo $addresstype_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $addresstype_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($addresstype_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $addresstype_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $addresstype_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $addresstype_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($addresstype_list->TotalRecs > 0 && (!$addresstype_list->AutoHidePageSizeSelector || $addresstype_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="addresstype">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($addresstype_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($addresstype_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($addresstype_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($addresstype_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($addresstype_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($addresstype_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($addresstype_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($addresstype_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($addresstype_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($addresstype->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $addresstype_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($addresstype_list->TotalRecs == 0 && !$addresstype->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $addresstype_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$addresstype_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$addresstype->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$addresstype->isExport()) { ?>
<script>
ew.scrollableTable("gmp_addresstype", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$addresstype_list->terminate();
?>
