<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$address_delete = new address_delete();

// Run the page
$address_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$address_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var faddressdelete = currentForm = new ew.Form("faddressdelete", "delete");

// Form_CustomValidate event
faddressdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faddressdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faddressdelete.lists["x_AddressTypeID"] = <?php echo $address_delete->AddressTypeID->Lookup->toClientList() ?>;
faddressdelete.lists["x_AddressTypeID"].options = <?php echo JsonEncode($address_delete->AddressTypeID->lookupOptions()) ?>;
faddressdelete.lists["x_Primary[]"] = <?php echo $address_delete->Primary->Lookup->toClientList() ?>;
faddressdelete.lists["x_Primary[]"].options = <?php echo JsonEncode($address_delete->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $address_delete->showPageHeader(); ?>
<?php
$address_delete->showMessage();
?>
<form name="faddressdelete" id="faddressdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($address_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $address_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="address">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($address_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($address->AddressID->Visible) { // AddressID ?>
		<th class="<?php echo $address->AddressID->headerCellClass() ?>"><span id="elh_address_AddressID" class="address_AddressID"><?php echo $address->AddressID->caption() ?></span></th>
<?php } ?>
<?php if ($address->AddressTypeID->Visible) { // AddressTypeID ?>
		<th class="<?php echo $address->AddressTypeID->headerCellClass() ?>"><span id="elh_address_AddressTypeID" class="address_AddressTypeID"><?php echo $address->AddressTypeID->caption() ?></span></th>
<?php } ?>
<?php if ($address->Address->Visible) { // Address ?>
		<th class="<?php echo $address->Address->headerCellClass() ?>"><span id="elh_address_Address" class="address_Address"><?php echo $address->Address->caption() ?></span></th>
<?php } ?>
<?php if ($address->City->Visible) { // City ?>
		<th class="<?php echo $address->City->headerCellClass() ?>"><span id="elh_address_City" class="address_City"><?php echo $address->City->caption() ?></span></th>
<?php } ?>
<?php if ($address->Region->Visible) { // Region ?>
		<th class="<?php echo $address->Region->headerCellClass() ?>"><span id="elh_address_Region" class="address_Region"><?php echo $address->Region->caption() ?></span></th>
<?php } ?>
<?php if ($address->PostalCode->Visible) { // PostalCode ?>
		<th class="<?php echo $address->PostalCode->headerCellClass() ?>"><span id="elh_address_PostalCode" class="address_PostalCode"><?php echo $address->PostalCode->caption() ?></span></th>
<?php } ?>
<?php if ($address->Country->Visible) { // Country ?>
		<th class="<?php echo $address->Country->headerCellClass() ?>"><span id="elh_address_Country" class="address_Country"><?php echo $address->Country->caption() ?></span></th>
<?php } ?>
<?php if ($address->Notes->Visible) { // Notes ?>
		<th class="<?php echo $address->Notes->headerCellClass() ?>"><span id="elh_address_Notes" class="address_Notes"><?php echo $address->Notes->caption() ?></span></th>
<?php } ?>
<?php if ($address->Primary->Visible) { // Primary ?>
		<th class="<?php echo $address->Primary->headerCellClass() ?>"><span id="elh_address_Primary" class="address_Primary"><?php echo $address->Primary->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$address_delete->RecCnt = 0;
$i = 0;
while (!$address_delete->Recordset->EOF) {
	$address_delete->RecCnt++;
	$address_delete->RowCnt++;

	// Set row properties
	$address->resetAttributes();
	$address->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$address_delete->loadRowValues($address_delete->Recordset);

	// Render row
	$address_delete->renderRow();
?>
	<tr<?php echo $address->rowAttributes() ?>>
<?php if ($address->AddressID->Visible) { // AddressID ?>
		<td<?php echo $address->AddressID->cellAttributes() ?>>
<span id="el<?php echo $address_delete->RowCnt ?>_address_AddressID" class="address_AddressID">
<span<?php echo $address->AddressID->viewAttributes() ?>>
<?php echo $address->AddressID->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($address->AddressTypeID->Visible) { // AddressTypeID ?>
		<td<?php echo $address->AddressTypeID->cellAttributes() ?>>
<span id="el<?php echo $address_delete->RowCnt ?>_address_AddressTypeID" class="address_AddressTypeID">
<span<?php echo $address->AddressTypeID->viewAttributes() ?>>
<?php echo $address->AddressTypeID->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($address->Address->Visible) { // Address ?>
		<td<?php echo $address->Address->cellAttributes() ?>>
<span id="el<?php echo $address_delete->RowCnt ?>_address_Address" class="address_Address">
<span<?php echo $address->Address->viewAttributes() ?>>
<?php echo $address->Address->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($address->City->Visible) { // City ?>
		<td<?php echo $address->City->cellAttributes() ?>>
<span id="el<?php echo $address_delete->RowCnt ?>_address_City" class="address_City">
<span<?php echo $address->City->viewAttributes() ?>>
<?php echo $address->City->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($address->Region->Visible) { // Region ?>
		<td<?php echo $address->Region->cellAttributes() ?>>
<span id="el<?php echo $address_delete->RowCnt ?>_address_Region" class="address_Region">
<span<?php echo $address->Region->viewAttributes() ?>>
<?php echo $address->Region->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($address->PostalCode->Visible) { // PostalCode ?>
		<td<?php echo $address->PostalCode->cellAttributes() ?>>
<span id="el<?php echo $address_delete->RowCnt ?>_address_PostalCode" class="address_PostalCode">
<span<?php echo $address->PostalCode->viewAttributes() ?>>
<?php echo $address->PostalCode->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($address->Country->Visible) { // Country ?>
		<td<?php echo $address->Country->cellAttributes() ?>>
<span id="el<?php echo $address_delete->RowCnt ?>_address_Country" class="address_Country">
<span<?php echo $address->Country->viewAttributes() ?>>
<?php echo $address->Country->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($address->Notes->Visible) { // Notes ?>
		<td<?php echo $address->Notes->cellAttributes() ?>>
<span id="el<?php echo $address_delete->RowCnt ?>_address_Notes" class="address_Notes">
<span<?php echo $address->Notes->viewAttributes() ?>>
<?php echo $address->Notes->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($address->Primary->Visible) { // Primary ?>
		<td<?php echo $address->Primary->cellAttributes() ?>>
<span id="el<?php echo $address_delete->RowCnt ?>_address_Primary" class="address_Primary">
<span<?php echo $address->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($address->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $address->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $address->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$address_delete->Recordset->moveNext();
}
$address_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $address_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$address_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$address_delete->terminate();
?>
