<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$Courts_Report_report = new Courts_Report_report();

// Run the page
$Courts_Report_report->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$Courts_Report_report->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$Courts_Report->isExport()) { ?>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php
$Courts_Report_report->DefaultFilter = "";
$Courts_Report_report->ReportFilter = $Courts_Report_report->DefaultFilter;
if (!$Security->canReport()) {
	if ($Courts_Report_report->ReportFilter <> "") $Courts_Report_report->ReportFilter .= " AND ";
	$Courts_Report_report->ReportFilter .= "(0=1)";
}
if ($Courts_Report_report->DbDetailFilter <> "") {
	if ($Courts_Report_report->ReportFilter <> "") $Courts_Report_report->ReportFilter .= " AND ";
	$Courts_Report_report->ReportFilter .= "(" . $Courts_Report_report->DbDetailFilter . ")";
}
$ReportConn = &$Courts_Report_report->getConnection();

// Set up filter and load group level SQL
$Courts_Report->CurrentFilter = $Courts_Report_report->ReportFilter;
$Courts_Report_report->ReportSql = $Courts_Report->getGroupSql();

// Load recordset
$Courts_Report_report->Recordset = $ReportConn->Execute($Courts_Report_report->ReportSql);
$Courts_Report_report->RecordExists = !$Courts_Report_report->Recordset->EOF;
?>
<?php if (!$Courts_Report->isExport()) { ?>
<?php if ($Courts_Report_report->RecordExists) { ?>
<div class="ew-view-export-options"><?php $Courts_Report_report->ExportOptions->render("body") ?></div>
<?php } ?>
<?php } ?>
<?php $Courts_Report_report->showPageHeader(); ?>
<table class="ew-report-table">
<?php

// Get First Row
if ($Courts_Report_report->RecordExists) {
	$Courts_Report->CourtType->setDbValue($Courts_Report_report->Recordset->fields('CourtType'));
	$Courts_Report_report->ReportGroups[0] = $Courts_Report->CourtType->DbValue;
	$Courts_Report->Governorate->setDbValue($Courts_Report_report->Recordset->fields('Governorate'));
	$Courts_Report_report->ReportGroups[1] = $Courts_Report->Governorate->DbValue;
	$Courts_Report->CourtLocation->setDbValue($Courts_Report_report->Recordset->fields('CourtLocation'));
	$Courts_Report_report->ReportGroups[2] = $Courts_Report->CourtLocation->DbValue;
}
$Courts_Report_report->RecCnt = 0;
$Courts_Report_report->ReportCounts[0] = 0;
$Courts_Report_report->checkLevelBreak();
while (!$Courts_Report_report->Recordset->EOF) {

	// Render for view
	$Courts_Report->RowType = ROWTYPE_VIEW;
	$Courts_Report->resetAttributes();
	$Courts_Report_report->renderRow();

	// Show group headers
	if ($Courts_Report_report->LevelBreak[1]) { // Reset counter and aggregation
?>
	<tr><td colspan=3 class="ew-group-field"><?php echo $Courts_Report->CourtType->caption() ?></td>
	<td colspan="3" class="ew-group-name">
<span<?php echo $Courts_Report->CourtType->viewAttributes() ?>>
<?php echo $Courts_Report->CourtType->getViewValue() ?></span>
</td></tr>
<?php
	}
	if ($Courts_Report_report->LevelBreak[2]) { // Reset counter and aggregation
?>
	<tr><td><div class="ew-group-indent"></div></td><td colspan=2 class="ew-group-field"><?php echo $Courts_Report->Governorate->caption() ?></td>
	<td colspan="3" class="ew-group-name">
<span<?php echo $Courts_Report->Governorate->viewAttributes() ?>>
<?php echo $Courts_Report->Governorate->getViewValue() ?></span>
</td></tr>
<?php
	}
	if ($Courts_Report_report->LevelBreak[3]) { // Reset counter and aggregation
?>
	<tr><td><div class="ew-group-indent"></div></td><td><div class="ew-group-indent"></div></td><td class="ew-group-field"><?php echo $Courts_Report->CourtLocation->caption() ?></td>
	<td colspan="3" class="ew-group-name">
<span<?php echo $Courts_Report->CourtLocation->viewAttributes() ?>>
<?php echo $Courts_Report->CourtLocation->getViewValue() ?></span>
</td></tr>
<?php
	}

	// Get detail records
	$Courts_Report_report->ReportFilter = $Courts_Report_report->DefaultFilter;
	if ($Courts_Report_report->ReportFilter <> "") $Courts_Report_report->ReportFilter .= " AND ";
	if ($Courts_Report->CourtType->CurrentValue == NULL) {
		$Courts_Report_report->ReportFilter .= "(`CourtType` IS NULL)";
	} else {
		$Courts_Report_report->ReportFilter .= "(`CourtType` = " . QuotedValue($Courts_Report->CourtType->CurrentValue, DATATYPE_STRING, $Courts_Report_report->Dbid) . ")";
	}
	if ($Courts_Report_report->ReportFilter <> "") $Courts_Report_report->ReportFilter .= " AND ";
	if ($Courts_Report->Governorate->CurrentValue == NULL) {
		$Courts_Report_report->ReportFilter .= "(`Governorate` IS NULL)";
	} else {
		$Courts_Report_report->ReportFilter .= "(`Governorate` = " . QuotedValue($Courts_Report->Governorate->CurrentValue, DATATYPE_STRING, $Courts_Report_report->Dbid) . ")";
	}
	if ($Courts_Report_report->ReportFilter <> "") $Courts_Report_report->ReportFilter .= " AND ";
	if ($Courts_Report->CourtLocation->CurrentValue == NULL) {
		$Courts_Report_report->ReportFilter .= "(`CourtLocation` IS NULL)";
	} else {
		$Courts_Report_report->ReportFilter .= "(`CourtLocation` = " . QuotedValue($Courts_Report->CourtLocation->CurrentValue, DATATYPE_STRING, $Courts_Report_report->Dbid) . ")";
	}
	if ($Courts_Report_report->DbDetailFilter <> "") {
		if ($Courts_Report_report->ReportFilter <> "")
			$Courts_Report_report->ReportFilter .= " AND ";
		$Courts_Report_report->ReportFilter .= "(" . $Courts_Report_report->DbDetailFilter . ")";
	}
	if (!$Security->canReport()) {
		if ($Courts_Report_report->ReportFilter <> "")
			$Courts_Report_report->ReportFilter .= " AND ";
		$Courts_Report_report->ReportFilter .= "(0=1)";
	}

	// Set up detail SQL
	$Courts_Report->CurrentFilter = $Courts_Report_report->ReportFilter;
	$Courts_Report_report->ReportSql = $Courts_Report->getDetailSql();

	// Load detail records
	$Courts_Report_report->DetailRecordset = $ReportConn->execute($Courts_Report_report->ReportSql);
	$Courts_Report_report->DtlRecordCount = $Courts_Report_report->DetailRecordset->RecordCount();

	// Initialize aggregates
	if (!$Courts_Report_report->DetailRecordset->EOF) {
		$Courts_Report_report->RecCnt++;
	}
	if ($Courts_Report_report->RecCnt == 1) {
		$Courts_Report_report->ReportCounts[0] = 0;
	}
	for ($i = 1; $i <= 3; $i++) {
		if ($Courts_Report_report->LevelBreak[$i]) { // Reset counter and aggregation
			$Courts_Report_report->ReportCounts[$i] = 0;
		}
	}
	$Courts_Report_report->ReportCounts[0] += $Courts_Report_report->DtlRecordCount;
	$Courts_Report_report->ReportCounts[1] += $Courts_Report_report->DtlRecordCount;
	$Courts_Report_report->ReportCounts[2] += $Courts_Report_report->DtlRecordCount;
	$Courts_Report_report->ReportCounts[3] += $Courts_Report_report->DtlRecordCount;
	if ($Courts_Report_report->RecordExists) {
?>
	<tr>
		<td><div class="ew-group-indent"></div></td>
		<td><div class="ew-group-indent"></div></td>
		<td><div class="ew-group-indent"></div></td>
		<td class="ew-group-header"><?php echo $Courts_Report->Chamber->caption() ?></td>
		<td class="ew-group-header"><?php echo $Courts_Report->SectionEn->caption() ?></td>
		<td class="ew-group-header"><?php echo $Courts_Report->Court->caption() ?></td>
	</tr>
<?php
	}
	while (!$Courts_Report_report->DetailRecordset->EOF) {
		$Courts_Report_report->RowCnt++;
		$Courts_Report->Chamber->setDbValue($Courts_Report_report->DetailRecordset->fields('Chamber'));
		$Courts_Report->SectionEn->setDbValue($Courts_Report_report->DetailRecordset->fields('SectionEn'));
		$Courts_Report->Court->setDbValue($Courts_Report_report->DetailRecordset->fields('Court'));

		// Render for view
		$Courts_Report->RowType = ROWTYPE_VIEW;
		$Courts_Report->resetAttributes();
		$Courts_Report_report->renderRow();
?>
	<tr>
		<td><div class="ew-group-indent"></div></td>
		<td><div class="ew-group-indent"></div></td>
		<td><div class="ew-group-indent"></div></td>
		<td<?php echo $Courts_Report->Chamber->cellAttributes() ?>>
<span<?php echo $Courts_Report->Chamber->viewAttributes() ?>>
<?php echo $Courts_Report->Chamber->getViewValue() ?></span>
</td>
		<td<?php echo $Courts_Report->SectionEn->cellAttributes() ?>>
<span<?php echo $Courts_Report->SectionEn->viewAttributes() ?>>
<?php echo $Courts_Report->SectionEn->getViewValue() ?></span>
</td>
		<td<?php echo $Courts_Report->Court->cellAttributes() ?>>
<span<?php echo $Courts_Report->Court->viewAttributes() ?>>
<?php echo $Courts_Report->Court->getViewValue() ?></span>
</td>
	</tr>
<?php
		$Courts_Report_report->DetailRecordset->moveNext();
	}
	$Courts_Report_report->DetailRecordset->close();

	// Save old group data
	$Courts_Report_report->ReportGroups[0] = $Courts_Report->CourtType->CurrentValue;
	$Courts_Report_report->ReportGroups[1] = $Courts_Report->Governorate->CurrentValue;
	$Courts_Report_report->ReportGroups[2] = $Courts_Report->CourtLocation->CurrentValue;

	// Get next record
	$Courts_Report_report->Recordset->moveNext();
	if ($Courts_Report_report->Recordset->EOF) {
		$Courts_Report_report->RecCnt = 0; // EOF, force all level breaks
	} else {
		$Courts_Report->CourtType->setDbValue($Courts_Report_report->Recordset->fields('CourtType'));
		$Courts_Report->Governorate->setDbValue($Courts_Report_report->Recordset->fields('Governorate'));
		$Courts_Report->CourtLocation->setDbValue($Courts_Report_report->Recordset->fields('CourtLocation'));
	}
	$Courts_Report_report->checkLevelBreak();

	// Show footers
	if ($Courts_Report_report->LevelBreak[3]) {
		$Courts_Report->CourtLocation->CurrentValue = $Courts_Report_report->ReportGroups[2];

		// Render row for view
		$Courts_Report->RowType = ROWTYPE_VIEW;
		$Courts_Report->resetAttributes();
		$Courts_Report_report->renderRow();
		$Courts_Report->CourtLocation->CurrentValue = $Courts_Report->CourtLocation->DbValue;
?>
<?php
}
	if ($Courts_Report_report->LevelBreak[2]) {
		$Courts_Report->Governorate->CurrentValue = $Courts_Report_report->ReportGroups[1];

		// Render row for view
		$Courts_Report->RowType = ROWTYPE_VIEW;
		$Courts_Report->resetAttributes();
		$Courts_Report_report->renderRow();
		$Courts_Report->Governorate->CurrentValue = $Courts_Report->Governorate->DbValue;
?>
	<tr><td><div class="ew-group-indent"></div></td><td colspan=5 class="ew-group-summary"><?php echo $Language->Phrase("RptSumHead") ?>&nbsp;<?php echo $Courts_Report->Governorate->caption() ?>:&nbsp;<?php echo $Courts_Report->Governorate->ViewValue ?> (<?php echo FormatNumber($Courts_Report_report->ReportCounts[2],0) ?> <?php echo $Language->Phrase("RptDtlRec") ?>)</td></tr>
	<tr><td colspan=6>&nbsp;<br></td></tr>
<?php
}
	if ($Courts_Report_report->LevelBreak[1]) {
		$Courts_Report->CourtType->CurrentValue = $Courts_Report_report->ReportGroups[0];

		// Render row for view
		$Courts_Report->RowType = ROWTYPE_VIEW;
		$Courts_Report->resetAttributes();
		$Courts_Report_report->renderRow();
		$Courts_Report->CourtType->CurrentValue = $Courts_Report->CourtType->DbValue;
?>
	<tr><td colspan=6 class="ew-group-summary"><?php echo $Language->Phrase("RptSumHead") ?>&nbsp;<?php echo $Courts_Report->CourtType->caption() ?>:&nbsp;<?php echo $Courts_Report->CourtType->ViewValue ?> (<?php echo FormatNumber($Courts_Report_report->ReportCounts[1],0) ?> <?php echo $Language->Phrase("RptDtlRec") ?>)</td></tr>
	<tr><td colspan=6>&nbsp;<br></td></tr>
<?php
}
}

// Close recordset
$Courts_Report_report->Recordset->close();
?>
<?php if ($Courts_Report_report->RecordExists) { ?>
	<tr><td colspan="6">&nbsp;<br></td></tr>
	<tr><td colspan="6" class="ew-grand-summary"><?php echo $Language->Phrase("RptGrandTotal") ?>&nbsp;(<?php echo FormatNumber($Courts_Report_report->ReportCounts[0], 0) ?>&nbsp;<?php echo $Language->Phrase("RptDtlRec") ?>)</td></tr>
<?php } ?>
<?php if ($Courts_Report_report->RecordExists) { ?>
	<tr><td colspan=6>&nbsp;<br></td></tr>
<?php } else { ?>
	<tr><td><?php echo $Language->phrase("NoRecord") ?></td></tr>
<?php } ?>
</table>
<?php
$Courts_Report_report->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$Courts_Report->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$Courts_Report_report->terminate();
?>
